/*
 * GroupsPanel.java
 *
 * Created on May 30, 2007, 2:03 PM
 */

package org.netbeans.modules.worklist.editor.multiview.assignment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.wlm.model.api.Group;
import org.netbeans.modules.wlm.model.api.TAssignment;
import org.netbeans.modules.wlm.model.api.WLMComponentFactory;
import org.netbeans.modules.wlm.model.api.WLMModel;
import org.netbeans.modules.worklist.dataloader.WorklistDataObject;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;

/**
 *
 * @author  radval
 */
public class GroupsPanel extends SectionInnerPanel {
    
     private WorklistDataObject dObj;
    
     private GroupsTableModel groupsTableModel;
     
     private TAssignment assignment;
    
     /** Creates new form GroupsPanel */
    public GroupsPanel(SectionView sectionView, 
                       WorklistDataObject dObj) {
        super(sectionView);
        this.dObj=dObj;
        initComponents();
        initGUI();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        groupsTable = new javax.swing.JTable();
        addButton = new javax.swing.JButton();
        removeButton = new javax.swing.JButton();

        groupsTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane1.setViewportView(groupsTable);

        addButton.setLabel(org.openide.util.NbBundle.getMessage(GroupsPanel.class, "GroupsPanel.addButton.label")); // NOI18N
        addButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addButtonActionPerformed(evt);
            }
        });

        removeButton.setLabel(org.openide.util.NbBundle.getMessage(GroupsPanel.class, "GroupsPanel.removeButton.label")); // NOI18N
        removeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 375, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(layout.createSequentialGroup()
                        .add(addButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(removeButton)))
                .addContainerGap(15, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 105, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(addButton)
                    .add(removeButton))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

private void removeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeButtonActionPerformed
     int selectedRow = groupsTable.getSelectedRow();
    groupsTableModel.removeRow(selectedRow);
}//GEN-LAST:event_removeButtonActionPerformed

private void addButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addButtonActionPerformed
    groupsTableModel.addNewRow();
    if(groupsTableModel.getRowCount() != 0) {
        groupsTable.setRowSelectionInterval(groupsTableModel.getRowCount() -1, groupsTableModel.getRowCount()-1);
    }
}//GEN-LAST:event_addButtonActionPerformed
    
     public void linkButtonPressed(Object ddBean, String property) {
    }
    
    public javax.swing.JComponent getErrorComponent(String name) {
        return null;
    }
    
    public void setValue(JComponent source, Object value)  {
        
    }
    
    public void documentChanged(javax.swing.text.JTextComponent comp, String value) {
    }
    
    public void rollbackValue(javax.swing.text.JTextComponent source) {
    }
    
    private void initGUI() {
        groupsTableModel = new GroupsTableModel();
        groupsTable.setModel(groupsTableModel);
        groupsTable.setTableHeader(null);
        
        groupsTable.getSelectionModel().addListSelectionListener(new GroupsTableListSelectionListener());
        dObj.getModel().addComponentListener(new AssignmentComponentListener());
    }
    
    public void refreshGroups(TAssignment assignment) {
        this.assignment = assignment;
        groupsTableModel.clear();
        if(assignment != null) {
        
            List<Group> groups = assignment.getGroups();
            if(groups != null) {
                Iterator <Group> itGroup = groups.iterator();
                while(itGroup.hasNext()) {
                    Group group = itGroup.next();
                    groupsTableModel.addNewGroup(group);
                }
            }
        }
        
    }
      
    class GroupsTableListSelectionListener implements ListSelectionListener {

        public void valueChanged(ListSelectionEvent e) {
             int selectedRows = groupsTable.getSelectedRowCount();
             boolean rowSelected = selectedRows != 0 ? true : false;
             removeButton.setEnabled(rowSelected);
        }
        
    }
    class GroupsTableModel extends AbstractTableModel {

        private List<Group> groups = new ArrayList<Group>();
        
        public int getRowCount() {
            return groups.size();
        }

        public int getColumnCount() {
            return 1;
        }

        public void clear() {
            this.groups.clear();
        }
        
        public Object getValueAt(int rowIndex, int columnIndex) {
            Group group = groups.get(rowIndex);
            if(group != null) {
                return group.getContent();
            }
            return "";
        }
        
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Group group = groups.get(rowIndex);
            if(group != null) {
                WLMModel model = dObj.getModel();
                if(model != null) {
                    model.startTransaction();
                    group.setContent((String) aValue);
                    model.endTransaction();
                }
            }
        }
         
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
         
         public void addNewGroup(Group group) {
            if(group != null) {
                groups.add(group);
                fireTableDataChanged();
            }
        }
         
        public void addNewRow() {
            WLMModel model = dObj.getModel();
            if(model != null && assignment != null) {
                WLMComponentFactory factory = model.getFactory();
                Group group = factory.createGroup(model);
                model.startTransaction();
                assignment.addGroup(group);
                groups.add(group);
                
                model.endTransaction();
                fireTableDataChanged();
            }
        }
        
        public void removeRow(int row) {
            if(groups.size() > row)  {
                groups.remove(row);
            }
            fireTableDataChanged();
        }
    }
   
    private class AssignmentComponentListener implements ComponentListener {

        public void valueChanged(ComponentEvent evt) {
            refresh(evt);
        }

        public void childrenAdded(ComponentEvent evt) {
            refresh(evt);
        }

        public void childrenDeleted(ComponentEvent evt) {
            refresh(evt);
        }
        
        private void refresh(ComponentEvent evt) {
            Object source = evt.getSource();
            if(source instanceof Group) {
                refreshGroups(GroupsPanel.this.assignment);
            }
        }
    }   
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addButton;
    private javax.swing.JTable groupsTable;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton removeButton;
    // End of variables declaration//GEN-END:variables
    
}
