/*
 * TaskDefinitionPanelFactory.java
 * 
 * Created on May 24, 2007, 3:10:31 PM
 * 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.netbeans.modules.worklist.editor.multiview.assignment;

import org.netbeans.modules.wlm.model.api.TAssignment;
import org.netbeans.modules.wlm.model.api.TTask;
import org.netbeans.modules.worklist.editor.multiview.assignment.UsersPanel;
import org.netbeans.modules.worklist.editor.multiview.assignment.GroupsPanel;
import org.netbeans.modules.worklist.editor.multiview.*;
import org.netbeans.modules.worklist.dataloader.WorklistDataObject;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;

/**
 *
 * @author radval
 */
public class AssignmentPanelFactory implements org.netbeans.modules.xml.multiview.ui.InnerPanelFactory { 

    
    private WorklistDataObject dObj;
    private ToolBarDesignEditor editor;
    
    private UsersPanel usersPanel;
    private GroupsPanel groupsPanel;
    
    
    public AssignmentPanelFactory(ToolBarDesignEditor editor, 
                                  WorklistDataObject dObj) {
        this.dObj=dObj;
        this.editor=editor;
        
//        this.usersPanel = new  UsersPanel((SectionView)editor.getContentView(), dObj);
//        this.groupsPanel = new  GroupsPanel((SectionView)editor.getContentView(), dObj);
        
        //dObj.getTaskSelectionModel().addTaskSelectionListner(new TaskSelectionAdapter(usersPanel, groupsPanel));
    }

    public SectionInnerPanel createInnerPanel(Object key) {
        if(key instanceof PanelKey) {
             PanelKey cKey = (PanelKey) key;
             Object obj = cKey.getObject();
             String stringKey = cKey.getKey();
         
             if(EditorConstants.USERS_PANEL.equals(stringKey)) {
                 UsersPanel usersPanel = new  UsersPanel((SectionView)editor.getContentView(), dObj);
                  if(obj instanceof TTask) {
                      TTask task = (TTask) obj;
                      TAssignment assignment = task.getAssignment();
                      if(assignment == null) {
                          assignment = dObj.getModel().getFactory().createAssignment(dObj.getModel());
                          dObj.getModel().startTransaction();
                          task.setAssignment(assignment);
                          dObj.getModel().endTransaction();
                      }
                        usersPanel.refreshUsers(assignment);
                  }
                  

                  return usersPanel;
             } else if(EditorConstants.GROUPS_PANEL.equals(stringKey)) {
                 GroupsPanel groupsPanel = new  GroupsPanel((SectionView)editor.getContentView(), dObj);
                 if(obj instanceof TTask) {
                      
                      TTask task = (TTask) obj;
                      TAssignment assignment = task.getAssignment();
                      if(assignment == null) {
                          assignment = dObj.getModel().getFactory().createAssignment(dObj.getModel());
                          dObj.getModel().startTransaction();
                          task.setAssignment(assignment);
                          dObj.getModel().endTransaction();
                      }
                      
                      groupsPanel.refreshGroups(assignment);
                  }
                 
                 return groupsPanel;
             }
        }
         
         return null;
    }

    private class TaskSelectionAdapter implements TaskSelectionListener {

        private UsersPanel usersPanel;
        private GroupsPanel groupsPanel;
        
        public TaskSelectionAdapter(UsersPanel usersPanel, GroupsPanel groupsPanel) {
            this.usersPanel = usersPanel;
            this.groupsPanel = groupsPanel;
        }        
        public void taskSelected(TaskSelectionEvent evt) {
            TTask task = evt.getTask();
            if(task != null) {
                TAssignment assignment = task.getAssignment();
                this.usersPanel.refreshUsers(assignment);
                this.groupsPanel.refreshGroups(assignment);
                
            }
        }
    }
}

