// JDMK imports
//
package org.netbeans.modules.prjwizard.snmp.manager;

import com.sun.management.snmp.SnmpDefinitions;
import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpEngineParameters;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpUsmKeyHandler;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.SnmpEventReportDispatcher;
import com.sun.management.snmp.manager.SnmpParameters;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpRequest;
import com.sun.management.snmp.manager.SnmpSession;
import com.sun.management.snmp.manager.usm.SnmpUsmParameters;
import com.sun.management.snmp.manager.usm.SnmpUsmPeer;
import com.sun.management.snmp.SnmpPduRequest;
import com.sun.management.snmp.SnmpPduTrap;
import com.sun.management.snmp.manager.SnmpTrapListener;
import com.sun.management.snmp.SnmpScopedPduRequest;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpOidTableSupport;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.jdmk.tasks.DaemonTaskServer;

import org.netbeans.modules.prjwizard.snmp.agent.RFC1213_MIBOidTable;

public final class SNMPConnect{

	/*
	 * this parameter should be ideally pickedup from the
	 * agent / manager security.jdmk file.
	 * currently used as an alternative hard code for the
	 * local host
	*/
	String engId = "0x000000000000000000000002";
    

    /* The following SNMP parameters are declated 
	 * at the global level so that 
	 * the same can be used across the method calls
	*/
	SnmpEngineId engineId = null;
	SnmpSession session = null;
        SnmpPeer agent = null;
        SnmpEngine engine = null;
        SnmpUsmKeyHandler handler = null;
	SnmpEventReportDispatcher trapAgent = null;
	
	/*
	 * This method creates the session and creates the engine out of the session.
	 * The engine 
	*/
	public synchronized SnmpEngine setSnmpEngine(String version){
	
		//Initialize engine ID with default value
        try {
            engineId = SnmpEngineId.createEngineId(engId);
        } catch (Exception e) {
            System.out.println(e.getMessage());
            java.lang.System.exit(0);
        }

		// create engine parameters 
        final SnmpEngineParameters parameters = new SnmpEngineParameters();
		
		// set the parameters for encryption if only the version is V3
		if(version.equalsIgnoreCase("V3"))
			parameters.activateEncryption();

        // Create the SNMP Manager Session
        //
        try {
            session= new SnmpSession(parameters, null,
                                     "SNMPConnect session", null);
        } catch (SnmpStatusException e) {
            System.out.println(e.getMessage());
            java.lang.System.exit(0);
        } catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            java.lang.System.exit(0);
        }

        try {
            // get the session the engine.
            //
            engine = session.getEngine();

            // *********** INTERESTING STEP ****************
            // VERY USEFULL CLASS. The Usm Key handler.
            // IT ALLOWS YOU TO DO KEY CHANGES.
            //
            // This corresponds to the key change algorithm described
            // in RFC 2574.
            //
            handler = engine.getUsmKeyHandler();
			
		}catch(Exception e){
			e.printStackTrace();
		}
		System.out.println("engine id"+engine.getEngineId());
		return engine;
	}



	/*
	 * once getting the session then create the user for that session depending upon 
	 * the version of the SNMP we are using like V1/V2/V2
	 * for V1 and V2 it would be a normal user where as for V3 we have a user created
	 * out of SnmpUsmParameters
	 * create usm peer if the version is 3 
	 * else create a normal peer if the version is either
	 * V1 or V2
	*/
	public synchronized SnmpPeer setPeerForVersion(String version, String host, String port, String securityLevel){

		/*
		 * set the session and engine in place first
		*/
		try{
			setSnmpEngine(version);
		}catch(Exception e){
			e.printStackTrace();
		}

		if( version.equalsIgnoreCase("V3") & session != null){

			try{
				
				// Create a SnmpPeer object for representing the entity to 
				// communicate with. 
				// SnmpPeer that is able to deal 
				// with User based security parameters. Create it as a 
				// SnmpPeer but give it the local engine as additional 
				// parameter.
				// A Usm peer discovers the engine Id of the SNMP V3 agent it 
				// whishes to communicate with. This engine Id will be used 
				// when sending requests.
				//
				agent = new SnmpUsmPeer(engine,host,Integer.parseInt(port));
				boolean discoveryFlag = false;
				
				// Security parameters when sending set requests.
				//
				final SnmpUsmParameters p = new SnmpUsmParameters(engine, "defaultUser");

				// set the user here
				//p.setPrincipal("defaultUser");
				// Analyze the security level
				// If the security level is authPriv or authNoPriv, we will
				// need to send a "discovery" request in order to discover
				// the value of the agent's engineBoots and engineTime.
				//
				if (securityLevel.equals("authPriv")) {
					discoveryFlag = true;
					p.setSecurityLevel(SnmpDefinitions.authPriv);
				}
				if (securityLevel.equals("authNoPriv")) {
					discoveryFlag = true;
					p.setSecurityLevel(SnmpDefinitions.authNoPriv);
				}
				if (securityLevel.equals("noAuthNoPriv")) {
					p.setSecurityLevel(SnmpDefinitions.noAuthNoPriv);
				}
				
				p.setContextEngineId(((SnmpUsmPeer)agent).getEngineId().getBytes());

				p.setContextName("TEST-CONTEXT".getBytes());
				
				agent.setParams(p);
				
				// Sends the discovery request if necessary.
				// When making authenticated requests, some values must be 
				// discovered.
				// This is done calling processUsmTimelinessDiscovery.
				// If this call is not done to the distant SNMP V3 agent, 
				// authenticated requests will fail.
				//
					if (discoveryFlag)
						((SnmpUsmPeer)agent).processUsmTimelinessDiscovery();

			} catch (Exception e) {
				System.out.println("Unable to initialize creator." +
						" Check whether the agent is running" +
						" and/or whether your USM configuration is OK");
				java.lang.System.exit(0);
			}
			session.setDefaultPeer(agent);

		}else{
			
			/*
			 * create the peer for the version V1 and V2
			 * 
			*/
			try{
				agent = new SnmpPeer(host,Integer.parseInt(port));
				SnmpParameters params = new SnmpParameters("soabiread","privare");
				agent.setParams(params);
				session.setDefaultPeer(agent);
                                System.out.println("snmppeer"+session.getDefaultPeer().toString());
			}catch(Exception e){
				System.out.println("Unknown host ");
				java.lang.System.exit(0);
			}

		}
			return session.getDefaultPeer();
	}

	 /**
     * Regular Java DMK manager API SNMP Get and Set requests. 
     * Idem other SNMP examples.
     */
    public SnmpVarBindList doRequest(boolean get) {

        try {

			final SnmpOidTableSupport oidTable = new RFC1213_MIBOidTable();
                        SnmpOid.setSnmpOidTable(oidTable);

			// Build the list of variables you want to query.
			// For debug purposes, you can associate a name to your list.
			//
			final SnmpVarBindList list = 
			new SnmpVarBindList("S varbind list");
			
			// We want to read the "sysDescr" variable.
			//
			// We will thus query "sysDescr.0", as sysDescr is a scalar
			// variable (see RFC 1157, section 3.2.6.3.  Identification 
			// of Object Instances, or RFC 2578, section 7.  Mapping of 
			// the OBJECT-TYPE macro).
			//
			list.addVarBind("sysDescr.0");
                        list.addVarBind("sysObjectID.0");
                        list.addVarBind("sysName.0");
                        //list.addVarBind("sysDescr.2");
			
			// Make the SNMP get request and wait for the result.
			//
			//final SnmpVarBindList result = doRequest(list,true);
			//System.out.println("SyncManagerV3::main:" +
			//	"Send get request to SNMP agent on " + host + 
			//	" at port " + port);
			//	System.out.println("Result: \n" + result);
		   
			//	System.out.println(
		    //		  "\n>> Press <Enter> if you want to stop this SNMP manager.\n");
			//	java.lang.System.in.read();
            
			SnmpRequest request = null;
            if (get) 
                request = session.snmpGetRequest(null, list);
            else
                request = session.snmpSetRequest(null, list);
            
			System.out.println("get activated");
            final boolean completed = request.waitForCompletion(10000);
            
            // Check for a timeout of the request.
            //
            if (completed == false) {
                throw new IllegalArgumentException("Timeout");
            }
            
            // Now we have a response. Check if the response contains 
            // an error.
            //
            final int errorStatus = request.getErrorStatus();
            if (errorStatus != SnmpDefinitions.snmpRspNoError) {
                throw new IllegalArgumentException(
                                 SnmpRequest.snmpErrorToString(errorStatus));
            }
            
            // Extract the returned VarBind List
            //
            SnmpVarBindList result = request.getResponseVarBindList();

            // Now we may display the content of the result.
            //
            // println("Result: \n" + result);
            System.out.println("Result: \n" + result);
            return result;
        } catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
		
    }

	public int processTraps(String port , String version){

		try{
		
			// Create a taskServer for processing traps
			// This is an optional step. However using a DaemonTaskServer
			// to process incomming PDUs makes it possible to empty
			// the trap socket faster, thus reducing the hazards
			// of trap loss.
			// We set the priority of the DaemonTaskServer to 
			// Thread.NORM_PRIORITY so that emptying the socket takes 
			// precedence over trap processing.
			//
			final DaemonTaskServer taskServer = new DaemonTaskServer();
			taskServer.start(Thread.NORM_PRIORITY);
			
			// Create a listener and dispatcher for SNMP traps 
			// (SnmpEventReportDispatcher).
				// SnmpEventReportDispatcher is run as a thread and listens 
			// for traps in UDP port = agent port + 1.
			// Add TrapListenerImpl as SnmpTrapListener.
			// TrapListenerImpl will receive a callback when a valid trap 
			// PDU is received.
			// You must provide the engine to the SnmpEventReportDispatcher.
			//
			trapAgent =	new SnmpEventReportDispatcher(engine,Integer.parseInt(port) + 1,null,taskServer,null);
			TrapListenerImpl traplistenerimpl = new  TrapListenerImpl();
			trapAgent.addTrapListener(traplistenerimpl);
			final Thread trapThread = new Thread(trapAgent);
			trapThread.setPriority(Thread.MAX_PRIORITY);
			trapThread.start();	    
			System.out.println("processing trpas");		
			
			System.out.println("\n>> Press <Enter> if you want to stop this SNMP manager.\n");
			java.lang.System.in.read();
			int numberTraps=0;
			if(version.equalsIgnoreCase("V1"))
				numberTraps = traplistenerimpl.getV1();
			else
				numberTraps = traplistenerimpl.getV3();
			session.destroySession();
			trapAgent.close();
			taskServer.terminate();
			
			return numberTraps;
		}catch(Exception e){
			java.lang.System.err.println("SyncManagerV3::main:" + 
						 " Exception occurred:" + e);
				e.printStackTrace();
		}
		return 0;
	}
	
	public static void main(String argv[]){
		// Since manager application we need to do only the following things
		// get the host and port
		// call the following methods in that order

		if (argv.length != 4) {
             
            java.lang.System.exit(1);
        }

		final String version = argv[0];
		final String port = argv[1];
		final String host = argv[2];
		final String securityParam = argv[3];

		SNMPConnect connect = new SNMPConnect();
		if(version.equalsIgnoreCase("V3")){
			SnmpPeer snmppeer = connect.setPeerForVersion(version,host,port,securityParam);
			connect.doRequest(true);
			int numTraps = connect.processTraps("8085","V3");
		}else{
			connect.setPeerForVersion(version,host,port,"noAuthNoPriv");
			connect.doRequest(true);
			connect.processTraps("8085","V1");
		}
		
	}


	private class TrapListenerImpl implements SnmpTrapListener {
		int V1=0;
		//int V2=0;
		int V3=0;
		public void processSnmpTrapV1(SnmpPduTrap trap) {
			V1++;
			println("NOTE: TrapListenerImpl received trap :");
			println("\tGeneric " + trap.genericTrap);
			println("\tSpecific " + trap.specificTrap);
			println("\tTimeStamp " + trap.timeStamp);
			println("\tAgent adress " + trap.agentAddr.stringValue());
		}

		public void processSnmpTrapV2(SnmpPduRequest trap) {
			println("NOTE: Trap V2 not of interest !!!");
		}

		public void processSnmpTrapV3(SnmpScopedPduRequest trap) {
			V3++;
			println("NOTE: TrapListenerImpl received trap V3:");
			println("\tContextEngineId : " + 
				SnmpEngineId.createEngineId(trap.contextEngineId));
			println("\tContextName : " + new String(trap.contextName));
			println("\tVarBind list :");
			for(int i = 0; i < trap.varBindList.length; i++)
				println("oid : " + trap.varBindList[i].getOid() + " val : " + 
					trap.varBindList[i].getSnmpValue());
			
		}

		public int getV1(){
            return V1;
		}
		public int getV3(){
			return V3;
		}
		/**
		 * print/println stuff...
		 */

		private final void println(String msg) {
			java.lang.System.out.println(msg);
		}

		private final void print(String msg) {
			java.lang.System.out.print(msg);
		}
	}

};