package org.netbeans.modules.prjwizard.snmp;

import java.awt.Component;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.WizardDescriptor;

public abstract class DeviceManagerWizardIterator implements WizardDescriptor.InstantiatingIterator {

    // To invoke this wizard, copy-paste and run the following code, e.g. from
    // SomeAction.performAction():
    /*
    WizardDescriptor.Iterator iterator = new DeviceManagerWizardIterator();
    WizardDescriptor wizardDescriptor = new WizardDescriptor(iterator);
    // {0} will be replaced by WizardDescriptor.Panel.getComponent().getName()
    // {1} will be replaced by WizardDescriptor.Iterator.name()
    wizardDescriptor.setTitleFormat(new MessageFormat("{0} ({1})"));
    wizardDescriptor.setTitle("Your wizard dialog title here");
    Dialog dialog = DialogDisplayer.getDefault().createDialog(wizardDescriptor);
    dialog.setVisible(true);
    dialog.toFront();
    boolean cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
    if (!cancelled) {
    // do something
    }
     */
    
    // declare the variables here.
    private transient int index = 0;
    private WizardDescriptor.Panel[] panels = null;
    private Set<ChangeListener> listeners = new HashSet<ChangeListener>(1); // or can use ChangeSupport in NB 6.0
    private transient WizardDescriptor wiz;
    private transient WizardDescriptor.Iterator simpleIterator;

    // constructor
    public DeviceManagerWizardIterator(){
        
    }
    /**
     * Initialize panels representing individual wizard's steps and sets
     * various properties for them influencing wizard appearance.
     */
    private WizardDescriptor.Panel[] getPanels() {
        if (panels == null) {
            panels = new WizardDescriptor.Panel[]{new DeviceManagerWizardPanel1(), new DeviceManagerWizardPanel2(), new DeviceManagerWizardPanel3(), new DeviceManagerWizardPanel4()};
            String[] steps = new String[panels.length];
            for (int i = 0; i < panels.length; i++) {
                Component c = panels[i].getComponent();
                // Default step name to component name of panel.
                steps[i] = c.getName();
                if (c instanceof JComponent) {
                    // assume Swing components
                    JComponent jc = (JComponent) c;
                    // Sets step number of a component
                    jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                    // Sets steps names for a panel
                    jc.putClientProperty("WizardPanel_contentData", steps);
                    // Turn on subtitle creation on each step
                    jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                    // Show steps on the left side with the image on the background
                    jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                    // Turn on numbering of all steps
                    jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
                }
            }
        }
        return panels;
    }

    public WizardDescriptor.Panel current() {
        return getPanels()[index];
    }

    public String name() {
        return index + 1 + ". from " + getPanels().length;
    }

    public boolean hasNext() {
        return index < getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return index > 0;
    }

    public void nextPanel() {
        if (!hasNext()) {
            throw new NoSuchElementException();
        }
        index++;
    }

    public void previousPanel() {
        if (!hasPrevious()) {
            throw new NoSuchElementException();
        }
        index--;
    }
    
/*
    public Set instantiate() throws IOException {
        return new HashSet();
        //throw new UnsupportedOperationException("Not supported yet.");
    }

    public void initialize(WizardDescriptor arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void uninitialize(WizardDescriptor arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }*/
    // If something changes dynamically (besides moving between panels), e.g.
    // the number of panels changes in response to user input, then uncomment
    // the following and call when needed: fireChangeEvent();
    //
    
    public final void addChangeListener(ChangeListener l) {
        synchronized (listeners) {
        listeners.add(l);
        }
    }
    public final void removeChangeListener(ChangeListener l) {
        synchronized (listeners) {
        listeners.remove(l);
        }
    }
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        synchronized (listeners) {
        it = new HashSet<ChangeListener>(listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
        it.next().stateChanged(ev);
        }
    }
     
    // added methods 
    
    /**
     * Creates list of panels to be displayed.
     * 
     * @return List of panels
     */
    protected abstract List createPanels(WizardDescriptor wiz);

    /**
     * Creates array of step descriptions
     * 
     * @return array of Strings representing task summaries for each panel
     */
    protected abstract String[] createSteps();

    /**
     * Gets panels to be displayed.
     * 
     * @return array of WizardDescriptor.Panel objects
     */
    @SuppressWarnings("unchecked")
    protected final WizardDescriptor.Panel[] getPanels(final WizardDescriptor wiz) {
        if (this.panels == null) {
            final List myPanels = this.createPanels(wiz);

            final WizardDescriptor.Panel[] pnlArray = new WizardDescriptor.Panel[myPanels.size()];
            this.panels = (WizardDescriptor.Panel[]) myPanels.toArray(pnlArray);
        }
        return this.panels;
    }

    /**
     * Gets list of steps corresponding to each panel
     * 
     * @return array of Strings summarizing the task in each panel
     */
    protected final String[] getSteps() {
        return this.createSteps();
    }

    public void initialize(final WizardDescriptor wiz) {
        this.panels = this.getPanels(wiz);
        this.wiz = wiz;

        final Object prop = wiz.getProperty("WizardPanel_contentData"); // NOI18N
        if (prop != null && prop instanceof String[]) {
        }
        final String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; i++) {
            final Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                // Default step name to component name of panel.
                // Mainly useful for getting the name of the target
                // chooser to appear in the list of steps.
                steps[i] = c.getName();
            }
            if (c instanceof JComponent) { // assume Swing components
                final JComponent jc = (JComponent) c;
                // Step #.
                jc.putClientProperty("WizardPanel_contentSelectedIndex", Integer.valueOf(String.valueOf(i))); // NOI18N
                // Step name (actually the whole list for reference).
                jc.putClientProperty("WizardPanel_contentData", steps); // NOI18N
            }
        }
    }

    public void uninitialize(final WizardDescriptor wiz) {
        this.wiz = null;
        this.panels = null;
    }

    public Set instantiate() throws IOException {
        return new HashSet();
    }

    @SuppressWarnings("unchecked")
    protected WizardDescriptor.Iterator getSimpleIterator() {
        if (simpleIterator == null) {
            assert (panels != null) && (panels.length > 0);
            simpleIterator = new WizardDescriptor.ArrayIterator(panels);
            
        }

        return simpleIterator;
    }
    
    public int getIndex() {
        return this.index;
    }
}