package it.imolinfo.jbi4ejb.nbm;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;

public final class GetCorbaConfigurationVisualPanel extends JPanel {

  /** The logger */
  private static final Logger LOG
    = Logger.getLogger(GetCorbaConfigurationVisualPanel.class.getName());

  public static final String OPT_CORBANAME = "CorbaName";
  public static final String OPT_JNDI = "JNDI";
  
    /**
   * The name of the property to define ORB host.
   *
   * @see  #ORB_HOST_PROPERTY_VALUE
   */
  private static final String ORB_HOST_PROPERTY_NAME = "org.omg.CORBA.ORBClass";

  /**
   * The value of the property to define ORB host.
   *
   * @see  #ORB_HOST_PROPERTY_NAME
   */
  private static final String ORB_HOST_PROPERTY_VALUE = "com.sun.corba.ee.impl.orb.ORBImpl";

  /**
   * The name of the property to define ORB port.
   *
   * @see  #ORB_PORT_PROPERTY_VALUE
   */
  //private static final String ORB_PORT_PROPERTY_NAME = "org.omg.CORBA.ORBInitialPort";

   /**
   * The value of the property to define ORB port.
   *
   * @see  #ORB_PORT_PROPERTY_NAME
   */
  //private static final String ORB_PORT_PROPERTY_VALUE = "1050";
  
  private GetCorbaConfigurationlWizardPanel wizardPanel = null;


  public GetCorbaConfigurationVisualPanel(GetCorbaConfigurationlWizardPanel wizardPanel) {
      this.wizardPanel = wizardPanel;
    initComponents();
    
    corbaNameField.getDocument().addDocumentListener(new CorbaNameListener());                         
  }
  
  public String getName() {
    return org.openide.util.NbBundle.getMessage(GetCorbaConfigurationVisualPanel.class, "LBL_GetsTheConfiguration");
  }
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jLabel2 = new javax.swing.JLabel();
        ejbLookupPanel = new javax.swing.JPanel();
        ejbLookupModeCombo = new javax.swing.JComboBox();
        corbaNameField = new javax.swing.JTextField();
        propertiesPanel = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        propertiesTable = new javax.swing.JTable();
        propertyNameLabel = new javax.swing.JLabel();
        propertyNameField = new javax.swing.JTextField();
        propertyValueField = new javax.swing.JTextField();
        propertyValueLabel = new javax.swing.JLabel();
        addButton = new javax.swing.JButton();
        removeButton = new javax.swing.JButton();
        useSunOrb = new javax.swing.JCheckBox();

        setMaximumSize(new java.awt.Dimension(30000, 30000));
        addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                panelMouseClicked(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(GetCorbaConfigurationVisualPanel.class, "LBL_GetsTheConfiguration")); // NOI18N

        ejbLookupPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(GetCorbaConfigurationVisualPanel.class, "LBL_EjbLookupMode"))); // NOI18N

        ejbLookupModeCombo.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "CorbaName" }));
        ejbLookupModeCombo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ejbLookupModeComboActionPerformed(evt);
            }
        });
        ejbLookupModeCombo.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                ejbLookupModePropertyChange(evt);
            }
        });

        corbaNameField.setForeground(new java.awt.Color(255, 51, 51));
        corbaNameField.setText("corbaname:iiop:127.0.0.1:3700#jndiName");
        corbaNameField.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                corbaNameFieldMouseDragged(evt);
            }
        });

        org.jdesktop.layout.GroupLayout ejbLookupPanelLayout = new org.jdesktop.layout.GroupLayout(ejbLookupPanel);
        ejbLookupPanel.setLayout(ejbLookupPanelLayout);
        ejbLookupPanelLayout.setHorizontalGroup(
            ejbLookupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(ejbLookupPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(ejbLookupModeCombo, 0, 184, Short.MAX_VALUE)
                .add(18, 18, 18)
                .add(corbaNameField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 421, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        ejbLookupPanelLayout.setVerticalGroup(
            ejbLookupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(ejbLookupPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(ejbLookupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(ejbLookupModeCombo, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(corbaNameField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(25, Short.MAX_VALUE))
        );

        propertiesPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(GetCorbaConfigurationVisualPanel.class, "LBL_OrbProperties"))); // NOI18N

        propertiesTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Name", "Value"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.String.class, java.lang.String.class
            };
            boolean[] canEdit = new boolean [] {
                false, false
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jScrollPane1.setViewportView(propertiesTable);

        org.openide.awt.Mnemonics.setLocalizedText(propertyNameLabel, org.openide.util.NbBundle.getMessage(GetCorbaConfigurationVisualPanel.class, "LBL_PropertyName")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(propertyValueLabel, org.openide.util.NbBundle.getMessage(GetCorbaConfigurationVisualPanel.class, "LBL_PropertyValue")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(addButton, org.openide.util.NbBundle.getMessage(GetCorbaConfigurationVisualPanel.class, "LBL_AddButton")); // NOI18N
        addButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(removeButton, org.openide.util.NbBundle.getMessage(GetCorbaConfigurationVisualPanel.class, "LBL_RemoveButton")); // NOI18N
        removeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                removeActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(useSunOrb, org.openide.util.NbBundle.getMessage(GetCorbaConfigurationVisualPanel.class, "LBL_UseSunOrb")); // NOI18N
        useSunOrb.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        useSunOrb.setMargin(new java.awt.Insets(0, 0, 0, 0));
        useSunOrb.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                checkSunOrb(evt);
            }
        });

        org.jdesktop.layout.GroupLayout propertiesPanelLayout = new org.jdesktop.layout.GroupLayout(propertiesPanel);
        propertiesPanel.setLayout(propertiesPanelLayout);
        propertiesPanelLayout.setHorizontalGroup(
            propertiesPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(propertiesPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(propertiesPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(propertiesPanelLayout.createSequentialGroup()
                        .add(propertiesPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(propertiesPanelLayout.createSequentialGroup()
                                .add(propertiesPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(propertyNameLabel)
                                    .add(propertyNameField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 257, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(propertiesPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(propertyValueField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 285, Short.MAX_VALUE)
                                    .add(propertyValueLabel)))
                            .add(propertiesPanelLayout.createSequentialGroup()
                                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .add(18, 18, 18)
                                .add(propertiesPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                                    .add(addButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .add(removeButton))))
                        .add(81, 81, 81))
                    .add(propertiesPanelLayout.createSequentialGroup()
                        .add(useSunOrb)
                        .addContainerGap(536, Short.MAX_VALUE))))
        );
        propertiesPanelLayout.setVerticalGroup(
            propertiesPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(propertiesPanelLayout.createSequentialGroup()
                .add(12, 12, 12)
                .add(useSunOrb)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(propertiesPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(propertyNameLabel)
                    .add(propertyValueLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(propertiesPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(propertyNameField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(propertyValueField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 20, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(18, 18, 18)
                .add(propertiesPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 182, Short.MAX_VALUE)
                    .add(propertiesPanelLayout.createSequentialGroup()
                        .add(addButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(removeButton)))
                .addContainerGap())
        );

        propertyNameLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(GetCorbaConfigurationVisualPanel.class, "LBL_PropertyName")); // NOI18N
        propertyValueLabel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(GetCorbaConfigurationVisualPanel.class, "LBL_PropertyValue")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(ejbLookupPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addContainerGap())
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .add(jLabel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 629, Short.MAX_VALUE)
                        .add(40, 40, 40))
                    .add(layout.createSequentialGroup()
                        .add(propertiesPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addContainerGap())))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(ejbLookupPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(propertiesPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(24, 24, 24))
        );

        ejbLookupPanel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(GetCorbaConfigurationVisualPanel.class, "LBL_EjbLookupMode")); // NOI18N
        propertiesPanel.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(GetCorbaConfigurationVisualPanel.class, "LBL_OrbProperties")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

private void checkSunOrb(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_checkSunOrb
        // Updates properties only if check has been selected
                if (useSunOrb.isSelected()) {                    
                    propertiesMap.clear();                                       
                    propertiesMap.put(ORB_HOST_PROPERTY_NAME, ORB_HOST_PROPERTY_VALUE);
                    // propertiesMap.put(ORB_PORT_PROPERTY_NAME, ORB_PORT_PROPERTY_VALUE);                        
                    updateTable(propertiesMap);
                } else {
                    propertiesMap.clear();
                    // Empty the table
                    updateTable(propertiesMap);
                }
}//GEN-LAST:event_checkSunOrb

private void corbaNameFieldMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_corbaNameFieldMouseDragged
    // TODO add your handling code here:
}//GEN-LAST:event_corbaNameFieldMouseDragged

private void ejbLookupModePropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_ejbLookupModePropertyChange
  // LOG.info("ejbLookupModePropertyChange. event=" + evt);
}//GEN-LAST:event_ejbLookupModePropertyChange

private void ejbLookupModeComboActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ejbLookupModeComboActionPerformed
  // LOG.info("ejbLookupModeComboActionPerformed. event=" + evt);

  TitledBorder border = (TitledBorder) propertiesPanel.getBorder();

  String combo = (String) ejbLookupModeCombo.getSelectedItem();

  if (OPT_CORBANAME.equalsIgnoreCase(combo)) {

    ejbLookupModeSelected = OPT_CORBANAME;
    border.setTitle("Orb Properties");
    corbaNameField.setEnabled(true);        

  } else { // OPT_JNDI
    ejbLookupModeSelected = OPT_JNDI;
    border.setTitle("JNDI Properties");
    corbaNameField.setEnabled(false);    
  }

  propertiesPanel.repaint();
}//GEN-LAST:event_ejbLookupModeComboActionPerformed

private void removeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeActionPerformed

  int [] zombie = propertiesTable.getSelectedRows();
  int zombieSize = zombie == null ? 0 : zombie.length;
 
  for (int row = 0; row < zombieSize; row++) {
    String key = (String) propertiesTable.getModel().getValueAt(row, 0);
    

    propertiesMap.remove(key);
  }

  updateTable(propertiesMap);
}//GEN-LAST:event_removeActionPerformed

private void addButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addButtonActionPerformed

  String key = propertyNameField.getText();
  String val = propertyValueField.getText();

  // if the property is not fully specified then skip
  if (key == null || "".equals(key) || val == null || "".equals(val)) {
    //LOG.info("The property is not fully specified. "
    //   + "name=" + key + "; value=" + val);
  }
  // else we add the property (if not exists) or updated.
  else {
    propertiesMap.put(key, val);

    updateTable(propertiesMap);
  }

}//GEN-LAST:event_addButtonActionPerformed


protected void updateTable(Map<String, String> map) {
  // remove all the rows.
  DefaultTableModel model = (DefaultTableModel) propertiesTable.getModel();  
  
  // Clear the data vector        
  model.setRowCount(0);  

  // if no rows ...
  if (map == null || map.isEmpty()) {
    propertiesTable.repaint();
    return;
  }

  // ... else. add all the rows
  for (String key : map.keySet()) {
    String val = map.get(key);

    model.addRow(new Object [] {key, val});    
  }

  //propertyNameField.setText("");
  //propertyValueField.setText("");

  propertiesTable.repaint();
}


private void panelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_panelMouseClicked

}//GEN-LAST:event_panelMouseClicked
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addButton;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JTextField corbaNameField;
    private javax.swing.JComboBox ejbLookupModeCombo;
    private javax.swing.JPanel ejbLookupPanel;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPanel propertiesPanel;
    private javax.swing.JTable propertiesTable;
    private javax.swing.JTextField propertyNameField;
    private javax.swing.JLabel propertyNameLabel;
    private javax.swing.JTextField propertyValueField;
    private javax.swing.JLabel propertyValueLabel;
    private javax.swing.JButton removeButton;
    private javax.swing.JCheckBox useSunOrb;
    // End of variables declaration//GEN-END:variables

  protected Map<String, String> propertiesMap = new HashMap<String, String>();

  protected String ejbLookupModeSelected = "CorbaName";
  protected String corbaNameInserted = null;
  protected String oldCorbaNameInserted = null;

  public String getEjbLookupModeSelected() {
      return ejbLookupModeSelected;
  }

  public String getCorbaNameInserted() {
      return corbaNameInserted;
  }
  
  private void doUpdate() {
      corbaNameInserted = corbaNameField.getText();      
      corbaNameField.setForeground(Color.BLACK);
      wizardPanel.fireChangeEvent();
  }

  public Map<String, String> getPropertiesMap() {
      return propertiesMap;
  }
  
      private class CorbaNameListener implements javax.swing.event.DocumentListener {
        public void changedUpdate(javax.swing.event.DocumentEvent e) {                                                
            doUpdate();            
        }
        
        public void insertUpdate(javax.swing.event.DocumentEvent e) {
            doUpdate();
        }
        
        public void removeUpdate(javax.swing.event.DocumentEvent e) {
            doUpdate();
        }
    };

}

