/*
 * The contents of this file are subject to the terms of the Common
 * Development and Distribution License (the License). You may not use this
 * file except in compliance with the License.  You can obtain a copy of the
 * License at http://www.netbeans.org/cddl.html

 * When distributing Covered Code, include this CDDL Header Notice in each
 * file and include the License. If applicable, add the following below the
 * CDDL Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"

 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 *
 */
package org.netbeans.modules.aspect.editor.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.xml.transform.dom.DOMSource;

/**
 *
 * This class contains a set of rule for a given aspect or advice.
 *
 * @author Sujit Biswas
 *
 */
public class Ruleset {
    
    private String name;
    
    private List<Rule> ruleList;
    
    public Ruleset(List<Rule> rules, String name) {
        ruleList = rules;
        this.name = name;
    }
    
    /**
     * @return the name
     */
    public String getName() {
        return name;
    }
    
    public void setName(String rulesetName) {
        this.name = rulesetName;
    }
    
    public void addRule(Rule rule) {
        ruleList.add(rule);
    }
    
    public void removeRule(Rule rule) {
        ruleList.remove(rule);
    }
    
    public void clearRules() {
        ruleList.clear();
    }
    
    /**
     * @return the ruleList
     */
    public List<Rule> getRuleList() {
        return ruleList;
    }
    
    public List<String> getAllDestinations() {
        List<String> destinations = new ArrayList<String>();
        Iterator it = ruleList.iterator();
        while(it.hasNext()) {
            Rule rule = (Rule)it.next();
            destinations.addAll(rule.getDestinations());
        }
        return destinations;
    }
    
    /**
     * @return the xmlString
     */    
    public String toXmlString() {
        StringBuffer xmlString = new StringBuffer();
        
        //TODO add the ruleset name
        xmlString.append("\t<" + AspectConstants.RULESET_TAG +">\n");
        if(getRuleList().isEmpty()) {
            return "\t<" + AspectConstants.RULESET_TAG +" />";
        } else {
            Iterator it = getRuleList().iterator();
            while(it.hasNext()) {
                Rule rule = (Rule)it.next();
                xmlString.append(rule.toXMLString());
            }
        }
        xmlString.append("\t</" + AspectConstants.RULESET_TAG +">");
        return xmlString.toString();
    }
}