/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.iep.editor.tcg.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * PropertyUtil.java
 *
 * Created on August 10, 2005, 10:14 AM
 *
 * @author Bing Lu
 */

public class PropertyUtil {
    /*
     * 1. Search srcRoot directory for all .properties files 
     * 2. For each .properties file f
     *   2.1 Print: f
     *   2.2 For each property p in f
     *       2.2.1 Print all properties in f that is not used anywhere
     *       2.2.2 Print all properties in f that is used with context:
     *            p-name
     *                user-file-full-name *
     *                    user-file-line-number, user-file-column-number: line-text *
     *   
     */                    
    public static void validateProperties(File srcRoot, String[] userExt) {
        Map report = new HashMap();
        List propFileList = DirectoryUtil.getFilesRecursively(srcRoot, new String[]{".properties"});
        for (int i = 0; i < propFileList.size(); i++) {
            File file = (File)propFileList.get(i);
            FileReport fileReport = new FileReport(file);
            report.put(file, fileReport);
        }
        
        List srcFileList = DirectoryUtil.getFilesRecursively(srcRoot, userExt);
        for (int i = 0, I = srcFileList.size(); i < I; i++) {
            File srcFile = (File)srcFileList.get(i);
            String srcFileName = srcFile.getAbsolutePath();
            FileContent fileContent = new FileContent(srcFile);
            boolean javaFile = srcFileName.endsWith(".java");
            for (int j = 0, J = propFileList.size(); j < J; j++) {
                File file = (File)propFileList.get(j);
                FileReport fileReport = (FileReport)report.get(file);
                for (Enumeration e = fileReport.mProperties.propertyNames(); e.hasMoreElements(); ) {
                    String propName = (String)e.nextElement();
                    String extPropName = javaFile? "\"" + propName + "\"" : propName;
                    for (int lineNum = 0, LN = fileContent.mLines.size(); lineNum < LN; lineNum++) {
                        String lineText = (String)fileContent.mLines.get(lineNum);
                        int colNum = lineText.indexOf(extPropName);
                        if (0 <= colNum) {
                            fileReport.addPropReport(propName, srcFileName, lineNum, colNum, lineText);
                        }
                    }
                }
            }
        }
        
        for (int i = 0; i < propFileList.size(); i++) {
            File file = (File)propFileList.get(i);
            FileReport fileReport = (FileReport)report.get(file);
            System.out.println(file.getAbsolutePath());
            String indent = "    ";
            fileReport.printInvalidProperties(indent);
            fileReport.printValidProperties(indent);
        }
    }
        
    
    public static void main(String[] args) {
        String srcRoot = args[0];
        String[] userExt = new String[args.length - 1];
        System.arraycopy(args, 1, userExt, 0, userExt.length);
        validateProperties(new File(srcRoot), userExt);
    }
    
}

class FileReport {
    File mFile;
    Properties mProperties;
    Map mPropTable = new HashMap(); // propName -> list of propReport

    FileReport(File file) {
        try {
            mFile = file;
            mProperties = new Properties();
            mProperties.load(new FileInputStream(mFile));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    void addPropReport(String propName, String userFileName, int lineNum, int colNum, String lineText) {
        PropReport pr = new PropReport(userFileName, lineNum, colNum, lineText);
        List list = (List)mPropTable.get(propName);
        if (list == null) {
            list = new ArrayList();
            mPropTable.put(propName, list);
        }
        list.add(pr);
    }
    
    void printInvalidProperties(String indent) {
        System.out.println(indent + "Invalid Properties:");
        String myIndent = indent + "    ";
        for (Enumeration e = mProperties.propertyNames(); e.hasMoreElements();) {
            String pName = (String)e.nextElement();
            if (!mPropTable.containsKey(pName)) {
                System.out.println(myIndent + pName);
            }
        }
    }
    
    void printValidProperties(String indent) {
        System.out.println(indent + "Valid Properties:");
        String myIndent = indent + "    ";
        String myIndent2 = myIndent + "    ";
        for (Enumeration e = mProperties.propertyNames(); e.hasMoreElements();) {
            String pName = (String)e.nextElement();
            if (!mPropTable.containsKey(pName)) {
                continue;
            }
            System.out.println(myIndent + "Property: " + pName + " ==================");
            List list = (List)mPropTable.get(pName);
            String srcFileName = null;
            for (int i = 0, I = list.size(); i < I; i++) {
                PropReport r = (PropReport)list.get(i);
                if (srcFileName == null || !srcFileName.equals(r.mUserFileName)) {
                    srcFileName = r.mUserFileName;
                    System.out.println(myIndent + srcFileName);
                }
                System.out.println(myIndent2 + "line: " + r.mLineNum
                                             + ", col: " + r.mColNum
                                             + ", " + r.mLineText);
            }
        }
    }
} 

class PropReport {
    String mUserFileName;
    int mLineNum;
    int mColNum;
    String mLineText;

    PropReport(String userFileName, int lineNum, int colNum, String lineText) {
        mUserFileName = userFileName;
        mLineNum = lineNum;
        mColNum = colNum;
        mLineText = lineText;
    }
}

class FileContent {
    File mFile;
    List mLines = new ArrayList();

    FileContent(File file) {
        mFile = file;
        BufferedReader brd = null;
        try {
            brd = new BufferedReader(new InputStreamReader(new FileInputStream(mFile)));
            String line = null;
            while ((line = brd.readLine()) != null) {
                mLines.add(line);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (brd != null) {
                try {
                    brd.close();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}
