/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.iep.editor.tcg.palette;

import org.netbeans.modules.iep.editor.share.SharedConstants;
import java.util.List;

import org.netbeans.modules.iep.editor.tcg.model.TcgComponentType;
import org.netbeans.modules.iep.editor.tcg.model.TcgComponentTypeGroup;
import org.netbeans.modules.iep.editor.tcg.model.TcgModelManager;
import org.netbeans.modules.iep.editor.tcg.util.GenUtil;
import org.netbeans.modules.iep.editor.tcg.util.IOUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import java.util.logging.Level;

/**
 * NbPaletteCodeGen.java
 *
 * Created on January 4, 2006, 11:18 AM
 *
 * @author Bing Lu
 */
public class NbPaletteCodeGen implements SharedConstants {
    private static final java.util.logging.Logger mLog = java.util.logging.Logger.getLogger(NbPaletteCodeGen.class.getName());

    private final static String mMARK = "<--NbPaletteCodeGen-->";
    private final static String mPALETTE_ITEM_XML = "paletteItem.xml";
    private final static String mPALETTE_ITEM_JAVA = "paletteItem.java";
    private final static String mLAYER_FILE = "mf-layer.seed";
    private final static String mBUNDLE_FILE = "Bundle.seed";
    private final static String mEDITOR_DIR = "../src/org/netbeans/modules/iep/editor";
    private final static String mPALETTE_DIR = "../src/org/netbeans/modules/iep/editor/palette";
    private final static String mITEMS_DIR = "../src/org/netbeans/modules/iep/editor/palette/items";
    
    private String mPaletteItemXml;
    private String mPaletteItemJava;
    private StringBuffer mLayerSb = new StringBuffer();
    private StringBuffer mBundleSb = new StringBuffer();
    private Properties mPsBundle = new Properties();
    private HashMap mPaletteTable = new HashMap();
    
    /** Creates a new instance of NbPaletteCodeGen */
    public NbPaletteCodeGen() {
        mPaletteItemXml = loadStr(mPALETTE_ITEM_XML);
        mPaletteItemJava = loadStr(mPALETTE_ITEM_JAVA);
        InputStream fis = IOUtil.getResourceAsStream("org/netbeans/modules/iep/editor/ps/Bundle.properties");
        try {
            mPsBundle.load(fis);
        } catch (Exception e) {
            mLog.log(Level.SEVERE, "Fail to load org/netbeans/modules/iep/editor/ps/Bundle.properties", e);
        }
    }
    
    public static void main(String[] args){
        NbPaletteCodeGen genCode = new NbPaletteCodeGen();
        genCode.run();
    }
    
    private String loadStr(String path) {
        try {
            return IOUtil.getText(path, "UTF-8");
        } catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    private void loadPaletteTable(TcgComponentTypeGroup ctg) {
        List ctList = ctg.getComponentTypeList();
        for (int i = 0, I = ctList.size(); i < I; i++) {
            TcgComponentType ct = (TcgComponentType) ctList.get(i);
            if (ct.isVisible()) {
                boolean hasPalette = ct.hasPropertyType(PALETTE_KEY);
                if (!hasPalette) {
                    continue;
                }
                String palette = (String)ct.getPropertyType(PALETTE_KEY).getDefaultValue();
                if (!mPaletteTable.containsKey(palette)) {
                    mPaletteTable.put(palette, new LinkedList());
                }
                List list = (List)mPaletteTable.get(palette);
                list.add(new ComponentTypeAndGroupPair(ct, ctg));
            }
        }
    }

    private void genLayerXmlEntry(String palette) {
        mLayerSb.append("        <folder name=\"" + palette + "\">" + "\n");
        mLayerSb.append("            <attr name=\"SystemFileSystem.localizingBundle\" stringvalue=\"org.netbeans.modules.iep.editor.palette.Bundle\"/>"  + "\n\n");
        List list = (List)mPaletteTable.get(palette);
        for (int i = 0, I = list.size(); i < I; i++) {
            ComponentTypeAndGroupPair pair = (ComponentTypeAndGroupPair) list.get(i);
            TcgComponentType ct = pair.mCt;
            mLayerSb.append("            <file name=\"" + ct.getName() + ".xml\" url=\"nbresloc:/org/netbeans/modules/iep/editor/palette/items/" + palette + "/" + ct.getName() + ".xml\" />" + "\n");
        }
        mLayerSb.append("        </folder>" + "\n");
        mLayerSb.append("\n");
    }
    
    private String getTitle(String key) {
        String ret = "";
        try {
            ret = mPsBundle.getProperty(key);
            if (ret == null) {
                mLog.log(Level.SEVERE, "Title for " + key + " is missing.");
            }
        } catch (Exception e) {
            mLog.log(Level.SEVERE, "Title for " + key + " is missing.");
        }
        return ret;
    }
    
    private String getPaletteTitle(String palette) {
        String key = "IEP.Palette." + palette;
        return getTitle(key);
    }
    
    private void genBundleEntry(String palette) {
        mBundleSb.append("IepPalette/" + palette + "=" + getPaletteTitle(palette) + "\n");
    }
    
    private void genCode(String palette) {
        genLayerXmlEntry(palette);
        genBundleEntry(palette);
        
        String path = mITEMS_DIR + "/" + palette;
        
        // create dir if not exists
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdir();
        }
        
        StringBuffer bundleSb = new StringBuffer();
        // txt mf-layer declaration
        List list = (List)mPaletteTable.get(palette);
        for (int i = 0, I = list.size(); i < I; i++) {
            ComponentTypeAndGroupPair pair = (ComponentTypeAndGroupPair)list.get(i);
            TcgComponentType ct = pair.mCt;
            TcgComponentTypeGroup ctg = pair.mCtg;
            // txt name-hint
            bundleSb.append("NAME_html-" + ct.getName() + "=" + getTitle(ct.getTitle()) + "\n");
            bundleSb.append("HINT_html-" + ct.getName() + "=\\" + "\n");
            bundleSb.append("<html>\\" + "\n");
            bundleSb.append("<b>" + getTitle(ct.getTitle()) + " Hint</b><br>\\" + "\n");
            bundleSb.append("</html>\\" + "\n\n");
            // txt .xml and .java
            genXml(ct);
            genJava(ct, ctg);
        }
        
        FileOutputStream fos = null;
        try {
            File f = new File(path + "/Bundle.properties.txt");
            GenUtil.createFile(f, false);
            fos = new FileOutputStream(f);
            IOUtil.copy(new StringReader(bundleSb.toString()), fos);
        } catch (Throwable e) {
            mLog.log(Level.SEVERE, "fail to generate Bundle.properties.txt for " + palette);
        } finally {
            try {
                fos.close();
            } catch (Exception ex){
            }
        }
    }
    
    // ${palette}
    // ${ct-name
    // ${iconx16}
    // ${iconx32}
    private void genXml(TcgComponentType ct) {
        String iconx16 = ct.getIconName();
        String iconx32 = ct.getName() + ".img";
        int idx = iconx16.indexOf("x16");
        if (0 <= idx) {
            iconx32 = iconx16.substring(0, idx) + "x32" + iconx16.substring(idx + 3);
        }
        
        String palette = (String)ct.getPropertyType(PALETTE_KEY).getDefaultValue();
        String s = mPaletteItemXml.replaceAll("\\$\\{palette\\}", palette);
        s = s.replaceAll("\\$\\{ct-name\\}", ct.getName());
        s = s.replaceAll("\\$\\{iconx16\\}", iconx16);
        s = s.replaceAll("\\$\\{iconx32\\}", iconx32);
        FileOutputStream fos = null;
        try {
            File f = new File(mITEMS_DIR + "/" + palette + "/" + ct.getName() + ".xml");
            GenUtil.createFile(f, false);
            fos = new FileOutputStream(f);
            IOUtil.copy(new StringReader(s), fos);
        } catch (Throwable e) {
            e.printStackTrace();
            mLog.log(Level.SEVERE, "fail to generate .xml for " + ct.getName());
        } finally {
            try {
                fos.close();
            } catch (Exception ex){
            }
        }
    }
    
    // ${palette}
    // ${palette}
    // ${ct-name}
    private void genJava(TcgComponentType ct, TcgComponentTypeGroup ctg) {
        String palette = (String)ct.getPropertyType(PALETTE_KEY).getDefaultValue();
        String s = mPaletteItemJava.replaceAll("\\$\\{palette\\}", palette);
        s = s.replaceAll("\\$\\{ctg-name\\}", ctg.getName());
        s = s.replaceAll("\\$\\{ct-name\\}", ct.getName());
        FileOutputStream fos = null;
        try {
            File f = new File(mITEMS_DIR + "/" + palette + "/" + ct.getName() + ".java");
            GenUtil.createFile(f, false);
            fos = new FileOutputStream(f);
            IOUtil.copy(new StringReader(s), fos);
        } catch (Throwable e) {
            e.printStackTrace();
            mLog.log(Level.SEVERE, "fail to generate .java for " + ct.getName());
        } finally {
            try {
                fos.close();
            } catch (Exception ex){
            }
        }
    }
    
    public void run() {
        List ctgList = TcgModelManager.getTcgComponentTypeGroupList();
        for (int i = 0; i < ctgList.size(); i++) {
            TcgComponentTypeGroup ctg = (TcgComponentTypeGroup) ctgList.get(i);
            List ctList = ctg.getComponentTypeList();
            for (int j = 0; j < ctList.size(); j++) {
                TcgComponentType ct = (TcgComponentType) ctList.get(j);
                if (ct.isVisible()) {
                    loadPaletteTable(ctg);
                    break;
                }
            }
        }
        
        // Generate palette in the alphabetic order
        List keyList = new ArrayList(mPaletteTable.keySet());
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); i++) {
            String palette = (String)keyList.get(i);
            genCode(palette);
        }
        
        String s = loadStr(mBUNDLE_FILE);
        s = s.replaceFirst(mMARK, mBundleSb.toString());
        FileOutputStream fos = null;
        try {
            File f = new File(mPALETTE_DIR + "/Bundle.properties.txt");
            GenUtil.createFile(f, false);
            fos = new FileOutputStream(f);
            IOUtil.copy(new StringReader(s), fos);
        } catch (Throwable e) {
            mLog.log(Level.SEVERE, "fail to generate " + mPALETTE_DIR + "/Bundle.properties.txt");
        } finally {
            try {
                fos.close();
            } catch (Exception ex){
            }
        }
        
        s = loadStr(mLAYER_FILE);
        s = s.replaceFirst(mMARK, mLayerSb.toString());
        try {
            fos = new FileOutputStream(mEDITOR_DIR + "/mf-layer.xml.txt");
            IOUtil.copy(new StringReader(s), fos);
        } catch (Exception e) {
            mLog.log(Level.SEVERE, "fail to generate " + mEDITOR_DIR + "/mf-layer.xml.txt");
        } finally {
            try {
                fos.close();
            } catch (Exception ex){
            }
        }
    }
    
    static class ComponentTypeAndGroupPair {
        private TcgComponentType mCt;
        private TcgComponentTypeGroup mCtg;
        
        public ComponentTypeAndGroupPair(TcgComponentType ct, TcgComponentTypeGroup ctg) {
            mCt = ct;
            mCtg = ctg;
        }
    }
}

