/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.sql.framework.ui.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.net.URL;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

import com.sun.sql.framework.utils.Logger;

/**
 * @version $Id: ButtonTableHeader.java,v 1.2 2007/09/27 10:08:45 yaroslavskiy Exp $
 * @author Ritesh Adval
 */
public class ButtonTableHeader extends JTableHeader {

    protected class ButtonTableRenderer implements TableCellRenderer {
        JButton _buttonLowered;
        JButton _buttonRaised;

        ButtonTableRenderer(Font font) {
            _buttonRaised = new JButton();
            _buttonRaised.setMargin(new Insets(0, 0, 0, 0));
            _buttonRaised.setFont(font);
            _buttonLowered = new JButton();
            _buttonLowered.setMargin(new Insets(0, 0, 0, 0));
            _buttonLowered.setFont(font);
            _buttonLowered.getModel().setArmed(true);
            _buttonLowered.getModel().setPressed(true);

            _buttonLowered.setMinimumSize(new Dimension(50, 25));
            _buttonRaised.setMinimumSize(new Dimension(50, 25));
        }

        public Component getTableCellRendererComponent(JTable aTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {

            if (value == null) {
                value = "";
            }

            // Rendering the column that the mouse has been pressed in.
            if (_pressedColumnIdx == column && _pressed) {
                _buttonLowered.setText(value.toString());

                // If this is the column that the table is currently is
                // currently sorted by then display the sort icon.
                if (column == _currentlySortedColumnIdx && _currentSortedColumnIcon != null) {
                    _buttonLowered.setIcon(_currentSortedColumnIcon);
                } else {
                    _buttonLowered.setIcon(null);
                }
                return _buttonLowered;
            }

            // This is not the column that the mouse has been pressed in.
            _buttonRaised.setText(value.toString());
            if (_currentSortedColumnIcon != null && column == _currentlySortedColumnIdx) {
                _buttonRaised.setIcon(_currentSortedColumnIcon);
            } else {
                _buttonRaised.setIcon(null);
            }
            return _buttonRaised;
        }
    }

    private class HeaderListener extends MouseAdapter implements MouseMotionListener {

        public void mouseDragged(MouseEvent e) {
            _dragged = true;
            if (_pressed) {
                _currentSortedColumnIcon = null;
                _currentlySortedColumnIdx = -1;
                _pressed = false;
                repaint();
            }
        }

        public void mouseMoved(MouseEvent e) {
            _dragged = false;
        }

        public void mousePressed(MouseEvent e) {
            _pressed = true;
            _pressedColumnIdx = columnAtPoint(e.getPoint());
            repaint();
        }

        public void mouseReleased(MouseEvent e) {
            _pressed = false;
            if (!_dragged) {
                _currentSortedColumnIcon = null;
                int column = getTable().convertColumnIndexToModel(_pressedColumnIdx);
                TableModel tm = table.getModel();

                if (column > -1 && column < tm.getColumnCount() && tm instanceof SortableTableModel) {
                    ((SortableTableModel) tm).sortByColumn(column);
                    if (((SortableTableModel) tm)._bAscending) {
                        _currentSortedColumnIcon = s_ascIcon;
                    } else {
                        _currentSortedColumnIcon = s_descIcon;
                    }
                    _currentlySortedColumnIdx = column;
                }
                repaint();
            }
            _dragged = false;
        }

    }

    private final class TableDataListener implements TableModelListener {
        public void tableChanged(TableModelEvent evt) {
            _currentSortedColumnIcon = null;
            _currentlySortedColumnIdx = -1;
        }

    }

    private static URL ascendingImgUrl = ButtonTableHeader.class.getResource("/org/netbeans/modules/sql/framework/ui/resources/images/arrow_up.gif");

    private static URL descendingImgUrl = ButtonTableHeader.class.getResource("/org/netbeans/modules/sql/framework/ui/resources/images/arrow_down.gif");
    /** Logger for this class. */
    private static final String LOG_CATEGORY = ButtonTableHeader.class.getName();

    /** Icon for "Sorted ascending". */
    private static Icon s_ascIcon;

    /** Icon for "Sorted descending". */
    private static Icon s_descIcon;

    /** Index of the currently sorted column. */
    private int _currentlySortedColumnIdx = -1;

    /** Icon for the currently sorted column. */
    private Icon _currentSortedColumnIcon;

    /** Listens for changes in the underlying data. */
    private TableDataListener _dataListener = new TableDataListener();

    /**
     * If <TT>true</TT> then the mouse is being dragged. This is only relevant while the
     * mouse is pressed.
     */
    private boolean _dragged;

    /** If <TT>true</TT> then the mouse button is currently pressed. */
    private boolean _pressed;

    /**
     * If <tt>_pressed</TT> is <tt>true</tt> then this is the column that the
     * mouse was pressed in.
     */
    private int _pressedColumnIdx;

    /**
     * Constructor for ButtonTableHeader.
     */
    public ButtonTableHeader() {
        super();
        _pressed = false;
        _dragged = false;
        _pressedColumnIdx = -1;

        setDefaultRenderer(new ButtonTableRenderer(getFont()));

        HeaderListener hl = new HeaderListener();
        addMouseListener(hl);
        addMouseMotionListener(hl);
        loadImages();
    }

    public void setTable(JTable table) {
        JTable oldTable = getTable();
        if (oldTable != null) {
            Object obj = oldTable.getModel();
            if (obj instanceof SortableTableModel) {
                SortableTableModel model = (SortableTableModel) obj;
                model.getActualModel().removeTableModelListener(_dataListener);
            }
        }

        super.setTable(table);

        if (table != null) {
            Object obj = table.getModel();
            if (obj instanceof SortableTableModel) {
                SortableTableModel model = (SortableTableModel) obj;
                model.getActualModel().addTableModelListener(_dataListener);
            }
        }
        _currentSortedColumnIcon = null;
        _currentlySortedColumnIdx = -1;
    }

    private void loadImages() {
        try {
            if (s_descIcon == null || s_ascIcon == null) {
                s_descIcon = new ImageIcon(descendingImgUrl);
                s_ascIcon = new ImageIcon(ascendingImgUrl);
            }
        } catch (Exception ex) {
            Logger.printThrowable(Logger.ERROR, LOG_CATEGORY, "static Initializer", "Error setting icon for sorting", ex);
        }
    }

}
