/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.sql.framework.highlighter;

import java.util.Comparator;

/**
 * A comparator appropriate for use with Collections of DocPositions.
 * 
 * @author Ahimanikya Satapathy
 * @version $Revision: 1.2 $
 */

class DocPositionComparator implements Comparator {

    /**
     * Compare two DocPositions
     * 
     * @param o1 first DocPosition
     * @param o2 second DocPosition
     * @return negative if first < second, 0 if equal, positive if first > second
     */
    public int compare(Object o1, Object o2) {
        if (o1 instanceof DocPosition && o2 instanceof DocPosition) {
            DocPosition d1 = (DocPosition) (o1);
            DocPosition d2 = (DocPosition) (o2);
            return (d1.getPosition() - d2.getPosition());
        } else if (o1 instanceof DocPosition) {
            return -1;
        } else if (o2 instanceof DocPosition) {
            return 1;
        } else if (o1.hashCode() < o2.hashCode()) {
            return -1;
        } else if (o2.hashCode() > o1.hashCode()) {
            return 1;
        } else {
            return 0;
        }
    }
    /**
     * Does this Comparator equal another? Since all DocPositionComparators are the same,
     * they are all equal.
     * 
     * @return true for DocPositionComparators, false otherwise.
     */
    public boolean equals(Object obj) {
        if (obj instanceof DocPositionComparator) {
            return true;
        }
        return false;
    }
}

