/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.sql.framework.evaluators.database.db2v7;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.netbeans.modules.sql.framework.evaluators.database.AbstractEvaluator;
import org.netbeans.modules.sql.framework.evaluators.database.StatementContext;
import org.netbeans.modules.sql.framework.model.SQLConstants;
import org.netbeans.modules.sql.framework.model.SQLGenericOperator;
import org.netbeans.modules.sql.framework.model.SQLLiteral;
import org.netbeans.modules.sql.framework.model.SQLObject;
import org.netbeans.modules.sql.framework.model.SQLOperatorArg;
import org.netbeans.modules.sql.framework.model.SQLOperatorDefinition;

import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.utils.StringUtil;

/**
 * @author Rupesh Ramachandran
 * @author Ritesh Adval
 * @version $Revision: 1.2 $
 */
public class DB2V7DateAddOperatorEvaluator extends AbstractEvaluator {

    public String evaluate(SQLObject obj, StatementContext context) throws BaseException {
        String result;
        SQLGenericOperator operator = (SQLGenericOperator) obj;

        SQLLiteral literal = (SQLLiteral) operator.getArgumentValue("type");
        if (literal == null) {
            throw new BaseException("Failed to evaluate " + operator.getOperatorType() + ", \"type\" is null.");
        }

        String intervalType = literal.getValue();
        intervalType = intervalType.toLowerCase();

        // DATEADD: $timestamp1 + $interval $type
        // e.g. TS_COL + 2 day

        // get all necessary data.
        Map params = operator.getSQLObjectMap();

        // allow overridable operator factory so other db's can override date add
        SQLOperatorDefinition defn = this.getDB().getOperatorFactory().getSQLOperatorDefinition(operator.getOperatorType());

        Map resolvedparams = new HashMap();
        List args = defn.getArgList();

        for (int i = 0; i < args.size(); i++) {
            String key = ((SQLOperatorArg) args.get(i)).getArgName();
            SQLObject val = (SQLObject) params.get(key);
            if (val != null) {
                String eval = this.getEvaluatorFactory().evaluate(val, context);
                // replace 'week' and 'quarter' intervals using days/months
                if (key.equals("interval")) {
                    if (intervalType.equalsIgnoreCase("week")) {
                        // use week as 7 days
                        eval = "(" + eval + "*7)";
                    }
                    if (intervalType.equalsIgnoreCase("quarter")) {
                        // use quarter as 3 months
                        eval = "(" + eval + "*3)";
                    }
                }
                resolvedparams.put(key, eval);
            }
        }

        // use string; week and quarter not supported, so replace
        String intType = intervalType.replaceFirst("week", "day");
        intType = intType.replaceFirst("quarter", "month");
        resolvedparams.put("type", intType);

        result = StringUtil.replace(defn.getScript(), resolvedparams, SQLConstants.OPERATOR_VARIABLE_PREFIX);

        return result;
    }

    /**
     * converts the string interval type to the appropriate literal representation of the
     * interval in that DB
     * 
     * @param intervalType interval type selected from operator drop-down menu
     * @return interval literal string.
     */
    protected String translateIntervalTypeToLiteral(String intervalType) {
        String literal = "<UNKNOWN_INTERVAL_TYPE>";
        if (intervalType.equals("second"))
            literal = "2";
        else if (intervalType.equals("minute"))
            literal = "4";
        else if (intervalType.equals("hour"))
            literal = "8";
        else if (intervalType.equals("day"))
            literal = "16";
        else if (intervalType.equals("week"))
            literal = "32";
        else if (intervalType.equals("month"))
            literal = "64";
        else if (intervalType.equals("quarter"))
            literal = "128";
        else if (intervalType.equals("year"))
            literal = "256";
        return literal;
    }

}