/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.sql.framework.evaluators.database.base;

import java.util.Map;

import org.netbeans.modules.sql.framework.evaluators.database.AbstractDB;
import org.netbeans.modules.sql.framework.evaluators.database.AbstractEvaluatorFactory;
import org.netbeans.modules.sql.framework.evaluators.database.SQLOperatorFactory;
import org.netbeans.modules.sql.framework.evaluators.database.Statements;
import org.netbeans.modules.sql.framework.evaluators.database.TypeEvaluator;

import com.sun.sql.framework.jdbc.DBConstants;

/**
 * @author Ritesh Adval
 * @version $Revision: 1.2 $
 */
public class BaseDB extends AbstractDB {

    private static final String BASE_TEMPLATE_FILE = "/org/netbeans/modules/sql/framework/evaluators/database/base/config/templates.xml";

    private static final String BASE_OPERATOR_DEFINITION_FILE = "org/netbeans/modules/sql/framework/evaluators/database/base/config/operator-script.xml";

    protected SQLOperatorFactory factory;

    public int getCastingRule(int sourceType, int targetType) {
        return 0;
    }

    public String getDefaultDateFormat() {
        return null;
    }

    public String getEscapedName(String name) {
        return name;
    }

    public String getUnescapedName(String name) {
        return name;
    }

    /**
     * get the name after applying DB specfic escaping.
     * 
     * @param name name which needs to be escaped.
     * @return name after escaping it.
     */
    public String getEscapedCatalogName(String name) {
        return this.getEscapedName(name);
    }

    /**
     * get the name after applying DB specfic escaping.
     * 
     * @param name name which needs to be escaped.
     * @return name after escaping it.
     */
    public String getEscapedSchemaName(String name) {
        return this.getEscapedName(name);
    }

    public int getMaxTableNameLength() {
        return 0;
    }

    public boolean isAnsiJoinSyntaxSupported() {
        return true;
    }

    public AbstractEvaluatorFactory createEvaluatorFactory() {
        return new BaseEvaluatorFactory(this);
    }

    public Statements createStatements() {
        return new BaseStatements(this);
    }

    public TypeEvaluator createTypeEvaluator() {
        return new BaseTypeEvaluator();
    }

    /**
     * Override this method in a concrete vendor-specific class to load the localized
     * template file and override any desired template mappings.
     */
    protected Map loadTemplates() {
        templateMaps = loadTemplates(BASE_TEMPLATE_FILE);
        return templateMaps;
    }

    /**
     * get the operator factory for this data base
     * 
     * @return operator factory
     */
    public SQLOperatorFactory getOperatorFactory() {
        if (factory == null) {
            factory = new SQLOperatorFactory(BASE_OPERATOR_DEFINITION_FILE, null);
        }
        return factory;
    }

    public int getDBType(){
        return DBConstants.ANSI92;
    }
}
