/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.output;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/**
 * Action which opens mapper window.
 *
 * @author  radval
 */
public final class MapperWindowOpenAction extends AbstractAction {

    /**
     * Creates an instance of this action.
     */
    public MapperWindowOpenAction() {
        String name = NbBundle.getMessage(MapperWindowOpenAction.class,
                                          "TITLE_MAPPER_WINDOW");        //NOI18N
        putValue(NAME, name);
        putValue("iconBase",                                            //NOI18N
               "org/netbeans/modules/bpel/xpath/view/resources/images/mapper.png");//NOI18N
        initializeShortCut();
    }
    
    /**
     * Opens and activates the JUnit Test Results window.
     *
     * @param  e  event that caused this action to be called
     */
    public void actionPerformed(ActionEvent e) {
        ResultWindow resultWindow = ResultWindow.getInstance();
        resultWindow.open();
        resultWindow.requestActive();
    }
    
    /** TODO: Figure why it's necessary to set shortcuts here when it's
     *  declared in the layer.xml; just doesn't show up in the Window
     *  drop-down menu--however pressing the shortcut still brings up
     *  the mapper though!!
     *  @since  5.5
     */
    private void initializeShortCut() {
        try {
            FileObject root = Repository.getDefault().getDefaultFileSystem()
                    .getRoot();
            FileObject shortcutsFileObject = root.getFileObject("Shortcuts");   // NOI18N
            if (null == shortcutsFileObject) {
                return;
            }
            DataFolder folder = DataFolder.findFolder(shortcutsFileObject);
            if (null == folder) {
                return;
            }
            Enumeration en = folder.children(false);
            while (en.hasMoreElements()) {
                DataObject dataObject = (DataObject) en.nextElement ();
                if (dataObject instanceof DataFolder) {
                    continue;
                }
                InstanceCookie ic = (InstanceCookie) dataObject.getCookie(
                        InstanceCookie.class);
                if (null == ic) {
                    continue;
                }
                if (getClass().getName().equals(ic.instanceName())) {
                    KeyStroke keyStroke =
                            Utilities.stringToKey(dataObject.getName());
                    putValue(ACCELERATOR_KEY, keyStroke);
                    break;
                }
            }
        } catch (Exception ex) {
        }
    }
}
