/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view.expression.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Map;

import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.xpath.model.node.visitor.DownstreamVariableFinderVisitor;
import org.netbeans.modules.bpel.xpath.model.node.visitor.UpstreamVariableFinderVisitor;
import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeDisplayNameGeneratorVisitor;
import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeIconSelectorVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariableNode;
import org.netbeans.modules.bpel.xpath.view.expression.TargetTreeCellRendererFactory;
import org.openide.util.NbBundle;

/**
 *
 * @author radval
 *
 */
public class TargetTreeCellRendererFactoryImpl extends TargetTreeCellRendererFactory {
    
    /**
     * the font size this tree use
     */
    private static int mFontSize = 10;
    
    
    public TreeCellRenderer createAssignUpstreamExpressionTreeCellRenderer(BpelEntity entity) {
        return new BusinessProcessTreeCellRenderer(entity, true);
    }
    
    public TreeCellRenderer createAssignDownstreamExpressionTreeCellRenderer(BpelEntity entity) {
        return new BusinessProcessTreeCellRenderer(entity, false);
    }
    
    public TreeCellRenderer createAssignExpressionTreeCellRenderer() {
        return new BusinessProcessTreeCellRenderer();
    }
    
    public TreeCellRenderer createBooleanExpressionTreeCellRenderer() {
        return new BusinessProcessTreeCellRenderer();
    }
    
    public TreeCellRenderer createPredicateExpressionTreeCellRenderer() {
        return new BusinessProcessTreeCellRenderer();
    }
    
    public TreeCellRenderer createDeadlineExpressionTreeCellRenderer() {
        return new BusinessProcessTreeCellRenderer();
    }
    
    public TreeCellRenderer createDurationExpressionTreeCellRenderer() {
        return new BusinessProcessTreeCellRenderer();
    }
    
    public TreeCellRenderer createForEachExpressionTreeCellRenderer() {
        return new BusinessProcessTreeCellRenderer();
    }
    
    public int getMFontSize() {
        return mFontSize;
    }
    
    
    
    private static class BusinessProcessTreeCellRenderer extends DefaultTreeCellRenderer {
        
        private BpelEntity mEntity;
        private Font mFont;
        private boolean mIsUpstream;
        
        public BusinessProcessTreeCellRenderer() {
            this(null, false);
        }
        
        public BusinessProcessTreeCellRenderer(BpelEntity entity, boolean isUpstream) {
            super();
            mEntity = entity;
            mIsUpstream = isUpstream;
        }
        
        
        /**
         * Overrides the one inthe superclass. Assigns the appropriate icon for a
         * cell in the tree.
         *
         * @param tree the tree
         * @param value the new value of the tree cell
         * @param selected flag whether node is selected or not
         * @param expanded flag whether node is expanded or not
         * @param leaf flag whether node is leaf or not
         * @param row the row number of the node
         * @param hasFocus flag whether node has focus or not
         * @return the Component that the renderer uses to draw the value
         */
        public Component getTreeCellRendererComponent(JTree tree,
                Object value,
                boolean selected,
                boolean expanded,
                boolean leaf,
                int row,
                boolean hasFocus)
        {
            Component comp = super.getTreeCellRendererComponent(tree,
                    "",
                    selected,
                    expanded,
                    leaf,
                    row,
                    hasFocus);
            ToolTipManager.sharedInstance().registerComponent(tree);
            
            if (mFont == null) {
                mFont = getFont();
            }
            
            if (value instanceof TreeNode) {
                TreeNode node = (TreeNode) value;
                NodeDisplayNameGeneratorVisitor ndnGenerator = new NodeDisplayNameGeneratorVisitor();
                node.accept(ndnGenerator);
                String displayName = ndnGenerator.getDisplayName();
                if (displayName == null || displayName.trim().equals("")) {
                    setText(NbBundle.getMessage(BusinessProcessTreeCellRenderer.class,
                            "BusinessProcessTreeCellRenderer_UNKNOWN_NODE_TYPE"));  // NOI18N
                } else {
                    setText(displayName);
                }
                
                NodeIconSelectorVisitor nisSelector = new NodeIconSelectorVisitor();
                node.accept(nisSelector);
                Icon icon = nisSelector.getIcon();
                setIcon(icon);
                
                setFont(mFont);
                if (mEntity != null && node instanceof VariableNode) {
                    if (isVariableNodeInStream( (VariableNode) node )) {
                        // If we are an upstream renderer, bold the upstream variable.
                        // If we are a downstream renderer, bold the downstream variable.
                        setFont(mFont.deriveFont(Font.BOLD));
                    }
                }
                
                Color foreground = selected ? getTextSelectionColor() : getTextNonSelectionColor();
                if (!selected && node.getHighlightColor() != null) {
                    foreground = node.getHighlightColor();
                }
                comp.setForeground(foreground);
                
                // Disable for now, tooltip generation has performance issues.
                // TODO - jsandusky
//		       NodeToolTipTextGeneratorVisitor ntttGenerator = new NodeToolTipTextGeneratorVisitor();
//		       node.accept(ntttGenerator);
//		       String toolTipText = ntttGenerator.getToolTipText();
//		       setToolTipText(toolTipText);
                if (selected) {
                    comp.setBackground(Color.blue);
                }
            }
            
            return comp;
        }
        
        // For the given variable node, if it is the nearest upstream or
        // downstream variable, then return true. Note: variable nodes
        // that are conditionally reachable are not in the stream, because
        // are essentially branched out of context.
        private boolean isVariableNodeInStream(VariableNode variableNode) {
            Map entities = null;
            if (mIsUpstream) {
                UpstreamVariableFinderVisitor unroller = new UpstreamVariableFinderVisitor(mEntity);
                entities = unroller.getMatchingVariables();
            } else {
                DownstreamVariableFinderVisitor unroller = new DownstreamVariableFinderVisitor(mEntity);
                entities = unroller.getMatchingVariables();
            }
            if (
                    entities != null &&
                    entities.get(variableNode.getName()) != null) {
                return true;
            }
            return false;
        }

    }
}
