/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.view;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.bpel.xpath.model.nodes.NodeFactory;
import org.netbeans.modules.bpel.xpath.view.expression.impl.MapperView;
import org.netbeans.modules.bpel.xpath.view.palette.IPaletteConstants;
import org.netbeans.modules.bpel.xpath.view.palette.XpathPaletteItemInfo;
import org.netbeans.modules.bpel.xpath.view.palette.XpathPaletteManager;
import org.netbeans.modules.soa.mapper.common.IMapperEvent;
import org.netbeans.modules.soa.mapper.common.IMapperLink;
import org.netbeans.modules.soa.mapper.common.IMapperNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapper;
import org.netbeans.modules.soa.mapper.common.basicmapper.IBasicMapperRule;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoid;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoidNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.tree.IMapperTreeNode;
import org.netbeans.modules.soa.mapper.common.ui.palette.IPaletteItem;
import org.netbeans.modules.xml.xpath.AbstractXPathModelHelper;
import org.netbeans.modules.xml.xpath.XPathExpression;
import org.netbeans.modules.xml.xpath.XPathOperationOrFuntion;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/**
 *
 * @author jsandusky
 */
public abstract class AbstractMapperRule implements IBasicMapperRule {
    
    protected static final Logger LOGGER = Logger.getLogger(AbstractMapperRule.class.getName());
    
    private MapperView mMapper;
    private AbstractXPathExpressionBuilder mBuilder;
    private AbstractXPathExpressionUpdater mUpdater;

    
    /** Creates a new instance of AbstractMapperRule */
    public AbstractMapperRule(MapperView mapper,
                              AbstractXPathExpressionBuilder builder, 
                              AbstractXPathExpressionUpdater destroyer)
    {
        this.mMapper = mapper;
	this.mBuilder = builder;
	this.mUpdater = destroyer;
    }

    
    protected MapperView getMapperView()
    {
        return this.mMapper;
    }
    
    public void eventInvoked(IMapperEvent e)
    {
        boolean changeMade = false;
        Object eventObject = e.getTransferObject();
        
        LOGGER.finer(NbBundle.getMessage(AbstractMapperRule.class,
                "STR_EVENT_INVOKED_TYPE_X_OBJECT_Y",    // NOI18N
                e.getEventType(), eventObject));
        
        if (e.getEventType().equals(IMapperEvent.REQ_NEW_LINK) && 
                isAllowToCreate((IMapperLink) eventObject)) {
            LOGGER.finer(NbBundle.getMessage(AbstractMapperRule.class,
                    "STR_EVENT_LINK_ADDED"));   // NOI18N
            
            IMapperLink link = (IMapperLink) eventObject;
            mBuilder.addMapping(
                    (IMapperNode) link.getStartNode(),
                    (IMapperNode) link.getEndNode(), 
                    link);
            
            getMapper().addLink((IMapperLink) eventObject);
            
            // add the destination tree node to the list
            // of paths that need to be
            // remembered for the state of the mapper tree.
            if (link.getEndNode() instanceof IMapperTreeNode) {
                LOGGER.finer("In AbstractMapperRule: firing Tree Event");   // NOI18N
                fireTargetTreeEvent(((IMapperTreeNode) link.getEndNode()).getPath());
            }
            
        } else if (
                e.getEventType().equals(IMapperEvent.REQ_NEW_NODE) && 
                isAllowToCreate((IMapperNode) eventObject)) {
            IMethoidNode mNode = (IMethoidNode) e.getTransferObject();
            handleNewOperator(mNode);
            
        } else if (
                e.getEventType().equals(IMapperEvent.REQ_DEL_LINK) && 
                isAllowToRemove((IMapperLink) eventObject)) {
            IMapperLink link = (IMapperLink) eventObject;
            mUpdater.updateMapping(
                    (IMapperNode) link.getStartNode(),
                    (IMapperNode) link.getEndNode(), 
                    link,
                    true);
            getMapper().removeLink((IMapperLink) eventObject);
            changeMade = true;
        
        } else if (
                e.getEventType().equals(IMapperEvent.REQ_DEL_NODE) && 
                isAllowToRemove((IMapperNode) eventObject)) {
            IMapperNode mapperNode = (IMapperNode) eventObject;
            this.mUpdater.updateMapperNode(mapperNode, true);
            getMapper().removeNode(mapperNode);
            changeMade = true;
            
        } else if (
                e.getEventType().equals(IMapperEvent.REQ_UPDATE_LINK) && 
                isAllowToRemove((IMapperLink) eventObject)) {
            IMapperLink link = (IMapperLink) eventObject;
            mUpdater.updateMapping(
                    (IMapperNode) link.getStartNode(),
                    (IMapperNode) link.getEndNode(), 
                    link,
                    false);
            changeMade = true;
            
        } else if (
                e.getEventType().equals(IMapperEvent.REQ_UPDATE_NODE) && 
                isAllowToRemove((IMapperNode) eventObject)) {
            IMapperNode mapperNode = (IMapperNode) eventObject;
            this.mUpdater.updateMapperNode(mapperNode, false);
            changeMade = true;
        }
    }
    
    protected void fireTargetTreeEvent(TreePath tp) {
        if (tp != null) {
            getMapper().getMapperViewManager().getDestView().getTree().fireTreeExpanded(tp);
            /* ALK: 66094   Scroll causes refresh problem without repaint */
            /* if Joseph test of repaint fails comment out the following two lines */
            /*                  getMapper()
                                .getMapperViewManager()
                                .getDestView().getTree().
                                scrollPathToVisible(tp);
                                getMapper()
                                .getMapperViewManager()
                                .getDestView()
                                .getViewComponent().repaint();
             */
        }
    }
    
    private void handleNewOperator(IMethoidNode mNode) {
        IMethoid methoid = (IMethoid) mNode.getMethoidObject();
        Object dObj = methoid.getData();
        IPaletteItem pItem;
        if (dObj instanceof IPaletteItem) {
            pItem = (IPaletteItem) dObj;
        } else {
            // logger
            return;
        }
        
        List fieldNodes = mNode.getOutputFieldNodes();
        IFieldNode fieldNode = (IFieldNode) fieldNodes.get(0);
        
        String methodName = (String) pItem.getItemAttribute("Method");  // NOI18N
        if (methodName == null || ("").equals(methodName.trim())) {
            return;
        }
        
        if (methodName.equals(IPaletteConstants.NUMBER_LITERAL)) {
            
            // NUMERIC LITERAL
            XPathExpression exprObj =
                    AbstractXPathModelHelper.getInstance().newXPathNumericLiteral(new Long(0));
            fieldNode.setName("0");
            Node dataNode = NodeFactory.getInstance().createNode(exprObj);
            mNode.setNodeObject(dataNode);
            fieldNode.setNodeObject(dataNode);
            getMapper().addNode(mNode);
            
            mMapper.getLiteralUpdaterFactory().getNumericUpdater().getEditor(
                    getMapperView().getBasicMapper(), fieldNode).show();
            
            return;
            
        } else if (methodName.equals(IPaletteConstants.DURATION_LITERAL)) {
            String initValue = "P0Y0M0DT0H0M0S";        // NOI18N
            XPathExpression exprObj =
                    AbstractXPathModelHelper.getInstance()
                        .newXPathStringLiteral(initValue);
            fieldNode.setName(initValue);
            
            Node dataNode = NodeFactory.getInstance().createNode(exprObj);
            mNode.setNodeObject(dataNode);
            fieldNode.setNodeObject(dataNode);
            getMapper().addNode(mNode);
            
            mMapper.getLiteralUpdaterFactory().getStringUpdater().getEditor(
                    getMapperView().getBasicMapper(), fieldNode).show();
            
            return;
        } else if (methodName.equals(IPaletteConstants.STRING_LITERAL)) {
            
            // STRING LITERAL
            XPathExpression exprObj =
                    AbstractXPathModelHelper.getInstance().newXPathStringLiteral("");
            fieldNode.setName("");
            
            Node dataNode = NodeFactory.getInstance().createNode(exprObj);
            mNode.setNodeObject(dataNode);
            fieldNode.setNodeObject(dataNode);
            getMapper().addNode(mNode);
            
            mMapper.getLiteralUpdaterFactory().getStringUpdater().getEditor(
                    getMapperView().getBasicMapper(), fieldNode).show();
            
            return;
            
        } else {
            XpathPaletteItemInfo pItemInfo = XpathPaletteManager.getDefault().getItemInfoByMethodName(methodName);
            String oper = pItemInfo.getOperation();
            if (oper == null) {
                displayErrorPane();
                return;
            }
            
            XPathOperationOrFuntion expr = null;
            
            if (AbstractXPathModelHelper.getInstance().getOperatorType(oper) != null) {
                expr = AbstractXPathModelHelper.getInstance().newXPathCoreOperation
                        (AbstractXPathModelHelper.getInstance().getOperatorType(oper).intValue());
            } else if (AbstractXPathModelHelper.getInstance().getFunctionType(oper) != null) {
                int typeID =
                        AbstractXPathModelHelper.getInstance().getFunctionType(oper).intValue();
                expr = AbstractXPathModelHelper.getInstance().newXPathCoreFunction(typeID);
            } else {
                expr = AbstractXPathModelHelper.getInstance().newXPathExtensionFunction(oper);
            }
            
            if(expr == null) {
                displayErrorPane();
                return;
            }
            
            Node node = NodeFactory.getInstance().createNode(expr);
            mNode.setNodeObject(node);
            fieldNode.setNodeObject(node);
            node.setMapperNode(mNode);
            
            getMapper().addNode(mNode);
        }
    }
    
    public IBasicMapper getMapper() {
        return getMapperView().getBasicMapper();
    }
    
    private static void displayErrorPane() {
        NotifyDescriptor d = new NotifyDescriptor.
                Message(NbBundle.getMessage(AbstractMapperRule.class,
                    "STR_UNSUPPORTED_OPERATION"),   // NOI18N
                    NotifyDescriptor.INFORMATION_MESSAGE);
        DialogDisplayer.getDefault().notify(d);
        return;
        
    }
    
    /**
     * Describe <code>getMethodName</code> method here.
     * This is just a helper method.
     *
     * @param methoidNode an <code>IMethoidNode</code> value
     * @return a <code>String</code> value
     */
    public static final String getMethodName(IMethoidNode methoidNode) {
        IMethoid methoid = (IMethoid) methoidNode.getMethoidObject();
        Object dObj = methoid.getData();
        IPaletteItem pItem = null;
        if (dObj instanceof IPaletteItem) {
            pItem = (IPaletteItem) dObj;
        } else {
            displayErrorPane();
        }
        String methodName = (String) pItem.getItemAttribute("Method");  // NOI18N
        if (methodName == null || ("").equals(methodName.trim())) {
            displayErrorPane();
        }
        return methodName;
    }
}
