/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.model.nodes.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

import org.netbeans.modules.bpel.xpath.model.node.visitor.NodeVisitor;
import org.netbeans.modules.bpel.xpath.model.nodes.CanvasNode;
import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.bpel.xpath.model.nodes.NodeFactory;
import org.netbeans.modules.xml.xpath.AbstractXPathModelHelper;
import org.netbeans.modules.xml.xpath.XPathExpression;
import org.netbeans.modules.xml.xpath.XPathModel;

import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IFieldNode;
import org.netbeans.modules.soa.mapper.common.basicmapper.methoid.IMethoidNode;
import org.netbeans.modules.soa.mapper.common.IMapperNode;

/**
 *
 * @author radval
 *
 */
public abstract class AbstractCanvasNode extends AbstractNode 
implements CanvasNode {
    
    protected List mInputList = new ArrayList();
    protected List mOutputList = new ArrayList();
    
    
    public AbstractCanvasNode(Object dataObject) {
        super(dataObject);
    }
    
    
    public void addInput(Node input) {
        this.mInputList.add(input);
    }
    
    public void addOutput(Node output) {
        this.mOutputList.add(output);
    }
    
    public List getInputs() {
        return this.mInputList;
    }
    
    public List getOutputs() {
        return this.mOutputList;
    }
    
    public void removeInput(Node input) {
        if(this.mInputList.contains(input)) {
            this.mInputList.remove(input);
        }
    }
    
    public void removeOutput(Node output) {
        if(this.mOutputList.contains(output)) {
            this.mOutputList.remove(output);
        }
    }
    
    protected void visitInputs(NodeVisitor visitor) {
        List inputs = getInputs();
        Iterator it = inputs.iterator();
        while(it.hasNext()) {
            Node input = (Node) it.next();
            input.accept(visitor);
        }
    }
    
    protected void visitOutputs(NodeVisitor visitor) {
        List outputs = getOutputs();
        Iterator it = outputs.iterator();
        while(it.hasNext()) {
            Node output = (Node) it.next();
            output.accept(visitor);
        }
    }
}
