/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.model.nodes;

import java.util.HashSet;
import java.util.Set;

import javax.xml.namespace.QName;

/**
 *
 * @author radval
 *
 */
public class BuiltInXSDTypes {

    private static Set mBuiltInDataTypes = new HashSet();

    // Following strings are all NOI18N
    public static final String SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final QName STRING_TYPE = new QName(SCHEMA_NAMESPACE, "string");
    public static final QName BOOLEAN_TYPE = new QName(SCHEMA_NAMESPACE, "boolean");
    public static final QName DECIMAL_TYPE = new QName(SCHEMA_NAMESPACE, "decimal");
    public static final QName FLOAT_TYPE = new QName(SCHEMA_NAMESPACE, "float");
    public static final QName DOUBLE_TYPE = new QName(SCHEMA_NAMESPACE, "double");
    public static final QName LONG_TYPE = new QName(SCHEMA_NAMESPACE, "long");
    public static final QName INT_TYPE = new QName(SCHEMA_NAMESPACE, "int");
    public static final QName SHORT_TYPE = new QName(SCHEMA_NAMESPACE, "short");
    public static final QName BYTE_TYPE = new QName(SCHEMA_NAMESPACE, "byte");
    public static final QName DURATION_TYPE = new QName(SCHEMA_NAMESPACE, "duration"); 
    public static final QName DATE_TIME_TYPE = new QName(SCHEMA_NAMESPACE, "dateTime"); 
    public static final QName TIME_TYPE = new QName(SCHEMA_NAMESPACE, "time");
    public static final QName DATE_TYPE = new QName(SCHEMA_NAMESPACE, "date");
    public static final QName YEAR_MONTH_TYPE = new QName(SCHEMA_NAMESPACE, "gYearMonth");
    public static final QName YEAR_TYPE = new QName(SCHEMA_NAMESPACE, "gYear");
    public static final QName MONTH_DAY_TYPE = new QName(SCHEMA_NAMESPACE, "gMonthDay");
    public static final QName DAY_TYPE = new QName(SCHEMA_NAMESPACE, "gDay");
    public static final QName MONTH_TYPE = new QName(SCHEMA_NAMESPACE, "gMonth"); 
    public static final QName HEX_BINARY_TYPE = new QName(SCHEMA_NAMESPACE, "hexBinary"); 
    public static final QName BASE64_BINARY_TYPE = new QName(SCHEMA_NAMESPACE, "base64Binary");
    public static final QName ANYURI_TYPE = new QName(SCHEMA_NAMESPACE, "anyURI");
    public static final QName QNAME_TYPE = new QName(SCHEMA_NAMESPACE, "QName");
    public static final QName NOTATION_TYPE = new QName(SCHEMA_NAMESPACE, "NOTATION");
    public static final QName ANY_TYPE = new QName(SCHEMA_NAMESPACE, "anyType");

    static {
        mBuiltInDataTypes.add(BuiltInXSDTypes.STRING_TYPE);
        mBuiltInDataTypes.add(BuiltInXSDTypes.BOOLEAN_TYPE);

        mBuiltInDataTypes.add(BuiltInXSDTypes.DECIMAL_TYPE);
        mBuiltInDataTypes.add(BuiltInXSDTypes.FLOAT_TYPE);
        mBuiltInDataTypes.add(BuiltInXSDTypes.DOUBLE_TYPE);
        mBuiltInDataTypes.add(BuiltInXSDTypes.LONG_TYPE);
        mBuiltInDataTypes.add(BuiltInXSDTypes.INT_TYPE);
        mBuiltInDataTypes.add(BuiltInXSDTypes.SHORT_TYPE);
        mBuiltInDataTypes.add(BuiltInXSDTypes.BYTE_TYPE);

        mBuiltInDataTypes.add(BuiltInXSDTypes.DURATION_TYPE);
        mBuiltInDataTypes.add(BuiltInXSDTypes.DATE_TIME_TYPE);
        mBuiltInDataTypes.add(BuiltInXSDTypes.TIME_TYPE);
        mBuiltInDataTypes.add(BuiltInXSDTypes.DATE_TYPE);
        mBuiltInDataTypes.add(BuiltInXSDTypes.YEAR_MONTH_TYPE);
        mBuiltInDataTypes.add(BuiltInXSDTypes.YEAR_TYPE);
        mBuiltInDataTypes.add(BuiltInXSDTypes.MONTH_DAY_TYPE);
        mBuiltInDataTypes.add(BuiltInXSDTypes.DAY_TYPE);
        mBuiltInDataTypes.add(BuiltInXSDTypes.MONTH_TYPE);

        mBuiltInDataTypes.add(BuiltInXSDTypes.HEX_BINARY_TYPE);
        mBuiltInDataTypes.add(BuiltInXSDTypes.BASE64_BINARY_TYPE);

        mBuiltInDataTypes.add(BuiltInXSDTypes.ANYURI_TYPE);
        mBuiltInDataTypes.add(BuiltInXSDTypes.QNAME_TYPE);
        mBuiltInDataTypes.add(BuiltInXSDTypes.NOTATION_TYPE);

        mBuiltInDataTypes.add(BuiltInXSDTypes.ANY_TYPE);
    }

    public static boolean isBuiltInType(QName type) {
        if (type != null) {
            return mBuiltInDataTypes.contains(type);
        }

        return false;
    }
}
