/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.xpath.model.node.visitor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.bpel.xpath.model.nodes.BooleanPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.BranchesPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.CanvasNode;
import org.netbeans.modules.bpel.xpath.model.nodes.DeadlinePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.DurationPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.FinalCounterValuePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.Node;
import org.netbeans.modules.bpel.xpath.model.nodes.PartNode;
import org.netbeans.modules.bpel.xpath.model.nodes.PredicatePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.RootPlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.StartCounterValuePlaceHolderNode;
import org.netbeans.modules.bpel.xpath.model.nodes.TreeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariableNode;
import org.netbeans.modules.bpel.xpath.model.nodes.VariablesNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathLiteralNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathLocationStepNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathOperatorNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathPredicateNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XPathPredicatesNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDAttributeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDComplexTypeNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDElementNode;
import org.netbeans.modules.bpel.xpath.model.nodes.XSDSimpleTypeNode;
import org.netbeans.modules.soa.mapper.basicmapper.methoid.BasicMethoid;
import org.netbeans.modules.soa.mapper.basicmapper.methoid.BasicMethoidNode;
import org.openide.util.NbBundle;

/**
 *
 * @author jsandusky
 */
public class ValidateVisitor extends AbstractNodeVisitor {
    
    private List mVisitedNodes;
    private StringBuffer mBuf;
    
    /** Creates a new instance of ValidateVisitor */
    public ValidateVisitor() {
        mVisitedNodes = new ArrayList();
        mBuf = new StringBuffer();
    }
    
    public void visit(VariablesNode node) {
        visitTreeNode(node);
    }
    
    public void visit(VariableNode node) {
        visitTreeNode(node);
    }
    
    public void visit(PartNode node) {
        visitTreeNode(node);
    }
    
    public void visit(XSDAttributeNode node) {
        visitTreeNode(node);
    }
    
    public void visit(XSDElementNode node) {
        visitTreeNode(node);
    }
    
    public void visit(XSDComplexTypeNode node) {
        visitTreeNode(node);
    }
    
    public void visit(XSDSimpleTypeNode node) {
        visitTreeNode(node);
    }
    
    public void visit(XPathOperatorNode node) {
        visitCanvasNode(node);
    }
    
    public void visit(XPathLiteralNode node) {
        visitCanvasNode(node);
    }
    
    public void visit(XPathPredicateNode node) {
        visitTreeNode(node);
    }
    
    public void visit(XPathPredicatesNode node) {
        visitTreeNode(node);
    }
    
    public void visit(XPathLocationStepNode node) {
        visitTreeNode(node);
    }
    
    public void visit(BooleanPlaceHolderNode node) {
        visitTreeNode(node);
    }
    
    public void visit(StartCounterValuePlaceHolderNode node) {
        visitTreeNode(node);
    }
    
    public void visit(FinalCounterValuePlaceHolderNode node) {
        visitTreeNode(node);
    }
    
    public void visit(BranchesPlaceHolderNode node) {
        visitTreeNode(node);
    }
    
    public void visit(DeadlinePlaceHolderNode node) {
        visitTreeNode(node);
    }
    
    public void visit(DurationPlaceHolderNode node) {
        visitTreeNode(node);
    }
    
    public void visit(PredicatePlaceHolderNode node) {
        visitTreeNode(node);
    }

    public void visit(RootPlaceHolderNode node) {
        visitTreeNode(node);
    }
    
    private void visitTreeNode(TreeNode node) {
        if (mVisitedNodes.contains(node)) {
            return;
        }
        mVisitedNodes.add(node);
        
        List inputs = node.getConnectedInputNodes();
        List outputs = node.getConnectedOutputNodes();
        if (inputs.size() == 0 && outputs.size() == 0) {
            NodeDisplayNameGeneratorVisitor nameVisitor = new NodeDisplayNameGeneratorVisitor();
            node.accept(nameVisitor);
            mBuf.append(nameVisitor.getDisplayName() + " "
                    + NbBundle.getMessage(ValidateVisitor.class,
                        "STR_TREE_NODE_IS_UNCONNECTED"));   // NOI18N
        }
        for (Iterator iter=inputs.iterator(); iter.hasNext();) {
            Node inputNode = (Node) iter.next();
            inputNode.accept(this);
        }
        for (Iterator iter=outputs.iterator(); iter.hasNext();) {
            Node outputNode = (Node) iter.next();
            outputNode.accept(this);
        }
    }
    
    private void visitCanvasNode(CanvasNode node) {
        if (mVisitedNodes.contains(node)) {
            return;
        }
        mVisitedNodes.add(node);
        
        if (node instanceof XPathLiteralNode) {
            // it is not possible for literal nodes to be disconnected
            // and yet still linked to other nodes, so do nothing here.
        } else {
            BasicMethoidNode methoidNode = (BasicMethoidNode) node.getMapperNode();
            BasicMethoid methoid = (BasicMethoid) methoidNode.getMethoidObject();
            int inputCount = methoid.getInputCount();
            int outputCount = methoid.getOutputCount();
            if (node.getInputs().size() < inputCount) {
                int dif = inputCount - node.getInputs().size();
                String name = methoid.getName().toUpperCase();
                mBuf.append(
                        NbBundle.getMessage(ValidateVisitor.class,
                            "STR_METHOID_REQUIRES_X_MORE_INPUTS",   // NOI18N
                            name, new Integer(dif)));
            }
            if (node.getOutputs().size() < outputCount) {
                int dif = outputCount - node.getOutputs().size();
                String name = methoid.getName().toUpperCase();
                mBuf.append(
                        NbBundle.getMessage(ValidateVisitor.class,
                            "STR_METHOID_REQUIRES_X_MORE_OUTPUTS",  // NOI18N
                            name, new Integer(dif)));
            }
            for (Iterator iter=node.getInputs().iterator(); iter.hasNext();) {
                Node inputNode = (Node) iter.next();
                inputNode.accept(this);
            }
            for (Iterator iter=node.getOutputs().iterator(); iter.hasNext();) {
                Node outputNode = (Node) iter.next();
                outputNode.accept(this);
            }
        }
    }
    
    public String getValidationErrors() {
        String errors = mBuf.toString();
        if (errors.length() > 0) {
            return errors;
        }
        return null;
    }
}
