/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.debugger.ui.watch;

import java.util.List;
import org.netbeans.spi.viewmodel.Model;
import org.openide.util.NbBundle;

import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;

/**
 * @author Vladimir Yaroslavskiy
 * @version 2005.10.28
 */
public class WatchView implements NodeModel, TableModel, Constants {
    private static final String VIEW_NAME = "WatchesView";
    
    public static final String WATCH =
        "org/netbeans/modules/debugger/resources/watchesView/Watch";
    
    ContextProvider myContextProvider;
    WatchHelperViewModel myHelperViewModel;
    
    /**{@inheritDoc}*/
    public WatchView(ContextProvider contextProvider) {
        myContextProvider = contextProvider;
    }
    
    // NodeModel ----------------------------------------------------
    
    /**{@inheritDoc}*/
    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == TreeModel.ROOT) {
            return NbBundle.getBundle(WatchView.class).
                getString ("CTL_Watch_Column_Name_Name");  // NOI18N
        } else if (object instanceof BpelWatchImpl) {
            return ((BpelWatchImpl)object).getExpression();
        } else {
            throw new UnknownTypeException(object);
        }
    }
    
    /**{@inheritDoc}*/
    public String getShortDescription(Object object) throws UnknownTypeException {
        return getDisplayName(object);
    }
    
    /**{@inheritDoc}*/
    public String getIconBase(Object object) throws UnknownTypeException {
        if (object == TreeModel.ROOT) {
            return WATCH;
        } else if (object instanceof BpelWatchImpl) {
            return WATCH;
        } else {
            throw new UnknownTypeException(object);
        }
    }
    
    // --------------------------------------------------------------
    
    /**{@inheritDoc}*/
    public void addModelListener(ModelListener listener) {}

    /**{@inheritDoc}*/
    public void removeModelListener(ModelListener listener) {}
    
    // TableModel ---------------------------------------------------
    
    /**{@inheritDoc}*/
    public Object getValueAt(Object object, String column)
        throws UnknownTypeException
    {
        if (object instanceof BpelWatchImpl) {
            BpelWatchImpl bpelWatch = (BpelWatchImpl)object;
            if (    column.equals(WATCH_VALUE_COLUMN_ID) ||
                    column.equals(WATCH_TO_STRING_COLUMN_ID))
            {
                //return variable.getValue();
                if (bpelWatch.getValue() != null) {
                    return getHelperViewModel().getValueAt(bpelWatch.getValue(), column);
                } else if (bpelWatch.getException() != null) {
                    return ">" + bpelWatch.getException().getMessage() + "<";
                } else {
                    return "";
                }
            } else if (column.equals(WATCH_TYPE_COLUMN_ID)) {
                return "";
            }
        }
        
        throw new UnknownTypeException(object);
    }
    
    /**{@inheritDoc}*/
    public void setValueAt(Object object, String column, Object value)
        throws UnknownTypeException
    {
        if (object instanceof BpelWatchImpl) {
            return;
        } else {
            throw new UnknownTypeException(object);
        }
    }
    
    /**{@inheritDoc}*/
    public boolean isReadOnly(Object object, String column)
        throws UnknownTypeException
    {
        if (object instanceof BpelWatchImpl) {
            return true;
        } else {
            throw new UnknownTypeException(object);
        }
    }
    
    private WatchHelperViewModel getHelperViewModel() {
        if (myHelperViewModel == null) {
            List models = myContextProvider.lookup(VIEW_NAME, Model.class);
            for (Object model : models) {
                if (model instanceof WatchHelperViewModel) {
                    myHelperViewModel = (WatchHelperViewModel)model;
                    break;
                }
            }
        }
        return myHelperViewModel;
    }

}
