/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.modules.bpel.debugger.test;

import junit.framework.TestCase;
import org.netbeans.modules.bpel.debugger.api.ProcessInstance;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.ProcessInstancesModelImpl;

import org.netbeans.modules.bpel.debugger.test.stub.StubProcessInstance;
import org.netbeans.modules.bpel.debugger.test.stub.StubProcessModelListener;


public class BDIProcessModel_Test extends TestCase {

    public void testAddRemoveProcessInstance() {
        ProcessInstancesModelImpl model = new ProcessInstancesModelImpl();
        model.addListener(new StubProcessModelListener());
        StubProcessInstance stubProcessInstance = new StubProcessInstance(model);
        model.frameCreated(stubProcessInstance);
        assertEquals(1, model.getProcessInstanceThreads().length);
        assertTrue(stubProcessInstance.getResult_isAdded());
        model.processInstanceCompleted(stubProcessInstance);
        assertEquals(0, model.getProcessInstanceThreads().length);
        assertFalse(stubProcessInstance.getResult_isAdded());
    }
    
    public void testStateChange() {
        ProcessInstancesModelImpl model = new ProcessInstancesModelImpl();
        model.addListener(new StubProcessModelListener());
        StubProcessInstance stubProcessInstance1 = new StubProcessInstance(model);
        StubProcessInstance stubProcessInstance2 = new StubProcessInstance(model);
        StubProcessInstance stubProcessInstance3 = new StubProcessInstance(model);
        StubProcessInstance stubProcessInstance4 = new StubProcessInstance(model);
        StubProcessInstance stubProcessInstance5 = new StubProcessInstance(model);
        model.frameCreated(stubProcessInstance1);
        model.frameCreated(stubProcessInstance2);
        model.frameCreated(stubProcessInstance3);
        model.frameCreated(stubProcessInstance4);
        model.frameCreated(stubProcessInstance5);
        assertEquals(ProcessInstance.STATE_UNKNOWN, stubProcessInstance1.getState());
        assertEquals(ProcessInstance.STATE_UNKNOWN, stubProcessInstance2.getState());
        assertEquals(ProcessInstance.STATE_UNKNOWN, stubProcessInstance3.getState());
        assertEquals(ProcessInstance.STATE_UNKNOWN, stubProcessInstance4.getState());
        assertEquals(ProcessInstance.STATE_UNKNOWN, stubProcessInstance5.getState());
        stubProcessInstance1.setState(ProcessInstance.STATE_COMPLETED);
        stubProcessInstance2.setState(ProcessInstance.STATE_FAILED);
        stubProcessInstance3.setState(ProcessInstance.STATE_RUNNING);
        stubProcessInstance4.setState(ProcessInstance.STATE_SUSPENDED);
        stubProcessInstance5.setState(ProcessInstance.STATE_TERMINATED);
        assertEquals(ProcessInstance.STATE_COMPLETED,  stubProcessInstance1.getResult_state());
        assertEquals(ProcessInstance.STATE_FAILED,     stubProcessInstance2.getResult_state());
        assertEquals(ProcessInstance.STATE_RUNNING,    stubProcessInstance3.getResult_state());
        assertEquals(ProcessInstance.STATE_SUSPENDED,  stubProcessInstance4.getResult_state());
        assertEquals(ProcessInstance.STATE_TERMINATED, stubProcessInstance5.getResult_state());
    }
    
    public void testClear() {
        ProcessInstancesModelImpl model = new ProcessInstancesModelImpl();
        model.addListener(new StubProcessModelListener());
        model.addListener(new StubProcessModelListener());
        model.addListener(new StubProcessModelListener());
        StubProcessInstance stubProcessInstance1 = new StubProcessInstance(model);
        StubProcessInstance stubProcessInstance2 = new StubProcessInstance(model);
        StubProcessInstance stubProcessInstance3 = new StubProcessInstance(model);
        model.frameCreated(stubProcessInstance1);
        model.frameCreated(stubProcessInstance2);
        model.frameCreated(stubProcessInstance3);
        assertEquals(3, model.getProcessInstanceThreads().length);
        model.clear();
        assertEquals(0, model.getProcessInstanceThreads().length);
        stubProcessInstance1.setState(ProcessInstance.STATE_COMPLETED);
        stubProcessInstance2.setState(ProcessInstance.STATE_FAILED);
        stubProcessInstance3.setState(ProcessInstance.STATE_RUNNING);
        assertEquals(ProcessInstance.STATE_UNKNOWN, stubProcessInstance1.getResult_state());
        assertEquals(ProcessInstance.STATE_UNKNOWN, stubProcessInstance2.getResult_state());
        assertEquals(ProcessInstance.STATE_UNKNOWN, stubProcessInstance3.getResult_state());
    }
}
