/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.bpel.model.validation.custom;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Collection;
import java.util.Collections;

import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Branches;
import org.netbeans.modules.bpel.model.api.Else;
import org.netbeans.modules.bpel.model.api.ElseIf;
import org.netbeans.modules.bpel.model.api.FaultHandlers;
import org.netbeans.modules.bpel.model.api.If;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.Reply;
import org.netbeans.modules.bpel.model.api.Sequence;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.validation.SimpleValidationVisitorImpl;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.RequestResponseOperation;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xam.spi.Validator.ResultItem;
import org.netbeans.modules.xml.xam.spi.Validator.ResultType;
import org.openide.util.NbBundle;

/**
 * @author ads
 */
class CustomValidationVisitor extends SimpleValidationVisitorImpl {

    static final String FIX_REPLY_OPERATION ="FIX_ReplyOperation"; // NOI18N

    // vlv # 93078
    @Override
    public void visit(Branches branches) {
      String content = branches.getContent();

      if (content == null) {
        return;
      }
      content = content.toLowerCase();

      if (
        content.contains("true") || content.contains("false")) {
        addError("FIX_Branches", branches); // NOI18N
      }
    }

    @Override
    public void visit(Reply reply)
    {
        super.visit(reply);
        WSDLReference<Operation> opRef = reply.getOperation();
        
        if ( opRef == null ) {
            return;
        }
        Operation operation = opRef.get();

        if ( operation == null ) {
            return;
        }
        if ( !(operation instanceof RequestResponseOperation) ) {
            addError( FIX_REPLY_OPERATION, reply, opRef.getQName().toString() );
        }
    }

    CustomValidationVisitor(Validator validator) {
        myValidator = validator;
        init();
    }
    
    private Validator getValidator() {
        return myValidator;
    }
    
    private void addError( String bundleKey , Collection<Component> collection, Object... values) {
        String str = 
            NbBundle.getMessage( CustomValidationVisitor.class ,
                    bundleKey );
        if ( values!= null && values.length >0 ) {
            str = MessageFormat.format(str, values );
        }
        for(Component component: collection) {
            ResultItem resultItem = new ResultItem( getValidator(),
                ResultType.ERROR, component, str );
            getResultItems().add( resultItem );
        }
        
    }
    
    private void addError( String bundleKey, BpelEntity entity , String... values) {
        addError(bundleKey, Collections.singleton((Component) entity), (Object[]) values);
    }

    private Validator myValidator;
}
