/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.bpel.model.spi;

import java.util.Iterator;

import org.netbeans.modules.bpel.model.api.Activity;
import org.netbeans.modules.bpel.model.api.BaseScope;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.VariableDeclarationScope;

/**
 * This is helper interface for finding various elements in OM.
 *
 * @author ads
 */
public interface FindHelper {

    /**
     * Returns XPath expression for OM element.
     * 
     * @param entity
     *            BpelEntity object.
     * @return xpath for <code>entity</code>.
     */
    String getXPath( BpelEntity entity );

    /**
     * Returns iterator that iterate over hierarchical scope parents of current
     * element.
     * 
     * @param entity
     *            BpelEntity object.
     * @return iterator for iterate through BaseScope .
     */
    Iterator<BaseScope> scopeIterator( BpelEntity entity );
    
    /**
     * Returns iterator that iterate over hierarchical VariableDeclarationScope
     * parents of current element.
     * 
     * @param entity BpelEntity object.
     * @return iterator for iterate through VariableDeclarationScope .
     */ 
    Iterator<VariableDeclarationScope> varaibleDeclarationScopes( 
            BpelEntity entity );

    /**
     * Returns nearest Activity that enclose this element.
     * 
     * @param entity
     *            BpelEntity object.
     * @return nearest parent activity.
     */
    Activity getParentActivity( BpelEntity entity );

    /**
     * Returns reference to element in model by <code>xpath</code> expression.
     * Runtime exception can be thrown if <code>xpath</code>
     * is bad XPath expression.
     * 
     * @param model
     *            model which will be used for search.
     * @param xpath XPath expression.
     * @return array of found model elements.
     */
    BpelEntity[] findModelElements( BpelModel model, String xpath );
            
}
