/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/**
 *
 */
package org.netbeans.modules.bpel.model.impl.services;

import java.util.HashMap;
import java.util.Map;

import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.Link;
import org.netbeans.modules.bpel.model.api.MessageExchange;
import org.netbeans.modules.bpel.model.api.NamedElement;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.model.impl.Utils;


/**
 * @author ads
 * This service checks for unique name definition in the same scope.
 */
public class UniqueNameCheck extends InnerEventDispatcherAdapter {

    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.xam.spi.InnerEventDispatcher#isApplicable(org.netbeans.modules.soa.model.bpel20.api.events.ChangeEvent)
     */
    public boolean isApplicable( ChangeEvent event ) {
        if (event instanceof PropertyUpdateEvent) {
            PropertyUpdateEvent ev = (PropertyUpdateEvent) event;
            if ( event.getParent().getBpelModel().inSync() ){
                return false;
            }
            String attributeName = ev.getName();
            if ( ((PropertyUpdateEvent)event).getNewValue() ==  null ){
                return false;
            }
            return attributeName.equals( NamedElement.NAME )
                && ( event.getParent() instanceof Variable || 
                        event.getParent() instanceof CorrelationSet ||
                        event.getParent() instanceof PartnerLink ||
                        event.getParent() instanceof MessageExchange ||
                        event.getParent() instanceof Link ) ;
        }
        return false;
    }

    /* (non-Javadoc)
     * @see org.netbeans.modules.soa.model.bpel20.xam.spi.InnerEventDispatcher#preDispatch(org.netbeans.modules.soa.model.bpel20.api.events.ChangeEvent)
     */
    public void preDispatch( ChangeEvent event ) throws VetoException {
        BpelContainer parent = event.getParent().getParent();
        if  ( parent != null ) { // parent can be null for element that is not in tree.
            
            for ( BpelEntity child : parent.getChildren( 
                    event.getParent().getElementType())) 
            {
                if ( !(child instanceof NamedElement) || 
                        child.equals( event.getParent()) )
                {
                    continue;
                }
                NamedElement kid = (NamedElement) child;    
                if ( ((PropertyUpdateEvent)event).getNewValue().equals( 
                        kid.getName() ))
                {
                    String str = Utils.getResourceString( 
                            getError( child.getElementType()) , kid.getName() );
                    throw new VetoException( str , event );
                }
            }
        }
    }
    
    private String getError( Class<? extends BpelEntity> clazz ){
        return LazyInit.ERROR_BUILDERS.get( clazz ).getError(); 
    }

    private static class LazyInit {
        private static final Map<Class<? extends BpelEntity>,
            ErrorMessageBuilder> ERROR_BUILDERS = new HashMap<
                Class<? extends BpelEntity>,ErrorMessageBuilder>();
        
        static {
            ERROR_BUILDERS.put( Variable.class , new VariableErrorBuilder() );
            ERROR_BUILDERS.put( CorrelationSet.class , 
                    new CorrelationSetErrorBuilder());
            ERROR_BUILDERS.put( PartnerLink.class , new PartnerLinkErrorBuilder());
            ERROR_BUILDERS.put( MessageExchange.class, 
                    new MessageExchangeErrorBuilder());
            ERROR_BUILDERS.put( Link.class, new LinkErrorBuilder());
        }
    }
}

interface ErrorMessageBuilder {
    String getError( );
}

class VariableErrorBuilder implements ErrorMessageBuilder {
    
    public String getError( ) {
        return Utils.BAD_VARIABLE_NAME;
    }
}

class CorrelationSetErrorBuilder implements ErrorMessageBuilder {
    
    public String getError( ) {
        return Utils.BAD_CORRELATION_SET_NAME;
    }
}

class PartnerLinkErrorBuilder implements ErrorMessageBuilder {
    
    public String getError( ) {
        return Utils.BAD_PARTNER_LINK_NAME;
    }
}

class MessageExchangeErrorBuilder implements ErrorMessageBuilder {
    
    public String getError( ) {
        return Utils.BAD_MESSAGE_EXCHANGE_NAME;
    }
}

class LinkErrorBuilder implements ErrorMessageBuilder {
    
    public String getError( ) {
        return Utils.BAD_LINK_NAME;
    }
}