/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2007 Sun Microsystems, Inc.
 */
package org.netbeans.modules.db.explorer.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import org.netbeans.lib.ddl.impl.CreateTable;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.infos.ColumnNodeInfo;

/**
 * This class refactors out logic from GrabTableAction so that we can unit
 * test it
 * 
 * @author <a href="mailto:david@vancouvering.com">David Van Couvering</a>
 */
public class GrabTableHelper {
    
    public void execute(
            Specification spec,
            String tablename,
            Enumeration nodeChildren,
            File file) throws Exception {
        CreateTable cmd = spec.createCommandCreateTable(tablename);

        while (nodeChildren.hasMoreElements()) {
            Object element = nodeChildren.nextElement();
            if (element instanceof ColumnNodeInfo) {
                cmd.getColumns().add(((ColumnNodeInfo)element).getColumnSpecification());
            }
        }
        
        FileOutputStream fstream = new FileOutputStream(file);
        ObjectOutputStream ostream = new ObjectOutputStream(fstream);
        cmd.setSpecification(null);
        ostream.writeObject(cmd);
        ostream.flush();
        ostream.close();
    }
}
