/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.cnd.repository.sfs;

import java.io.*;
import java.nio.*;

/**
 * DataOutput implementation that is based on ByteBuffer
 * @author Vladimir Kvashin
 */
public class BufferDataOutput implements DataOutput {
    
    private ByteBuffer buffer;
    
    public BufferDataOutput(ByteBuffer buffer) {
	this.buffer = buffer;
    }
    
    /** DataOutput implementation */
    public void write(int b) throws IOException {
	buffer.put((byte) b);
    }
    
    /** DataOutput implementation */
    public void writeByte(int v) throws IOException {
	write(v);
    }
    
    /** DataOutput implementation */
    public void writeChar(int v) throws IOException {
	buffer.putChar((char) v);
    }
    
    /** DataOutput implementation */
    public void writeInt(int v) throws IOException {
	buffer.putInt(v);
    }
    
    /** DataOutput implementation */
    public void writeShort(int v) throws IOException {
	buffer.putShort((short) v);
    }
    
    /** DataOutput implementation */
    public void writeUTF(String s) throws IOException {
	UTF.writeUTF(s, this);
    }
    
    /** DataOutput implementation */
    public void writeBytes(String s) throws IOException {
	int len = s.length();
	for (int i = 0 ; i < len ; i++) {
	    buffer.put((byte)s.charAt(i));
	}
    }
    
    /** DataOutput implementation */
    public void writeChars(String s) throws IOException {
	int len = s.length();
	for (int i = 0 ; i < len ; i++) {
	    buffer.putChar(s.charAt(i));
	}
    }
    
    /** DataOutput implementation */
    public void writeDouble(double v) throws IOException {
	buffer.putDouble(v);
    }
    
    /** DataOutput implementation */
    public void writeLong(long v) throws IOException {
	buffer.putLong(v);
    }
    
    /** DataOutput implementation */
    public void writeFloat(float v) throws IOException {
	buffer.putFloat(v);
    }
    
    /** DataOutput implementation */
    public void write(byte[] b, int off, int len) throws IOException {
	buffer.put(b, off, len);
    }
    
    /** DataOutput implementation */
    public void writeBoolean(boolean v) throws IOException {
	buffer.put((byte) (v ? 1 : 0));
    }
    
    /** DataOutput implementation */
    public void write(byte[] b) throws IOException {
	buffer.put(b);
    }
        
}
