<%--
/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/
 --%>
<%@ taglib prefix="sql" uri="http://java.sun.com/jsp/jstl/sql" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %> 
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib uri="/WEB-INF/waftags.tld" prefix="waf" %>
<%@page contentType="text/html"%>

<fmt:setLocale value="en_US" />

<sql:setDataSource dataSource="jdbc/CatalogDB"/>

<sql:query var="packageDetails"> 
 select name, description, imageuri from package where packageid =  ? and locale = ?
 <sql:param>${cart.packageId}</sql:param>
 <sql:param>en_US</sql:param>
</sql:query>


<table border="0" width="100%" cellspacing="0">
  <tr>
    <td colspan="3">
    <h2>${packageDetails.rows[0].name}</h2>
    </td><td/>
  </tr>
  <tr><td colspan="3"><br/></td>
  <tr>
   <td>
     <c:url var="imageURL" value="images/${packageDetails.rows[0].imageuri}"/>
     <image src="${imageURL}" height="50" width="50" alt="${packageDetails.rows[0].name}">
   </td>
  <td colspan="2"> ${packageDetails.rows[0].description} </td>
  </tr> 
  <tr>
   <td><b> Location :</b> </td>
   <td colspan="2">
    ${cart.destination}
   </td>
   <td align="right">
   <form action="enter_order_info.screen">
    <input type="Submit" value="Checkout"/>
   </form>
   </td>
  </tr>
  <tr><td colspan="3"><br/></td>
  <tr>
     <td><b> Number of People :</b> </td>
    <td colspan="2">
         ${cart.headCount}
     </td>
  </tr>
  <tr>
     <td><b> Number of Days :</b> </td>
    <td  colspan="2">
      ${cart.adventureDays}
     </td>
  </tr>
  <tr><td colspan="3"><br/></td> 
  <tr>   
   <td>
   <b>Lodging Total:</b>
   </td>
   <td  colspan="3" align="right">
       <fmt:formatNumber value="${cartBean.lodgingTotal}" type="currency" />
   </td>   
  </tr>
  <tr/><tr/>  
  <tr>   
   <td>
    <b>Activity Total:</b>
    </td>
   <td  colspan="3" align="right"> 
      <fmt:formatNumber value="${cartBean.activityTotal}" type="currency" />
   </td> 
  </tr>
  <tr/>  
  <tr>   
   <td>
    <b>Transportation Total:</b>
   </td>
   <td  colspan="3" align="right"> 
      <fmt:formatNumber value="${cartBean.transportationTotal}" type="currency" />
   </td> 
  </tr>
  <tr>   
   <td colspan="4" >
    <hr noshade="true">
   </td> 
  </tr>
  <tr>
   <td colspan="3">
    <b>Total Price : </b>
   </td>
   <td align="right">
    <b><fmt:formatNumber value="${cartBean.total}" type="currency" /></b>
   </td>
  </tr>
 </table>
