/*
 * Copyright 2006 Ricoh Corporation.
 * 
 * 
 * APACHE LICENSE VERSION 2.0
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * 
 * RICOH DEVELOPER PROGRAM SUPPORT:
 * 
 * Support for this software is available only to "Premier Plus" members
 * of the Ricoh Developer Program (RiDP).  You may find out more 
 * information about the Program at
 * 
 *      http://americas.ricoh-developer.com
 * 
 * Premier plus members may find answers and ask questions through the
 * RiDP customer help website at
 * 
 *      https://ridp.custhelp.com
 * 
 * Developers who are not RiDP members may still use this software as
 * stipulated in the license terms given above.
 *
 */

// import ESA (Embedded Software Architecture)
import jp.co.ricoh.dsdk.panel.*;
import jp.co.ricoh.dsdk.panel.event.*;
import jp.co.ricoh.dsdk.xlet.*;

/**
 * Demo application that shows how to receive hard key events,
 * including CLEAR/STOP.
 */
public class HardKey implements Xlet
{
    XletContext xletContext = null;

    Frame frameWindow = null;

    Label lastEventLabel = null;
    

    /**
     * Creates the GUI.
     */
    public void initXlet( XletContext context ) throws XletStateChangeException
    {
        System.out.println("initXlet");
        
        this.xletContext = context;
        
        // find the frame window
        frameWindow = getFrame();

        // create the "Move:" label
        lastEventLabel = new Label("No events received yet");
        
        lastEventLabel.setSize(500, 40);
        lastEventLabel.setLocation(35, 130);
        lastEventLabel.setFont(Font.ALNUM12);
        
        frameWindow.add(lastEventLabel);

        frameWindow.addKeyListener(
            new KeyAdapter() {
                public void keyPressed(KeyEvent event)
                {
                    lastEventLabel.setText("keyPressed(): " + keyCodeToString(event.getKeyCode()));
                    lastEventLabel.repaint();
                    return;
                }

                public void keyReleased(KeyEvent event)
                {
                    lastEventLabel.setText("keyReleased(): " + keyCodeToString(event.getKeyCode()));
                    lastEventLabel.repaint();

                    return;
                }

                public void keyTyped(KeyEvent event)
                {
                    lastEventLabel.setText("keyTyped(): " + keyCodeToString(event.getKeyCode()));
                    lastEventLabel.repaint();

                    return;
                }
            }
        );
        
        return;
    }

    /**
     * Shows the xlet.
     */

    public void startXlet( )
    {
        System.out.println("startXlet");

        frameWindow.setVisible(true);
        
        return;
    }

    /**
     * Hides the xlet.
     */

    public void pauseXlet( )
    {
        System.out.println("pauseXlet");

        frameWindow.setVisible(false);
        
        return;
    }

    /**
     * Hides the xlet.
     */

    public void destroyXlet( boolean unconditional )
    {
        System.out.println("destroyXlet");

        frameWindow.setVisible(false);
        
        return;
    }

    /**
     * Returns a reference to the main window.
     */

    private Frame getFrame( ) throws XletStateChangeException
    {
        // find the frame window
        Container parent = null;
        
        try
        {
            parent = xletContext.getContainer();
        }
        catch (UnavailableContainerException ex)
        {
            throw new XletStateChangeException(ex.toString());
        }
        
        while(!(parent instanceof Frame))
        {
            parent = parent.getParent();
            
            if (parent == null)
            {
                return null;
            }
        }
        
        return (Frame)parent;

    }
    
    /**
     * Returns a string that represents the keycode.
     */

    private static String keyCodeToString( int keyCode )
    {
        String strKeyCode = "Unknown";
        
        switch (keyCode)
        {
            case KeyEvent.KEY_0:
                strKeyCode = "KEY_0";
                break;
            case KeyEvent.KEY_1:
                strKeyCode = "KEY_1";
                break;
            case KeyEvent.KEY_2:
                strKeyCode = "KEY_2";
                break;
            case KeyEvent.KEY_3:
                strKeyCode = "KEY_3";
                break;
            case KeyEvent.KEY_4:
                strKeyCode = "KEY_4";
                break;
            case KeyEvent.KEY_5:
                strKeyCode = "KEY_5";
                break;
            case KeyEvent.KEY_6:
                strKeyCode = "KEY_6";
                break;
            case KeyEvent.KEY_7:
                strKeyCode = "KEY_7";
                break;
            case KeyEvent.KEY_8:
                strKeyCode = "KEY_8";
                break;
            case KeyEvent.KEY_9:
                strKeyCode = "KEY_9";
                break;
            case KeyEvent.KEY_ACOUNT_CLR:
                strKeyCode = "KEY_ACOUNT_CLR";
                break;
            case KeyEvent.KEY_CHECK:
                strKeyCode = "KEY_CHECK";
                break;
            case KeyEvent.KEY_CHKMODE:
                strKeyCode = "KEY_CHKMODE";
                break;
            case KeyEvent.KEY_CLEAR:
                strKeyCode = "KEY_CLEAR";
                break;
            case KeyEvent.KEY_CLR_STOP:
                strKeyCode = "KEY_CLR_STOP";
                break;
            case KeyEvent.KEY_COL_ADJUST:
                strKeyCode = "KEY_COL_ADJUST";
                break;
            case KeyEvent.KEY_COL_AUTO:
                strKeyCode = "KEY_COL_AUTO";
                break;
            case KeyEvent.KEY_COL_BW:
                strKeyCode = "KEY_COL_BW";
                break;
            case KeyEvent.KEY_COL_DOUBLE:
                strKeyCode = "KEY_COL_DOUBLE";
                break;
            case KeyEvent.KEY_COL_FULL:
                strKeyCode = "KEY_COL_FULL";
                break;
            case KeyEvent.KEY_COL_SINGLE:
                strKeyCode = "KEY_COL_SINGLE";
                break;
            case KeyEvent.KEY_COPY:
                strKeyCode = "KEY_COPY";
                break;
            case KeyEvent.KEY_COUNTER:
                strKeyCode = "KEY_COUNTER";
                break;
            case KeyEvent.KEY_CSS_MANUAL:
                strKeyCode = "KEY_CSS_MANUAL";
                break;
            case KeyEvent.KEY_FACTORY:
                strKeyCode = "KEY_FACTORY";
                break;
            case KeyEvent.KEY_FAX:
                strKeyCode = "KEY_FAX";
                break;
            case KeyEvent.KEY_FU:
                strKeyCode = "KEY_FU";
                break;
            case KeyEvent.KEY_INTERRUPT:
                strKeyCode = "KEY_INTERRUPT";
                break;
            case KeyEvent.KEY_JOBLIST:
                strKeyCode = "KEY_JOBLIST";
                break;
            case KeyEvent.KEY_LANGUAGE:
                strKeyCode = "KEY_LANGUAGE";
                break;
            case KeyEvent.KEY_MANRCV:
                strKeyCode = "KEY_MANRCV";
                break;
            case KeyEvent.KEY_ONHOOK:
                strKeyCode = "KEY_ONHOOK";
                break;
            case KeyEvent.KEY_P_DOWN:
                strKeyCode = "KEY_P_DOWN";
                break;
            case KeyEvent.KEY_P_ESC:
                strKeyCode = "KEY_P_ESC";
                break;
            case KeyEvent.KEY_P_EXEC:
                strKeyCode = "KEY_P_EXEC";
                break;
            case KeyEvent.KEY_P_EXIT_PAPER:
                strKeyCode = "KEY_P_EXIT_PAPER";
                break;
            case KeyEvent.KEY_P_MENU:
                strKeyCode = "KEY_P_MENU";
                break;
            case KeyEvent.KEY_P_ONLINE:
                strKeyCode = "KEY_P_ONLINE";
                break;
            case KeyEvent.KEY_P_RESET:
                strKeyCode = "KEY_P_RESET";
                break;
            case KeyEvent.KEY_P_UP:
                strKeyCode = "KEY_P_UP";
                break;
            case KeyEvent.KEY_PAUSE:
                strKeyCode = "KEY_PAUSE";
                break;
            case KeyEvent.KEY_PERIOD:
                strKeyCode = "KEY_PERIOD";
                break;
            case KeyEvent.KEY_PM_CLR:
                strKeyCode = "KEY_PM_CLR";
                break;
            case KeyEvent.KEY_POWER:
                strKeyCode = "KEY_POWER";
                break;
            case KeyEvent.KEY_PRINTER:
                strKeyCode = "KEY_PRINTER";
                break;
            case KeyEvent.KEY_PROGRAM:
                strKeyCode = "KEY_PROGRAM";
                break;
            case KeyEvent.KEY_QUICK_PMODE:
                strKeyCode = "KEY_QUICK_PMODE";
                break;
            case KeyEvent.KEY_REBOOT:
                strKeyCode = "KEY_REBOOT";
                break;
            case KeyEvent.KEY_RESET:
                strKeyCode = "KEY_RESET";
                break;
            case KeyEvent.KEY_SCANNER:
                strKeyCode = "KEY_SCANNER";
                break;
            case KeyEvent.KEY_SELF_CHECK:
                strKeyCode = "KEY_SELF_CHECK";
                break;
            case KeyEvent.KEY_SERVER:
                strKeyCode = "KEY_SERVER";
                break;
            case KeyEvent.KEY_SHARP:
                strKeyCode = "KEY_SHARP";
                break;
            case KeyEvent.KEY_SOFT_CANCEL:
                strKeyCode = "KEY_SOFT_CANCEL";
                break;
            case KeyEvent.KEY_SOFT_OK:
                strKeyCode = "KEY_SOFT_OK";
                break;
            case KeyEvent.KEY_SP_FACTORY:
                strKeyCode = "KEY_SP_FACTORY";
                break;
            case KeyEvent.KEY_SP_SALES:
                strKeyCode = "KEY_SP_SALES";
                break;
            case KeyEvent.KEY_SP_SERVICE:
                strKeyCode = "KEY_SP_SERVICE";
                break;
            case KeyEvent.KEY_SPEED:
                strKeyCode = "KEY_SPEED";
                break;
            case KeyEvent.KEY_START:
                strKeyCode = "KEY_START";
                break;
            case KeyEvent.KEY_STOP:
                strKeyCode = "KEY_STOP";
                break;
            case KeyEvent.KEY_SYS_RESET:
                strKeyCode = "KEY_SYS_RESET";
                break;
            case KeyEvent.KEY_TONE:
                strKeyCode = "KEY_TONE";
                break;
            case KeyEvent.KEY_USER_ACT:
                strKeyCode = "KEY_USER_ACT";
                break;
            case KeyEvent.KEY_USERTOOL:
                strKeyCode = "KEY_USERTOOL";
                break;
            case KeyEvent.KEY_WARMUP:
                strKeyCode = "KEY_WARMUP";
                break;
            case KeyEvent.KEY_WARMUP_DUMMY:
                strKeyCode = "KEY_WARMUP_DUMMY";
                break;
        };
        
        return strKeyCode;
    }

}
