/*
* Copyright 2005 Sun Microsystems, Inc. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* - Redistributions of source code must retain the above copyright
*   notice, this list of conditions and the following disclaimer.
*
* - Redistribution in binary form must reproduce the above copyright
*   notice, this list of conditions and the following disclaimer in
*   the documentation and/or other materials provided with the
*   distribution.
*
* Neither the name of Sun Microsystems, Inc. or the names of
* contributors may be used to endorse or promote products derived
* from this software without specific prior written permission.
*
* This software is provided "AS IS," without a warranty of any
* kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
* WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
* EXCLUDED. SUN AND ITS LICENSORS SHALL NOT BE LIABLE FOR ANY DAMAGES
* SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
* DISTRIBUTING THE SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR
* PUNITIVE DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF
* LIABILITY, ARISING OUT OF THE USE OF OR INABILITY TO USE SOFTWARE,
* EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
*
* You acknowledge that Software is not designed, licensed or intended
* for use in the design, construction, operation or maintenance of
* any nuclear facility.
*/

package com.sun.j2ee.blueprints.opc.workflowmanager;

import java.util.*;

import javax.jms.*;
import javax.ejb.*;
import javax.naming.*;
import javax.ejb.Timer;

import com.sun.j2ee.blueprints.opc.workflowmanager.handlers.*;
import com.sun.j2ee.blueprints.processmanager.ejb.*;
import com.sun.j2ee.blueprints.processmanager.manager.ejb.*;
import com.sun.j2ee.blueprints.servicelocator.*;
import com.sun.j2ee.blueprints.servicelocator.ejb.*;
import com.sun.j2ee.blueprints.opc.JNDINames;

/**
 * This is the work flow manager that controls 
 * work flow within the Order Processing Center
 */
public class WorkFlowManagerBean implements MessageDrivenBean, MessageListener, TimedObject {
     
    private  MessageDrivenContext context; 
    private  POHandler poHandler;
    private  InvoiceHandler invHandler; 
    private  ProcessManagerLocal pm;
  
    public void setMessageDrivenContext(MessageDrivenContext context) {
        this.context=context;
    }  
      
    public void ejbCreate() {
        try{
            poHandler = new POHandler();  
            invHandler = new InvoiceHandler();
            ServiceLocator sl = new ServiceLocator();
      ProcessManagerLocalHome pmlh = (ProcessManagerLocalHome) 
                                          sl.getLocalHome(JNDINames.PM_EJB);
            pm = pmlh.create();            
        } catch (HandlerException he){
            throw new EJBException(he.getMessage()); 
        } catch (ServiceLocatorException se) {
      throw new EJBException(se.getMessage());
  } catch (Exception exe) {
      throw new EJBException(exe.getMessage());
  }    
    }
      
    public void onMessage(Message message) {
        try{
            /*
             * For now, just call the handlers
             * This will change as the state machine is implemented
             */
            String docType = message.getStringProperty(JNDINames.DOC_TYPE);        
            if(docType.equals(JNDINames.PO_DOCUMENT)) {
                poHandler.handle(message);
            } else if(docType.equals(JNDINames.INVOICE_DOCUMENT)) {
                invHandler.handle(message);
                createStatusUpdateTimer();
            }
        } catch (HandlerException he){
            throw new EJBException(he); 
        } catch (JMSException exe) {
            throw new EJBException(exe);  
        }
    }
    
    private void createStatusUpdateTimer() {
        try{

            TimerService timerService = context.getTimerService();
             
            //check if a timer already exists
            if ((timerService.getTimers()).isEmpty()) {
                Context ic = new InitialContext();
      
                //create an interval timer to update the order status
          int expiration = (((Integer) ic.lookup(JNDINames.TIMER_EXPIRATION)).intValue()) * 60000;
          int interval = (((Integer) ic.lookup(JNDINames.TIMER_INTERVAL)).intValue()) * 60000;
                Timer timer = timerService.createTimer(expiration, interval, "OPC order update timer");   
            }
        } catch (Exception exe) {
            throw new EJBException(exe);
        }
    }

    public void ejbTimeout(Timer timer) {
        try{

            //check the status of all the orders that are submitted to suppliers
            Collection ordersList = pm.getOrdersByStatus(OrderStatusNames.SUBMITTED);
            Iterator iter = ordersList.iterator();  
            while (iter.hasNext()) {
                ManagerLocal mgr = (ManagerLocal) iter.next();
                String orderID = mgr.getOrderId(); 

                //change status to completed if all the three supplier orders are completed    
                pm.updateStatusToCompleted(orderID);

                //send the order completed mail
                if(pm.getOrderStatus(orderID).equals(OrderStatusNames.COMPLETED)){ 
                    invHandler.sendOrderCompletedMail(orderID);
                }
            }
        } catch (Exception exe) {
            throw new EJBException(exe);
        }
    }
    
    public void ejbRemove() {}
}

