/*
 * Decompiled with CFR 0.152.
 */
package com.sun.sql.framework.utils;

import com.sun.sql.framework.exception.BaseException;
import com.sun.sql.framework.utils.Logger;
import com.sun.sql.framework.utils.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XmlUtil {
    public static final String[] XML_ALLOWABLES = new String[]{"&amp;", "&quot;", "&apos;", "&lt;", "&gt;"};
    public static final String[] XML_ILLEGALS = new String[]{"&", "\"", "'", "<", ">"};
    public static final String[] HTML_ALLOWABLES = new String[]{"&amp;", "&quot;", "&lt;", "&gt;"};
    public static final String[] HTML_ILLEGALS = new String[]{"&", "\"", "<", ">"};
    private static final String LOG_CATEGORY = XmlUtil.class.getName();
    private static Map xslDocumentMap = new HashMap();
    private static String ETL_COLLAB_FOLDER = XmlUtil.getEtlCollabFolder();

    private static final synchronized String getEtlCollabFolder() {
        String nbUsrDir = System.getProperty("netbeans.user");
        if (nbUsrDir == null || "".equals(nbUsrDir)) {
            nbUsrDir = "../usrdir";
        }
        return nbUsrDir + "/eTL/collab/";
    }

    public static void dumpXMLString(String fileName, String xmlString) {
        if (!Logger.isDebugEnabled(LOG_CATEGORY)) {
            return;
        }
        try {
            File file = new File(ETL_COLLAB_FOLDER + fileName);
            file.getParentFile().mkdirs();
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            out.write(xmlString);
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String escapeXML(String string) {
        return StringUtil.replaceInString(string, XML_ILLEGALS, XML_ALLOWABLES);
    }

    public static String escapeHTML(String string) {
        return StringUtil.replaceInString(string, HTML_ILLEGALS, HTML_ALLOWABLES);
    }

    public static String getAttributeFrom(Element element, String attrName, boolean nullIfEmptyString) {
        if (element == null || attrName == null) {
            return nullIfEmptyString ? null : "";
        }
        String val = element.getAttribute(attrName);
        if ("".equals(val) && nullIfEmptyString) {
            val = null;
        }
        return val;
    }

    public static Element loadXMLFile(BufferedReader reader) {
        Element modelElement = null;
        if (reader == null) {
            Logger.print(40000, LOG_CATEGORY, "Invalid stream, nothing to load...");
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new InputSource(reader));
            modelElement = doc.getDocumentElement();
        }
        catch (Exception e) {
            Logger.printThrowable(40000, LOG_CATEGORY, null, "Could not load XML: " + reader, e);
        }
        return modelElement;
    }

    public static Element loadXMLString(String xmlString) {
        return XmlUtil.loadXMLFile(new BufferedReader(new StringReader(xmlString)));
    }

    public static Element loadXMLFile(Reader aReader) {
        return XmlUtil.loadXMLFile(new BufferedReader(aReader));
    }

    public static Element loadXMLFile(String fileName) {
        return XmlUtil.loadXMLFile(fileName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element loadXMLFile(String fileName, ClassLoader classLoader) {
        InputStream istream = null;
        Element element = null;
        if (classLoader == null) {
            classLoader = XmlUtil.class.getClassLoader();
        }
        if (StringUtil.isNullString(fileName)) {
            Logger.print(40000, LOG_CATEGORY, "Invalid file name, nothing to load...");
        }
        try {
            istream = classLoader.getResourceAsStream(fileName);
            if (istream == null) {
                File configFile = new File(fileName);
                if (configFile.exists()) {
                    fileName = configFile.getAbsolutePath();
                    istream = new FileInputStream(fileName);
                }
                if (istream == null) {
                    Logger.print(40000, LOG_CATEGORY, (Object)"configure", "configure ERROR: Can't find file in classpath: " + fileName);
                    Element element2 = null;
                    return element2;
                }
            }
            if ((element = XmlUtil.loadXMLFile(new BufferedReader(new InputStreamReader(istream)))) == null) {
                throw new BaseException(LOG_CATEGORY, fileName + " is empty");
            }
        }
        catch (Exception e) {
            Logger.printThrowable(40000, LOG_CATEGORY, null, "Could not load " + fileName, e);
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e) {}
            }
        }
        return element;
    }

    public static Element transform(URL xslFileUrl, Element sourceElem) throws BaseException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            if (tFactory.getFeature("http://javax.xml.transform.dom.DOMSource/feature") && tFactory.getFeature("http://javax.xml.transform.dom.DOMResult/feature")) {
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                dFactory.setNamespaceAware(true);
                DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
                Document xslDoc = (Document)xslDocumentMap.get(xslFileUrl);
                if (xslDoc == null) {
                    xslDoc = dBuilder.parse(xslFileUrl.toString());
                }
                DOMSource xslDomSource = new DOMSource(xslDoc);
                xslDomSource.setSystemId(xslFileUrl.toString());
                Transformer transformer = tFactory.newTransformer(xslDomSource);
                DOMSource xmlDomSource = new DOMSource(sourceElem);
                DOMResult domResult = new DOMResult();
                transformer.transform(xmlDomSource, domResult);
                Node node = domResult.getNode();
                if (node.getNodeType() == 9) {
                    return ((Document)node).getDocumentElement();
                }
            }
        }
        catch (Exception th) {
            throw new BaseException("can not transform source document", th);
        }
        return null;
    }

    public static String toXmlString(Element element) {
        StringBuffer buffer = new StringBuffer(200);
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        XmlUtil.write(element, buffer, 0);
        return buffer.toString();
    }

    private static void write(Element elem, StringBuffer buf, int indentLevel) {
        String elementName = elem.getNodeName();
        buf.append("<");
        buf.append(elementName);
        NamedNodeMap attrMap = elem.getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            XmlUtil.write((Attr)attrMap.item(i), buf);
        }
        if (elem.hasChildNodes()) {
            buf.append(">");
            NodeList childNodes = elem.getChildNodes();
            XmlUtil.write(childNodes, buf, indentLevel + 1);
            buf.append("</").append(elementName).append(">");
        } else {
            buf.append(" />");
        }
    }

    private static void write(NodeList nodes, StringBuffer buf, int indentLevel) {
        block5: for (int i = 0; i < nodes.getLength(); ++i) {
            Node aNode = nodes.item(i);
            if (aNode == null) continue;
            short nodeType = aNode.getNodeType();
            switch (nodeType) {
                case 4: {
                    CharacterData cdata = (CharacterData)aNode;
                    buf.append("<![CDATA[").append(cdata.getData()).append("]]>");
                    continue block5;
                }
                case 3: {
                    Text myText = (Text)aNode;
                    buf.append(XmlUtil.escapeXML(myText.getData()));
                    continue block5;
                }
                case 1: {
                    XmlUtil.write((Element)aNode, buf, indentLevel);
                }
            }
        }
    }

    private static void write(Attr attr, StringBuffer buf) {
        buf.append(" ").append(attr.getName()).append("=\"");
        String value = attr.getValue();
        buf.append(value != null ? XmlUtil.escapeXML(attr.getValue()) : "").append("\"");
    }
}

