/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mashup.engine;

import com.sun.mashup.engine.utils.XMLFile;
import com.sun.sql.framework.jdbc.DBConnectionParameters;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDMProcessDefinition {
    protected DBConnectionParameters connectionDef = null;
    private List<String> dbLinks = new LinkedList<String>();
    private List<String> dropTableQueries = new LinkedList<String>();
    private List<String> createTableQueries = new LinkedList<String>();
    private List<VTable> tableNodes = new LinkedList<VTable>();
    private String mashupQuery = "";
    private String mashupServiceName = "";
    private XMLFile xmlFile = null;
    private static final String DB_LINKS = "dbLinks";
    private static final String DB_LINK = "dbLink";
    private static final String DROP_TABLE = "dropsql";
    private static final String CREATE_TABLE = "createsql";
    private static final String MASHUP_SQL = "mashupsql";
    private static final String MASHUP = "DataMashup";
    private static final String CONN_DEF = "connectiondef";
    private static final String MASHUP_ENGINE = "MashupEngine";
    private static final String VTABLES = "VTables";
    private static final String VTABLE = "VTable";
    private static final String TYPE = "type";
    private static final String NL = "\n";
    private static final String INIT = "init";
    private static final String PROCESS = "process";

    public EDMProcessDefinition(File file) {
        this.xmlFile = new XMLFile(file);
        this.suckInQueries();
    }

    public EDMProcessDefinition() {
    }

    private void suckInQueries() {
        NodeList connDefs = this.xmlFile.getElementByTagName(CONN_DEF);
        Node connDef = connDefs.item(0);
        try {
            this.connectionDef = new DBConnectionParameters((Element)connDef);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NodeList dbLinkNodes = this.xmlFile.getElementByTagName(DB_LINK);
        System.out.println("no. of dbLinks = " + dbLinkNodes.getLength());
        for (int i = 0; i < dbLinkNodes.getLength(); ++i) {
            Node query = dbLinkNodes.item(i);
            this.dbLinks.add(query.getTextContent().trim());
        }
        NodeList tables = this.xmlFile.getElementByTagName(VTABLE);
        System.out.println("no. of tables " + tables.getLength());
        for (int i = 0; i < tables.getLength(); ++i) {
            Node tableNode = tables.item(i);
            VTable table = new VTable((Element)tableNode);
            this.tableNodes.add(table);
        }
        NodeList mashupNode = this.xmlFile.getElementByTagName(MASHUP_SQL);
        this.mashupQuery = mashupNode.item(0).getTextContent().trim();
    }

    public List<String> getDbLinks() {
        return this.dbLinks;
    }

    public void addDbLinkSql(String sql) {
        if (sql != null || !"".equals(sql)) {
            this.dbLinks.add(sql);
        }
    }

    public void addVTableNode(String tableName, String type, String dropsql, String createSql) {
        VTable tableNode = new VTable();
        tableNode.setName(tableName);
        tableNode.setType(type);
        tableNode.setCreateSql(createSql);
        tableNode.setDropSql(dropsql);
        this.tableNodes.add(tableNode);
    }

    public void syncQueries() {
        this.dropTableQueries.clear();
        ListIterator<VTable> iter = this.tableNodes.listIterator();
        while (iter.hasNext()) {
            VTable node = (VTable)iter.next();
            this.dropTableQueries.add(node.getDropSql());
            this.createTableQueries.add(node.getCreateSql());
        }
    }

    public List<String> getDropTableQueries() {
        return this.dropTableQueries;
    }

    public List<String> getCreateTableQueries() {
        return this.createTableQueries;
    }

    public String getDataMashupQuery() {
        return this.mashupQuery;
    }

    public void setDataMashupQuery(String mashupQuery) {
        this.mashupQuery = mashupQuery;
    }

    public DBConnectionParameters getDBConnectionParams() {
        return this.connectionDef;
    }

    public String generateEngineFile() {
        StringBuffer buffer = new StringBuffer(1000);
        buffer.append(this.getStartElement(MASHUP_ENGINE));
        buffer.append(this.connectionDef.toXMLString());
        buffer.append(this.getStartElement(INIT));
        this.dbLinksToXML(buffer, this.dbLinks);
        this.tablesToXML(buffer, this.tableNodes);
        buffer.append(this.getEndElement(INIT));
        this.processToXML(buffer);
        buffer.append(this.getEndElement(MASHUP_ENGINE));
        return buffer.toString();
    }

    private void processToXML(StringBuffer buffer) {
        buffer.append(this.getStartElement(PROCESS));
        buffer.append(this.getStartElement(MASHUP));
        buffer.append(this.getStartElement(MASHUP_SQL));
        buffer.append(this.mashupQuery);
        buffer.append(this.getEndElement(MASHUP_SQL));
        buffer.append(this.getEndElement(MASHUP));
        buffer.append(this.getEndElement(PROCESS));
    }

    private void dbLinksToXML(StringBuffer buffer, List<String> dbLinks) {
        buffer.append(this.getStartElement(DB_LINKS));
        ListIterator<String> linkIter = dbLinks.listIterator();
        while (linkIter.hasNext()) {
            buffer.append(this.getStartElement(DB_LINK));
            buffer.append((String)linkIter.next());
            buffer.append(this.getEndElement(DB_LINK));
        }
        buffer.append(this.getEndElement(DB_LINKS));
    }

    private void tablesToXML(StringBuffer buffer, List<VTable> tables) {
        int noOfTables = tables.size();
        buffer.append(this.getStartElement(VTABLES));
        for (int i = 0; i < noOfTables; ++i) {
            VTable table = tables.get(i);
            buffer.append(table.toXML());
        }
        buffer.append(this.getEndElement(VTABLES));
    }

    private String getStartElement(String elementName) {
        return "<" + elementName + ">" + NL;
    }

    private String getEndElement(String elementName) {
        return "</" + elementName + ">" + NL;
    }

    public String dumpQueries() {
        int i;
        StringBuffer output = new StringBuffer(1000);
        output.append(this.connectionDef.toString());
        for (i = 0; i < this.dbLinks.size(); ++i) {
            output.append(this.dbLinks.get(i));
        }
        for (i = 0; i < this.tableNodes.size(); ++i) {
            VTable table = this.tableNodes.get(i);
            output.append(table.getDropSql());
            output.append(table.getCreateSql());
        }
        output.append(this.mashupQuery);
        return output.toString();
    }

    public static void main(String[] args) {
        File f = new File(args[0]);
        EDMProcessDefinition processDef = new EDMProcessDefinition(f);
        System.out.println(processDef.dumpQueries());
    }

    private class VTable {
        String name;
        String type;
        String createSql;
        String dropSql;

        public VTable() {
        }

        public VTable(Element tableNode) {
            this.parseXML(tableNode);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getCreateSql() {
            return this.createSql;
        }

        public void setCreateSql(String createSql) {
            this.createSql = createSql;
        }

        public String getDropSql() {
            return this.dropSql;
        }

        public void setDropSql(String dropSql) {
            this.dropSql = dropSql;
        }

        public String toXML() {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append(EDMProcessDefinition.this.getStartElement(EDMProcessDefinition.VTABLE));
            buffer.append(EDMProcessDefinition.this.getStartElement(EDMProcessDefinition.CREATE_TABLE)).append(this.createSql).append(EDMProcessDefinition.this.getEndElement(EDMProcessDefinition.CREATE_TABLE));
            buffer.append(EDMProcessDefinition.this.getStartElement(EDMProcessDefinition.DROP_TABLE)).append(this.dropSql).append(EDMProcessDefinition.this.getEndElement(EDMProcessDefinition.DROP_TABLE));
            buffer.append(EDMProcessDefinition.this.getEndElement(EDMProcessDefinition.VTABLE));
            return buffer.toString();
        }

        public void parseXML(Element xmlElement) {
            this.setType(xmlElement.getAttribute(EDMProcessDefinition.TYPE));
            NodeList createSql = xmlElement.getElementsByTagName(EDMProcessDefinition.CREATE_TABLE);
            this.setCreateSql(createSql.item(0).getTextContent());
            NodeList dropSql = xmlElement.getElementsByTagName(EDMProcessDefinition.DROP_TABLE);
            this.setDropSql(dropSql.item(0).getTextContent());
        }
    }
}

