/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4corba.jbi.processor.transform;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.stream.StreamSource;

public class StringSource
extends StreamSource
implements Serializable {
    private static final long serialVersionUID = -2965901682811246960L;
    private final String text;
    private String encoding = "UTF-8";

    public StringSource(String text) {
        if (text == null) {
            throw new NullPointerException("text can not be null");
        }
        this.text = text;
    }

    public StringSource(String text, String systemId) {
        this(text);
        this.setSystemId(systemId);
    }

    public StringSource(String text, String systemId, String encoding) {
        this.text = text;
        this.encoding = encoding;
        this.setSystemId(systemId);
    }

    public InputStream getInputStream() {
        try {
            return new ByteArrayInputStream(this.text.getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Reader getReader() {
        return new StringReader(this.text);
    }

    public String toString() {
        return "StringSource[" + this.text + "]";
    }

    public String getText() {
        return this.text;
    }
}

