/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoIdentifiablePart;
import com.nwoods.jgo.JGoLabeledPart;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoText;
import java.util.ArrayList;

public class JGoNode
extends JGoArea
implements JGoLabeledPart,
JGoIdentifiablePart {
    public static final int ChangedPartID = 2001;
    public static final int ChangedUserObject = 2002;
    public static final int ChangedToolTipText = 2003;
    public static final int PartsPorts = 1;
    public static final int PartsLinksIn = 2;
    public static final int PartsLinksOut = 4;
    public static final int PartsNodesIn = 8;
    public static final int PartsNodesOut = 16;
    public static final int PartsNotSelf = 32;
    public static final int PartsNodes = 24;
    public static final int PartsLinks = 6;
    private int myPartID = -1;
    private Object myUserObject = null;
    private String myToolTipText = null;

    public JGoNode() {
        this.setInternalFlags(this.getInternalFlags() & 0xFFFFFBFF);
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        JGoNode newobj = (JGoNode)super.copyObject(env);
        if (newobj != null) {
            newobj.myPartID = this.myPartID;
            newobj.myUserObject = this.myUserObject;
            newobj.myToolTipText = this.myToolTipText;
        }
        return newobj;
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoNode = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoNode", jGoElementGroup);
            jGoNode.setAttribute("partid", Integer.toString(this.myPartID));
            if (this.myToolTipText != null) {
                jGoNode.setAttribute("tooltiptext", this.myToolTipText);
            }
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            String tooltiptext;
            if (svgDoc.getJGoSVGVersion() < 2.0 && !jGoChildElement.getLocalName().equals("JGoNode")) {
                return super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement);
            }
            String partid = jGoChildElement.getAttribute("partid");
            if (partid.length() > 0) {
                this.myPartID = Integer.parseInt(partid);
            }
            this.myToolTipText = tooltiptext = jGoChildElement.getAttribute("tooltiptext");
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
            return svgElement.getNextSibling();
        }
        return svgElement.getNextSibling();
    }

    public void SVGUpdateReference(String attr, Object referencedObject) {
        super.SVGUpdateReference(attr, referencedObject);
    }

    public String getText() {
        JGoText lab = this.getLabel();
        if (lab != null) {
            return lab.getText();
        }
        return "";
    }

    public void setText(String s) {
        JGoText lab = this.getLabel();
        if (lab != null) {
            lab.setText(s);
        }
    }

    public JGoText getLabel() {
        return JGoNode.findLabel(this);
    }

    public void setLabel(JGoText l) {
    }

    static JGoText findLabel(JGoObject obj) {
        if (obj instanceof JGoText) {
            return (JGoText)obj;
        }
        if (obj instanceof JGoArea) {
            JGoArea g = (JGoArea)obj;
            JGoListPosition pos = g.getFirstObjectPos();
            while (pos != null) {
                JGoObject o = g.getObjectAtPos(pos);
                pos = g.getNextObjectPos(pos);
                JGoText ct = JGoNode.findLabel(o);
                if (ct == null) continue;
                return ct;
            }
        }
        return null;
    }

    public int getPartID() {
        return this.myPartID;
    }

    public void setPartID(int id) {
        int old = this.myPartID;
        if (old != id) {
            this.myPartID = id;
            this.update(2001, old, null);
        }
    }

    public Object getUserObject() {
        return this.myUserObject;
    }

    public void setUserObject(Object obj) {
        Object old = this.myUserObject;
        if (old != obj) {
            this.myUserObject = obj;
            this.update(2002, 0, old);
        }
    }

    public String getToolTipText() {
        return this.myToolTipText;
    }

    public void setToolTipText(String s) {
        String old = this.myToolTipText;
        if (old != s || old != null && !old.equals(s)) {
            this.myToolTipText = s;
            this.update(2003, 0, old);
        }
    }

    static void copyProperties(JGoObject oldobj, JGoObject newobj) {
        if (oldobj != null && newobj != null) {
            newobj.setSpotLocation(0, oldobj.getSpotLocation(0));
            newobj.setSelectable(oldobj.isSelectable());
            newobj.setResizable(oldobj.isResizable());
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 2001: {
                e.setNewValueInt(this.getPartID());
                return;
            }
            case 2002: {
                e.setNewValue(this.getUserObject());
                return;
            }
            case 2003: {
                e.setNewValue(this.getToolTipText());
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 2001: {
                this.setPartID(e.getValueInt(undo));
                return;
            }
            case 2002: {
                this.setUserObject(e.getValue(undo));
                return;
            }
            case 2003: {
                this.setToolTipText((String)e.getValue(undo));
                return;
            }
        }
        super.changeValue(e, undo);
    }

    public ArrayList findAll(int search, ArrayList items) {
        if (items == null) {
            items = new ArrayList();
        } else {
            items.clear();
        }
        this.findAllAux(this, search, items);
        return items;
    }

    private void findAllAux(JGoObject obj, int search, ArrayList items) {
        JGoListPosition pos;
        if (obj != null && obj instanceof JGoPort) {
            if ((search & 1) != 0) {
                this.addItem(items, obj);
            }
            JGoPort port = (JGoPort)obj;
            pos = port.getFirstLinkPos();
            while (pos != null) {
                JGoLink link = port.getLinkAtPos(pos);
                pos = port.getNextLinkPos(pos);
                this.considerLink(link, port, search, items);
            }
        }
        if (obj != null && obj instanceof JGoArea) {
            JGoArea area = (JGoArea)obj;
            pos = area.getFirstObjectPos();
            while (pos != null) {
                JGoObject child = area.getObjectAtPos(pos);
                pos = area.getNextObjectPos(pos);
                this.findAllAux(child, search, items);
            }
        }
    }

    private void addItem(ArrayList items, JGoObject obj) {
        if (obj != null && !items.contains(obj)) {
            items.add(obj);
        }
    }

    private void considerLink(JGoLink link, JGoPort port, int search, ArrayList items) {
        boolean selfOK;
        boolean bl = selfOK = (search & 0x20) == 0;
        if (link.getFromPort() == port && (selfOK || link.getToPort() == null || !link.getToPort().getPortObject().isChildOf(this))) {
            if ((search & 4) != 0) {
                this.addItem(items, link);
            }
            if ((search & 0x10) != 0) {
                this.addItem(items, link.getToPort().getParentJGoNode());
            }
        }
        if (link.getToPort() == port && (selfOK || link.getFromPort() == null || !link.getFromPort().getPortObject().isChildOf(this))) {
            if ((search & 2) != 0) {
                this.addItem(items, link);
            }
            if ((search & 8) != 0) {
                this.addItem(items, link.getFromPort().getParentJGoNode());
            }
        }
    }
}

