/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.tools.xml;

import java.net.URL;
import org.xml.sax.Attributes;

public final class SchemaLocationAttributes
implements Attributes {
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String TAG_LOCATION = "schemaLocation";
    private static final String TAG_NONS_LOCATION = "noNamespaceSchemaLocation";
    private final URL mSchemaLocation;
    private final String mTargetNamespace;
    private final String mValue;
    private final int mLength;

    public SchemaLocationAttributes(String targetNamespace, URL schemaLocation) {
        this.mSchemaLocation = schemaLocation;
        this.mTargetNamespace = targetNamespace;
        if (this.mSchemaLocation == null || !"file".equals(this.mSchemaLocation.getProtocol())) {
            this.mValue = null;
            this.mLength = 0;
        } else {
            this.mValue = this.mTargetNamespace == null || this.mTargetNamespace.length() == 0 ? this.NormalizePath(this.mSchemaLocation.getPath()) : this.mTargetNamespace + " " + this.NormalizePath(this.mSchemaLocation.getPath());
            this.mLength = 1;
        }
    }

    public int getLength() {
        return this.mLength;
    }

    public String getURI(int index) {
        if (this.mLength == 0) {
            return null;
        }
        if (index == 0) {
            return XSI_NS;
        }
        return null;
    }

    public String getLocalName(int index) {
        if (this.mLength == 0) {
            return null;
        }
        if (index == 0) {
            if (this.mTargetNamespace == null || this.mTargetNamespace.length() == 0) {
                return TAG_NONS_LOCATION;
            }
            return TAG_LOCATION;
        }
        return null;
    }

    public String getQName(int index) {
        if (this.mLength == 0) {
            return null;
        }
        if (index == 0) {
            if (this.mTargetNamespace == null || this.mTargetNamespace.length() == 0) {
                return "xsi:noNamespaceSchemaLocation";
            }
            return "xsi:schemaLocation";
        }
        return null;
    }

    public String getType(int index) {
        if (this.mLength == 0) {
            return null;
        }
        if (index == 0) {
            return "CDATA";
        }
        return null;
    }

    public String getValue(int index) {
        if (this.mLength == 0) {
            return null;
        }
        if (index == 0) {
            return this.mValue;
        }
        return null;
    }

    public int getIndex(String uri, String localName) {
        if (XSI_NS.equals(uri) && (TAG_LOCATION.equals(localName) || TAG_NONS_LOCATION.equals(localName))) {
            return 0;
        }
        return -1;
    }

    public int getIndex(String qName) {
        if ("xsi:schemaLocation".equals(qName) || "xsi:noNamespaceSchemaLocation".equals(qName)) {
            return 0;
        }
        return -1;
    }

    public String getType(String uri, String localName) {
        if (XSI_NS.equals(uri) && (TAG_LOCATION.equals(localName) || TAG_NONS_LOCATION.equals(localName))) {
            return "CDATA";
        }
        return null;
    }

    public String getType(String qName) {
        if ("xsi:schemaLocation".equals(qName) || "xsi:noNamespaceSchemaLocation".equals(qName)) {
            return "CDATA";
        }
        return null;
    }

    public String getValue(String uri, String localName) {
        if (XSI_NS.equals(uri) && (TAG_LOCATION.equals(localName) || TAG_NONS_LOCATION.equals(localName))) {
            return this.mValue;
        }
        return null;
    }

    public String getValue(String qName) {
        if ("xsi:schemaLocation".equals(qName) || "xsi:noNamespaceSchemaLocation".equals(qName)) {
            return this.mValue;
        }
        return null;
    }

    private String NormalizePath(String path) {
        if (path == null || path.length() < 3) {
            return path;
        }
        if ((path.charAt(0) == '/' || path.charAt(0) == '\\') && path.charAt(2) == ':') {
            path = path.substring(1);
        }
        path = path.replaceAll(" ", "%20");
        return path;
    }
}

