/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.runtime.provider;

import com.sun.encoder.runtime.OtdInputStream;
import com.sun.encoder.runtime.OtdInputStreamMark;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class StringOtdInputStreamImpl
implements OtdInputStream {
    private byte[] mData;
    private int mPos = 0;

    public StringOtdInputStreamImpl(byte[] data) {
        if (data == null) {
            throw new NullPointerException("no data");
        }
        this.mData = data;
    }

    public StringOtdInputStreamImpl(String data) {
        try {
            this.mData = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ue) {
            throw new RuntimeException("platform sucks: " + ue.getMessage());
        }
    }

    protected byte[] getData() {
        return this.mData;
    }

    public void begin() {
    }

    public boolean end() {
        return this.mPos < this.mData.length;
    }

    public boolean eof() throws IOException {
        return this.mPos >= this.mData.length;
    }

    public int read(byte[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int len) {
        if (buffer == null) {
            throw new NullPointerException("no buffer");
        }
        if (this.mPos >= this.mData.length) {
            return -1;
        }
        int count = 0;
        while (offset < buffer.length && len-- > 0 && this.mPos < this.mData.length) {
            buffer[offset++] = this.mData[this.mPos++];
            ++count;
        }
        return count;
    }

    public int read() {
        return this.mPos < this.mData.length ? this.mData[this.mPos++] & 0xFF : -1;
    }

    public OtdInputStreamMark mark() {
        return new Mark(this.mPos);
    }

    public void seek(OtdInputStreamMark mark) throws IOException {
        if (mark == null) {
            throw new NullPointerException("no mark");
        }
        int pos = ((Mark)mark).mPos;
        if (pos < 0 || this.mData.length < pos) {
            throw new IOException("impossible offset " + pos);
        }
        this.mPos = pos;
    }

    public void rewind() {
        this.mPos = 0;
    }

    public void writeMarkOffset(byte[] buffer, int offset, int len) throws IOException {
    }

    public void skip(long count) throws IOException {
        if (count < 0L) {
            throw new IllegalArgumentException("negative count");
        }
        if ((long)this.mPos + count > (long)this.mData.length) {
            throw new IOException("tried to skip " + count + ", only " + (this.mData.length - this.mPos) + " available");
        }
        this.mPos = (int)((long)this.mPos + count);
    }

    private static class Mark
    implements OtdInputStreamMark {
        public final int mPos;

        public Mark(int pos) {
            this.mPos = pos;
        }

        public long offset() {
            return this.mPos;
        }
    }
}

