/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.runtime.provider;

import com.sun.encoder.runtime.CoderException;
import com.sun.encoder.runtime.provider.Misc;
import com.sun.encoder.runtime.provider.SharedCoder;
import com.sun.encoder.util.UnicodeFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.ArrayList;

public class StatefulCoder
extends SharedCoder {
    private static final int BYTES = 256;
    public static final int NOCHAR = 65535;
    public static final byte MAXLEN = 8;
    private int mMaxCode = 0;
    public CodeInfo mDecode = null;
    public CodeInfo mEncode = null;
    public byte mPad = (byte)32;

    public void dump(PrintStream out) {
        out.println("Stateful Coder");
        if (this.mDecode != null) {
            this.mDecode.dump(out, "Decodes");
        }
        if (this.mEncode != null) {
            this.mEncode.dump(out, "Encodes");
        }
    }

    public StatefulCoder(File input) throws IOException {
        FileInputStream is = new FileInputStream(input);
        this.init(input.getPath(), is);
        ((InputStream)is).close();
    }

    public StatefulCoder(String resource) throws IOException {
        ClassLoader loader = StatefulCoder.class.getClassLoader();
        InputStream is = loader.getResourceAsStream(resource);
        if (is == null) {
            throw new IOException("can't find code table resource '" + resource + "'");
        }
        this.init(resource, is);
        is.close();
    }

    private byte[] getBytes(ResourceReader reader) {
        int b;
        byte[] buf = new byte[8];
        int pos = 0;
        while (pos < 8 && (b = reader.getCode()) >= 0) {
            buf[pos++] = (byte)b;
        }
        byte[] bytes = new byte[pos];
        while (pos-- > 0) {
            bytes[pos] = buf[pos];
        }
        return bytes;
    }

    private String getChars(ResourceReader reader) {
        int c;
        char[] buf = new char[8];
        int pos = 0;
        pos = 0;
        while (pos < 8 && (c = reader.getCode()) >= 0) {
            buf[pos++] = (char)c;
        }
        return new String(buf, 0, pos);
    }

    public void init(String path, InputStream is) throws IOException {
        if (is == null) {
            throw new NullPointerException("no input stream");
        }
        boolean decode = true;
        ResourceReader reader = new ResourceReader(is);
        String[] states = null;
        byte[] label = null;
        String codes = null;
        while (reader.next()) {
            System.out.println("[ rule <" + reader.mText + "> ]");
            if (reader.empty()) continue;
            if (reader.get("@pad")) {
                this.mPad = (byte)reader.getCode();
                continue;
            }
            if (reader.get("@decode")) {
                String name;
                if (this.mDecode != null) {
                    reader.fail("duplicate @decode line");
                }
                ArrayList<String> names = new ArrayList<String>();
                while ((name = reader.getName()) != null) {
                    names.add(name);
                }
                states = new String[names.size()];
                names.toArray(states);
                this.mDecode = new CodeInfo(states);
                continue;
            }
            if (reader.get("@encode")) {
                String name;
                if (this.mEncode != null) {
                    reader.fail("duplicate @encode line");
                }
                ArrayList<String> names = new ArrayList<String>();
                while ((name = reader.getName()) != null) {
                    names.add(name);
                }
                states = new String[names.size()];
                names.toArray(states);
                this.mEncode = new CodeInfo(states);
                decode = false;
                continue;
            }
            if ((decode ? this.mDecode : this.mEncode) == null) {
                reader.fail("missing @decode/@encode line");
            }
            byte from = reader.getState(states);
            if (decode) {
                label = this.getBytes(reader);
            } else {
                codes = this.getChars(reader);
            }
            boolean end = reader.getEnd();
            reader.skipSpace();
            if (!reader.get(":")) {
                reader.fail("expected ':', not '" + reader.mText + "'");
            }
            if (decode) {
                codes = this.getChars(reader);
            } else {
                label = this.getBytes(reader);
            }
            byte into = reader.getState(states);
            reader.done();
            if (decode) {
                this.mDecode.addEffect(from, label, end, codes, into, null);
                continue;
            }
            this.mEncode.addEffect(from, label, end, codes, into, null);
        }
    }

    public byte[] encode(String in, int min, int max) throws CoderException {
        if (this.mEncode == null) {
            throw new CoderException("no encoding rules");
        }
        if (in == null) {
            return null;
        }
        if (0 <= min && 0 <= max && max < min) {
            throw new IllegalArgumentException("max (" + max + ") < min (" + min + ")");
        }
        return this.mEncode.encode(in, min, max, this.mPad);
    }

    public String decode(byte[] in, int from, int length) throws CoderException {
        if (this.mDecode == null) {
            throw new CoderException("no decoding rules");
        }
        if (in == null) {
            return null;
        }
        if (from < 0 || in.length < from || length < 0 || in.length < from + length) {
            throw new CoderException("invalid size/from/length: " + in.length + "/" + from + "/" + length);
        }
        return this.mDecode.decode(in, from, from + length);
    }

    public static void main(String[] args) {
        try {
            StatefulCoder sfc = new StatefulCoder(new File("sfc.code"));
            sfc.dump(System.out);
            String s = sfc.decode(new byte[]{3, 4});
            System.out.println("[ decoded <" + s + "> ]");
            byte[] b = sfc.encode("abc", 6, -1);
            System.out.println("[ encoded <" + Misc.printable(b) + "> ]");
        }
        catch (Exception all) {
            all.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static class ResourceReader {
        public String mText = null;
        private final LineNumberReader mReader;
        private static final String END = "$";

        public ResourceReader(InputStream is) throws IOException {
            this.mReader = new LineNumberReader(UnicodeFile.makeInputReader(is));
        }

        public boolean next() throws IOException {
            this.mText = this.mReader.readLine();
            if (this.mText == null) {
                this.mReader.close();
                return false;
            }
            this.skipSpace();
            return true;
        }

        public void fail(String message) throws IOException {
            throw new IOException("line " + this.mReader.getLineNumber() + ": " + message);
        }

        private void skipSpace() {
            char c;
            int len = this.mText.length();
            for (int pos = 0; pos < len && (c = this.mText.charAt(pos)) != '#'; ++pos) {
                if (c == ' ' || c == '\t') continue;
                if (pos > 0) {
                    this.mText = this.mText.substring(pos);
                }
                return;
            }
            this.mText = "";
        }

        public boolean empty() {
            this.skipSpace();
            return this.mText.length() == 0;
        }

        public void done() throws IOException {
            if (!this.empty()) {
                this.fail("trailing junk: '" + this.mText + "'");
            }
        }

        public boolean get(String key) {
            this.skipSpace();
            if (!this.mText.startsWith(key)) {
                return false;
            }
            this.mText = this.mText.substring(key.length());
            return true;
        }

        public byte getState(String[] names) throws IOException {
            this.skipSpace();
            if (!this.mText.startsWith("<")) {
                return -1;
            }
            int pos = this.mText.indexOf(62);
            if (pos < 0) {
                this.fail("'<' not followed by '>'");
            }
            String name = this.mText.substring(1, pos);
            for (int i = 0; i < names.length; ++i) {
                if (!names[i].equals(name)) continue;
                this.mText = this.mText.substring(pos + 1);
                return (byte)i;
            }
            this.fail("unknown state <" + name + ">");
            return -1;
        }

        public int getCode() {
            int nibble;
            int pos;
            this.skipSpace();
            int result = 0;
            for (pos = 0; pos < this.mText.length() && (nibble = "0123456789ABCDEF".indexOf(this.mText.charAt(pos))) >= 0; ++pos) {
                result = (result << 4) + nibble;
            }
            if (pos > 0) {
                this.mText = this.mText.substring(pos);
                return result;
            }
            return -1;
        }

        public String getName() {
            char c;
            int pos;
            this.skipSpace();
            int len = this.mText.length();
            for (pos = 0; pos < len && (c = this.mText.charAt(pos)) >= 'a' && 'z' >= c; ++pos) {
            }
            if (pos == 0) {
                return null;
            }
            String name = this.mText.substring(0, pos);
            this.mText = this.mText.substring(pos);
            return name;
        }

        public boolean getEnd() {
            this.skipSpace();
            if (this.mText.startsWith(END)) {
                this.mText = this.mText.substring(END.length());
                return true;
            }
            return false;
        }
    }

    private static class CodeInfo {
        private final String[] mNames;
        private final CodeState[] mStates;

        public String decode(byte[] data, int from, int to) throws CoderException {
            CodeState.CodeEffect effect;
            int state = 0;
            int pos = from;
            StringBuffer sb = new StringBuffer(to - from);
            System.out.println("[ decode " + SharedCoder.hex(data) + ", from " + from + " to " + to + " ]");
            do {
                System.out.println("[ - state=" + state + ", pos=" + pos + " ]");
                effect = this.mStates[state].match(data, pos, to);
                if (effect == null) {
                    throw new CoderException(pos - from, "cannot decode");
                }
                System.out.println("[ - got " + SharedCoder.hex(effect.mLabel) + (effect.mLast ? "<END>" : "") + (effect.mState < 0 ? "" : ", state=" + effect.mState) + " ]");
                if (effect.mCodes != null) {
                    sb.append(effect.mCodes);
                }
                if (effect.mState >= 0) {
                    state = effect.mState;
                }
                pos += effect.mLabel.length;
            } while (!effect.mLast);
            return sb.toString();
        }

        public byte[] encode(String text, int min, int max, byte pad) throws CoderException {
            CodeState.CodeEffect effect;
            int len = text.length();
            int parts = 0;
            int size = 0;
            byte[][] part = new byte[len][];
            int state = 0;
            int pos = 0;
            System.out.println("[ encode " + Misc.printable(text) + " ]");
            do {
                System.out.println("[ - state=" + state + ", pos=" + pos + " ]");
                effect = this.mStates[state].match(text, pos, len);
                if (effect == null) {
                    throw new CoderException(pos, "cannot encode");
                }
                System.out.println("[ - got " + Misc.printable(effect.mCodes) + (effect.mLast ? "<END>" : "") + (effect.mState < 0 ? "" : ", state=" + effect.mState) + " ]");
                if (effect.mLabel != null) {
                    part[parts++] = effect.mLabel;
                    if (0 <= max && max < (size += effect.mLabel.length)) {
                        throw new CoderException("can't encode in " + max + " bytes");
                    }
                }
                if (effect.mState >= 0) {
                    state = effect.mState;
                }
                pos += effect.mCodes.length();
            } while (!effect.mLast);
            if (size < min) {
                size = min;
            }
            byte[] data = new byte[size];
            pos = 0;
            for (int i = 0; i < parts; ++i) {
                for (int j = 0; j < part[i].length; ++j) {
                    data[pos++] = part[i][j];
                }
            }
            while (pos < size) {
                data[pos++] = pad;
            }
            return data;
        }

        public CodeInfo(String[] states) {
            this.mNames = states;
            this.mStates = new CodeState[states.length];
            for (int i = 0; i < states.length; ++i) {
                this.mStates[i] = new CodeState(states[i]);
            }
        }

        public void addEffect(byte in, byte[] label, boolean last, String codes, byte state, String error) {
            if (in < 0 || this.mStates.length <= in) {
                throw new IllegalArgumentException("invalid state: " + in);
            }
            this.mStates[in].addEffect(label, last, codes, state, error);
        }

        public void dump(PrintStream out, String what) {
            out.println(" " + what);
            for (int i = 0; i < this.mNames.length; ++i) {
                out.println("  State " + i + " = " + this.mNames[i]);
                this.mStates[i].dump(out);
            }
        }

        private static class CodeState {
            private final String mName;
            private byte mMaxLen = 0;
            private CodeEffect[] mEffects = new CodeEffect[257];

            public CodeState(String name) {
                this.mName = name;
            }

            public void addEffect(byte[] label, boolean last, String codes, byte state, String error) {
                if (codes == null) {
                    throw new NullPointerException("no codes");
                }
                if (8 < label.length) {
                    throw new IllegalArgumentException("label " + SharedCoder.hex(label) + " too long, maximum is " + 8 + " bytes");
                }
                if (this.mMaxLen < label.length) {
                    this.mMaxLen = (byte)label.length;
                }
                int index = label.length == 0 ? 0 : (label[0] & 0xFF) + 1;
                this.mEffects[index] = new CodeEffect(label, last, codes, state, error, this.mEffects[index]);
            }

            public void dump(PrintStream out) {
                for (int i = 0; i < 257; ++i) {
                    CodeEffect d = this.mEffects[i];
                    if (d == null) continue;
                    out.println("   Effect " + (i == 0 ? "<END>" : SharedCoder.bname(i - 1)) + ":");
                    while (d != null) {
                        out.println("    label=" + SharedCoder.hex(d.mLabel) + (d.mLast ? "<END>" : "") + ", codes=" + d.mCodes + (d.mState < 0 ? "" : ", state=" + d.mState) + (d.mError == null ? "" : ", error=" + d.mError));
                        d = d.mNext;
                    }
                }
            }

            public CodeEffect match(byte[] data, int from, int end) {
                int left = end - from;
                int init = left <= 0 ? 0 : (data[from] & 0xFF) + 1;
                CodeEffect d = this.mEffects[init];
                while (d != null) {
                    if (d.mLast ? d.mLabel.length == left : d.mLabel.length <= left) {
                        int i = d.mLabel.length;
                        while (i-- > 0) {
                            if (d.mLabel[i] == data[from + i]) continue;
                            break;
                        }
                    } else {
                        return d;
                    }
                    d = d.mNext;
                }
                return null;
            }

            public CodeEffect match(String text, int from, int end) {
                int left = end - from;
                block0: for (int b = 0; b <= 256; ++b) {
                    CodeEffect d = this.mEffects[b];
                    if (d == null) continue;
                    if (d.mLast ? d.mCodes.length() == left : d.mCodes.length() <= left) {
                        int i = d.mCodes.length();
                        while (i-- > 0) {
                            if (d.mCodes.charAt(i) == text.charAt(from + i)) continue;
                            continue block0;
                        }
                    }
                    return d;
                }
                return null;
            }

            public static class CodeEffect {
                public CodeEffect mNext = null;
                public final byte[] mLabel;
                public final boolean mLast;
                public final String mCodes;
                public final byte mState;
                public final String mError;

                public CodeEffect(byte[] label, boolean last, String codes, byte state, String error, CodeEffect next) {
                    this.mLabel = label;
                    this.mCodes = codes;
                    this.mLast = last;
                    this.mState = state;
                    this.mError = error;
                    this.mNext = next;
                }
            }
        }
    }
}

