/*
 * Decompiled with CFR 0.152.
 */
package com.sun.encoder.codegen;

import java.io.IOException;
import java.io.Writer;

public class Emit {
    public boolean debug = false;
    private int mTabSize;
    private int mDentStep;
    private IOException mErr = null;
    private Writer mOut = null;
    private int mDentSize = 0;
    private String mDent = null;
    private boolean mBegin = true;

    public Emit(Writer writer, int tabs, int dent) {
        this.mTabSize = tabs;
        this.mDentStep = dent;
        this.mOut = writer;
    }

    public Emit(Writer writer) {
        this(writer, 8, 4);
    }

    public Emit like(Writer writer) {
        return new Emit(writer, this.mTabSize, this.mDentStep);
    }

    public void setOut(Writer writer) {
        if (this.mOut != null) {
            try {
                this.mOut.flush();
            }
            catch (IOException io) {
                this.mErr = io;
            }
        }
        this.mOut = writer;
        this.setBegin(true);
    }

    public void redent() {
        this.redent(0);
    }

    public void redent(int at) {
        if (at < 0) {
            throw new IllegalArgumentException("indentation must be positive");
        }
        this.mDentSize = at;
        this.mDent = null;
    }

    public int isdent() {
        return this.mDentSize;
    }

    public void indent() {
        this.mDentSize += this.mDentStep;
        this.mDent = null;
    }

    public void undent() {
        this.mDentSize -= this.mDentStep;
        this.mDent = null;
    }

    public void emi0(String text) {
        if (this.mOut == null) {
            throw new RuntimeException("Emit: use after close()?");
        }
        try {
            if (this.debug) {
                System.out.println("[ emit: print <" + text + "> ]");
            }
            this.mOut.write(text);
            this.mOut.write(10);
            this.setBegin(true);
        }
        catch (IOException io) {
            this.mErr = io;
        }
    }

    public void part(String text) {
        if (this.mOut == null) {
            throw new RuntimeException("Emit: use after close()?");
        }
        if (this.mDent == null) {
            int space;
            if (this.debug) {
                System.out.println("[ emit: recomput indent ]");
            }
            StringBuffer b = new StringBuffer();
            if (this.mTabSize > 0) {
                for (space = this.mDentSize; space >= this.mTabSize; space -= this.mTabSize) {
                    b.append('\t');
                }
            }
            while (space-- > 0) {
                b.append(' ');
            }
            this.mDent = b.toString();
        }
        try {
            if (this.mBegin) {
                if (this.debug) {
                    System.out.println("[ emit: write indent ]");
                }
                this.mOut.write(this.mDent);
                this.setBegin(false);
            }
            if (this.debug) {
                System.out.println("[ emit: write <" + text + "> ]");
            }
            this.mOut.write(text);
        }
        catch (IOException io) {
            this.mErr = io;
        }
    }

    public void emit(String text) {
        this.part(text);
        try {
            if (this.debug) {
                System.out.println("[ emit: newline ]");
            }
            this.mOut.write(10);
        }
        catch (IOException io) {
            this.mErr = io;
        }
        this.setBegin(true);
    }

    public void emit() {
        this.emi0("");
    }

    public void emi1(String text) {
        this.indent();
        this.emit(text);
        this.undent();
    }

    public void down(String text) {
        this.emit(text);
        this.indent();
    }

    public void done(String text) {
        this.undent();
        this.emit(text);
    }

    public void flush() throws IOException {
        if (this.mOut != null) {
            this.mOut.flush();
        }
    }

    public void close() throws IOException {
        if (this.mErr != null) {
            throw this.mErr;
        }
        if (this.mOut != null) {
            this.mOut.close();
            this.mOut = null;
        }
    }

    private void setBegin(boolean val) {
        this.mBegin = val;
    }
}

