/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.processor;

import it.imolinfo.jbi4ejb.Logger;
import it.imolinfo.jbi4ejb.LoggerFactory;
import it.imolinfo.jbi4ejb.exception.Jbi4EjbException;
import it.imolinfo.jbi4ejb.jbi.component.runtime.RuntimeHelper;
import it.imolinfo.jbi4ejb.jbi.endpoint.Jbi4EjbProviderEndpoint;
import it.imolinfo.jbi4ejb.processor.ExchangeProcessor;
import it.imolinfo.jbi4ejb.processor.Jbi4EjbDenormalizer;
import it.imolinfo.jbi4ejb.processor.Jbi4EjbMessage;
import it.imolinfo.jbi4ejb.processor.Jbi4EjbNormalizer;
import it.imolinfo.jbi4ejb.processor.transform.SourceTransformer;
import it.imolinfo.jbi4ejb.processor.transform.StringSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import javax.activation.DataHandler;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.attachments.Attachment;
import org.codehaus.xfire.attachments.Attachments;
import org.codehaus.xfire.attachments.JavaMailAttachments;
import org.codehaus.xfire.attachments.SimpleAttachment;
import org.codehaus.xfire.exchange.AbstractMessage;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.service.OperationInfo;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.util.jdom.StaxSerializer;
import org.jdom.Element;

public class ProviderExchangeProcessor
implements ExchangeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ProviderExchangeProcessor.class);
    private Jbi4EjbProviderEndpoint endpoint;
    private SourceTransformer transformer;
    private Jbi4EjbDenormalizer messageDenormalizer;
    private Jbi4EjbNormalizer messageNormalizer;

    public ProviderExchangeProcessor(Jbi4EjbProviderEndpoint endpoint) throws Jbi4EjbException {
        this.endpoint = endpoint;
        this.transformer = new SourceTransformer();
        this.messageDenormalizer = new Jbi4EjbDenormalizer();
        this.messageNormalizer = new Jbi4EjbNormalizer();
    }

    public void process(MessageExchange exchange) {
        LOG.debug("Processing message exchange: " + exchange);
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            LOG.debug("ExchangeStatus.DONE");
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            LOG.debug("ExchangeStatus.ERROR");
            return;
        }
        try {
            XFire xfire = this.endpoint.getSuManager().getLifeCycle().getXfire();
            Service service = this.endpoint.getXfireService();
            Transport t = xfire.getTransportManager().getTransport("uri://schemas.imola.it/jbi/wsdl-extensions/ejb/");
            ByteArrayOutputStream xfireOut = new ByteArrayOutputStream();
            Channel xfireChannel = t.createChannel();
            MessageContext xfireCtx = new MessageContext();
            xfireCtx.setXFire(xfire);
            xfireCtx.setService(service);
            xfireCtx.setProperty("urn:xfire:channel:backchannel", (Object)xfireOut);
            xfireCtx.setExchange(new org.codehaus.xfire.exchange.MessageExchange(xfireCtx));
            InMessage xfireMsg = new InMessage();
            xfireCtx.getExchange().setInMessage(xfireMsg);
            if (exchange.getOperation() != null) {
                OperationInfo op = service.getServiceInfo().getOperation(exchange.getOperation().getLocalPart());
                if (op != null) {
                    xfireCtx.getExchange().setOperation(op);
                } else {
                    LOG.debug("OperationInfo is null.");
                }
            }
            xfireCtx.setCurrentMessage((AbstractMessage)xfireMsg);
            NormalizedMessage in = exchange.getMessage("in");
            if (LOG.isDebugEnabled()) {
                String inMessage = "In message, before unwrapping: " + this.transformer.contentToString(in);
                LOG.debug(inMessage);
            }
            Jbi4EjbMessage inMsg = this.messageDenormalizer.denormalize(in, this.endpoint, exchange.getOperation());
            if (LOG.isDebugEnabled()) {
                String inMessage = "In message, after unwrapping: " + this.transformer.toString(inMsg.getMessageSource());
                LOG.debug(inMessage);
            }
            xfireMsg.setXMLStreamReader(this.transformer.toXMLStreamReader(inMsg.getMessageSource()));
            if (in.getAttachmentNames() != null && in.getAttachmentNames().size() > 0) {
                JavaMailAttachments attachments = new JavaMailAttachments();
                for (String name : in.getAttachmentNames()) {
                    DataHandler dh = in.getAttachment(name);
                    attachments.addPart((Attachment)new SimpleAttachment(name, dh));
                }
                xfireMsg.setAttachments((Attachments)attachments);
            }
            xfireChannel.receive(xfireCtx, xfireMsg);
            xfireChannel.close();
            if (this.isInAndOut(exchange)) {
                if (xfireCtx.getExchange().hasFaultMessage() && xfireCtx.getExchange().getFaultMessage().getBody() != null) {
                    LOG.debug("Fault message");
                    Fault fault = exchange.createFault();
                    XFireFault xFault = (XFireFault)xfireCtx.getExchange().getFaultMessage().getBody();
                    if (xFault.hasDetails()) {
                        Source faultSource = this.createJBIFaultSourceFromSOAPFault(xfireCtx);
                        String faultName = ((Element)xFault.getDetail().getContent().get(0)).getName();
                        this.messageNormalizer.normalizeFault(faultSource, fault, this.endpoint, exchange.getOperation(), faultName, inMsg.isWrapped());
                        exchange.setFault(fault);
                    } else if (xFault.getCause() instanceof Exception) {
                        exchange.setError((Exception)xFault.getCause());
                    } else {
                        exchange.setError(new Exception(xFault.getCause()));
                    }
                } else {
                    String inMessage;
                    NormalizedMessage outMsg = exchange.createMessage();
                    Attachments attachments = xfireCtx.getCurrentMessage().getAttachments();
                    if (attachments != null) {
                        Iterator it = attachments.getParts();
                        while (it.hasNext()) {
                            Attachment att = (Attachment)it.next();
                            outMsg.addAttachment(att.getId(), att.getDataHandler());
                        }
                    }
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(xfireOut.toByteArray());
                    DOMSource outSource = this.transformer.toDOMSourceFromStream(new StreamSource(inputStream));
                    if (LOG.isDebugEnabled()) {
                        inMessage = "Out message, before wrapping: " + this.transformer.toString(outSource);
                        LOG.debug(inMessage);
                    }
                    this.messageNormalizer.normalize(outSource, outMsg, this.endpoint, exchange.getOperation(), inMsg.isWrapped());
                    if (LOG.isDebugEnabled()) {
                        inMessage = "Out message, after wrapping: " + this.transformer.contentToString(outMsg);
                        LOG.debug(inMessage);
                    }
                    exchange.setMessage(outMsg, "out");
                }
            } else {
                String msg = "The exchange type " + exchange.getClass().getName() + " is nt supported, only " + " InOut/InOptionalOut allowed";
                LOG.warn(msg);
                exchange.setStatus(ExchangeStatus.DONE);
            }
            LOG.debug("before - Channel.send");
            RuntimeHelper.getDeliveryChannel().send(exchange);
            LOG.debug("after - Channel.send");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String msg = "error in message exchange:" + ex.getMessage();
            LOG.error(msg);
            exchange.setError(ex);
        }
    }

    protected boolean isInAndOut(MessageExchange exchange) {
        return exchange instanceof InOut || exchange instanceof InOptionalOut;
    }

    private Source createJBIFaultSourceFromSOAPFault(MessageContext ctx) throws XMLStreamException {
        LOG.debug("Creating JBI fault from xfire fault");
        StringWriter strWriter = new StringWriter();
        XMLOutputFactory witerFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = witerFactory.createXMLStreamWriter(strWriter);
        XFireFault fault = (XFireFault)ctx.getExchange().getFaultMessage().getBody();
        LOG.debug("Xfire fault: " + fault);
        if (fault.hasDetails()) {
            Element detail = fault.getDetail();
            StaxSerializer serializer = new StaxSerializer();
            List details = detail.getContent();
            for (int i = 0; i < details.size(); ++i) {
                serializer.writeElement((Element)details.get(i), writer);
            }
        }
        writer.flush();
        StringSource stringSource = new StringSource(strWriter.toString());
        LOG.debug("Fault message produced: " + stringSource);
        return stringSource;
    }
}

