/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4ejb.jbi.component.runtime;

import it.imolinfo.jbi4ejb.jbi.component.runtime.MessageExchangeHandler;
import it.imolinfo.jbi4ejb.jbi.component.runtime.MessageExchangeHandlerFactory;
import it.imolinfo.jbi4ejb.jbi.component.runtime.RuntimeHelper;
import java.util.MissingResourceException;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;

public class RuntimeContext {
    private static RuntimeContext sRuntimeContext;
    private ComponentContext mComponentContext;
    private DeliveryChannel mDeliveryChannel;
    private Logger mDefLogger;
    private Logger mLogger;
    private MessageExchangeHandlerFactory mMEHandlerFactory;

    private RuntimeContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RuntimeContext getInstance() {
        if (sRuntimeContext != null) return sRuntimeContext;
        Class<RuntimeContext> clazz = RuntimeContext.class;
        synchronized (RuntimeContext.class) {
            if (sRuntimeContext != null) return sRuntimeContext;
            sRuntimeContext = new RuntimeContext();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sRuntimeContext;
        }
    }

    public ComponentContext getComponentContext() {
        return this.mComponentContext;
    }

    public void setComponentContext(ComponentContext componentContext) {
        this.mComponentContext = componentContext;
        this.mDeliveryChannel = null;
    }

    public DeliveryChannel getDeliveryChannel() {
        return this.mDeliveryChannel;
    }

    public void openDeliveryChannel() {
        try {
            ComponentContext compCtx = this.getComponentContext();
            this.mDeliveryChannel = compCtx.getDeliveryChannel();
        }
        catch (MessagingException ex) {
            RuntimeHelper.logDebug((Object)ex);
        }
        catch (Exception ex) {
            RuntimeHelper.logDebug(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDeliveryChannel() {
        try {
            if (this.mDeliveryChannel != null) {
                this.mDeliveryChannel.close();
            }
        }
        catch (MessagingException ex) {
            RuntimeHelper.logDebug((Object)ex);
        }
        finally {
            this.mDeliveryChannel = null;
        }
    }

    private Logger getDefaultLogger() {
        if (this.mDefLogger == null) {
            this.mDefLogger = Logger.getLogger(RuntimeContext.class.getName(), null);
        }
        return this.mDefLogger;
    }

    public void setLogger(String name, String resourceBundle) {
        if (this.mComponentContext != null) {
            try {
                this.mLogger = this.mComponentContext.getLogger(name, resourceBundle);
            }
            catch (MissingResourceException ex) {
                ex.printStackTrace();
            }
            catch (JBIException ex) {
                ex.printStackTrace();
            }
        } else {
            this.mLogger = Logger.getLogger(name, resourceBundle);
        }
    }

    public Logger getLogger() {
        if (this.mLogger == null) {
            return this.getDefaultLogger();
        }
        return this.mLogger;
    }

    public String getComponentName() {
        String componentName = null;
        if (this.mComponentContext != null) {
            componentName = this.mComponentContext.getComponentName();
        }
        return componentName;
    }

    public MessageExchangeHandlerFactory getMessageExchangeHandlerFactory() {
        return this.mMEHandlerFactory;
    }

    public void setMessageExchangeHandlerFactory(MessageExchangeHandlerFactory factory) {
        this.mMEHandlerFactory = factory;
    }

    public MessageExchangeHandler newMessageExchangeHandler(MessageExchange msgExchange) {
        MessageExchangeHandlerFactory factory = this.getMessageExchangeHandlerFactory();
        if (factory == null) {
            return null;
        }
        return factory.newHandler(msgExchange);
    }
}

