/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.IMAPProtocol;
import com.sun.mail.imap.protocol.SaslAuthenticator;
import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class IMAPSaslAuthenticator
implements SaslAuthenticator {
    private IMAPProtocol pr;
    private String name;
    private Properties props;
    private boolean debug;
    private PrintStream out;
    private String host;

    public IMAPSaslAuthenticator(IMAPProtocol pr, String name, Properties props, boolean debug, PrintStream out, String host) {
        this.pr = pr;
        this.name = name;
        this.props = props;
        this.debug = debug;
        this.out = out;
        this.host = host;
    }

    public boolean authenticate(String[] mechs, String realm, String authzid, String u, String p) throws ProtocolException {
        String qop;
        SaslClient sc;
        Vector<Response> v = new Vector<Response>();
        String tag = null;
        Response r = null;
        boolean done = false;
        if (this.debug) {
            this.out.print("IMAP SASL DEBUG: Mechanisms:");
            for (int i = 0; i < mechs.length; ++i) {
                this.out.print(" " + mechs[i]);
            }
            this.out.println();
        }
        final String r0 = realm;
        final String u0 = u;
        final String p0 = p;
        CallbackHandler cbh = new CallbackHandler(){

            public void handle(Callback[] callbacks) {
                if (IMAPSaslAuthenticator.this.debug) {
                    IMAPSaslAuthenticator.this.out.println("IMAP SASL DEBUG: callback length: " + callbacks.length);
                }
                block0: for (int i = 0; i < callbacks.length; ++i) {
                    Callback rcb;
                    if (IMAPSaslAuthenticator.this.debug) {
                        IMAPSaslAuthenticator.this.out.println("IMAP SASL DEBUG: callback " + i + ": " + callbacks[i]);
                    }
                    if (callbacks[i] instanceof NameCallback) {
                        NameCallback ncb = (NameCallback)callbacks[i];
                        ncb.setName(u0);
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        PasswordCallback pcb = (PasswordCallback)callbacks[i];
                        pcb.setPassword(p0.toCharArray());
                        continue;
                    }
                    if (callbacks[i] instanceof RealmCallback) {
                        rcb = (RealmCallback)callbacks[i];
                        ((TextInputCallback)rcb).setText(r0 != null ? r0 : ((TextInputCallback)rcb).getDefaultText());
                        continue;
                    }
                    if (!(callbacks[i] instanceof RealmChoiceCallback)) continue;
                    rcb = (RealmChoiceCallback)callbacks[i];
                    if (r0 == null) {
                        ((ChoiceCallback)rcb).setSelectedIndex(((ChoiceCallback)rcb).getDefaultChoice());
                        continue;
                    }
                    String[] choices = ((ChoiceCallback)rcb).getChoices();
                    for (int k = 0; k < choices.length; ++k) {
                        if (!choices[k].equals(r0)) continue;
                        ((ChoiceCallback)rcb).setSelectedIndex(k);
                        continue block0;
                    }
                }
            }
        };
        try {
            sc = Sasl.createSaslClient(mechs, authzid, this.name, this.host, this.props, cbh);
        }
        catch (SaslException sex) {
            if (this.debug) {
                this.out.println("IMAP SASL DEBUG: Failed to create SASL client: " + sex);
            }
            return false;
        }
        if (sc == null) {
            if (this.debug) {
                this.out.println("IMAP SASL DEBUG: No SASL support");
            }
            return false;
        }
        if (this.debug) {
            this.out.println("IMAP SASL DEBUG: SASL client " + sc.getMechanismName());
        }
        try {
            tag = this.pr.writeCommand("AUTHENTICATE " + sc.getMechanismName(), null);
        }
        catch (Exception ex) {
            if (this.debug) {
                this.out.println("IMAP SASL DEBUG: AUTHENTICATE Exception: " + ex);
            }
            return false;
        }
        OutputStream os = this.pr.getIMAPOutputStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] CRLF = new byte[]{13, 10};
        boolean isXGWTRUSTEDAPP = sc.getMechanismName().equals("XGWTRUSTEDAPP");
        while (!done) {
            try {
                r = this.pr.readResponse();
                if (r.isContinuation()) {
                    byte[] ba = r.readByteArray().getNewBytes();
                    if (ba.length > 0) {
                        ba = BASE64DecoderStream.decode(ba);
                    }
                    if (this.debug) {
                        this.out.println("IMAP SASL DEBUG: challenge: " + ASCIIUtility.toString(ba, 0, ba.length) + " :");
                    }
                    ba = sc.evaluateChallenge(ba);
                    done = sc.isComplete();
                    if (ba == null) {
                        if (this.debug) {
                            this.out.println("IMAP SASL DEBUG: no response");
                        }
                        done = true;
                        os.write(CRLF);
                        os.flush();
                        bos.reset();
                        continue;
                    }
                    if (this.debug) {
                        this.out.println("IMAP SASL DEBUG: response: " + ASCIIUtility.toString(ba, 0, ba.length) + " :");
                    }
                    ba = BASE64EncoderStream.encode(ba);
                    if (isXGWTRUSTEDAPP) {
                        bos.write("XGWTRUSTEDAPP ".getBytes());
                    }
                    bos.write(ba);
                    bos.write(CRLF);
                    os.write(bos.toByteArray());
                    os.flush();
                    bos.reset();
                    continue;
                }
                if (r.isTagged() && r.getTag().equals(tag)) {
                    done = true;
                    continue;
                }
                if (r.isBYE()) {
                    done = true;
                    continue;
                }
                v.addElement(r);
            }
            catch (Exception ioex) {
                if (this.debug) {
                    ioex.printStackTrace();
                }
                r = Response.byeResponse(ioex);
                done = true;
            }
        }
        if (sc.isComplete() && (qop = (String)sc.getNegotiatedProperty("javax.security.sasl.qop")) != null && (qop.equalsIgnoreCase("auth-int") || qop.equalsIgnoreCase("auth-conf"))) {
            if (this.debug) {
                this.out.println("IMAP SASL DEBUG: Mechanism requires integrity or confidentiality");
            }
            return false;
        }
        Object[] responses = new Response[v.size()];
        v.copyInto(responses);
        this.pr.notifyResponseHandlers((Response[])responses);
        this.pr.handleResult(r);
        this.pr.setCapabilities(r);
        return true;
    }
}

