/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo.svg;

import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomList;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.DomText;
import com.nwoods.jgo.svg.DefaultElement;
import com.nwoods.jgo.svg.DefaultList;
import com.nwoods.jgo.svg.DefaultText;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AbstractNode
implements DomNode {
    private Node myNode;

    public AbstractNode(Node node) {
        this.myNode = node;
    }

    public Node getNode() {
        return this.myNode;
    }

    public DomNode appendChild(DomNode nodeToAppend) {
        AbstractNode child = (AbstractNode)nodeToAppend;
        AbstractNode appendToDomNode = this;
        Node node = appendToDomNode.getNode().appendChild(child.getNode());
        AbstractNode newNode = new AbstractNode(node);
        return newNode;
    }

    public boolean isElement() {
        return this.myNode.getNodeType() == 1;
    }

    public DomElement elementCast() {
        if (this.getNode().getNodeType() == 1) {
            Element element = (Element)this.getNode();
            return new DefaultElement(element);
        }
        return null;
    }

    private DomList getChildNodes() {
        NodeList nodeList = this.myNode.getChildNodes();
        return new DefaultList(nodeList);
    }

    public DomNode getFirstChild() {
        Node node = this.myNode.getFirstChild();
        if (node == null) {
            return null;
        }
        return new AbstractNode(node);
    }

    public DomElement getFirstChildElement() {
        for (Node node = this.myNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return new DefaultElement((Element)node);
        }
        return null;
    }

    public DomText getFirstChildText() {
        for (Node node = this.myNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 3) continue;
            return new DefaultText((Text)node);
        }
        return null;
    }

    public DomNode getParentNode() {
        Node node = this.myNode.getParentNode();
        if (node == null) {
            return null;
        }
        return new AbstractNode(node);
    }

    public DomNode getNextSibling() {
        Node node = this.myNode.getNextSibling();
        if (node == null) {
            return null;
        }
        return new AbstractNode(node);
    }

    public DomElement getNextSiblingElement() {
        for (Node node = this.myNode.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return new DefaultElement((Element)node);
        }
        return null;
    }

    public DomElement getNextSiblingJGoClassElement() {
        for (Node node = this.myNode.getNextSibling(); node != null; node = node.getNextSibling()) {
            Element element;
            if (node.getNodeType() != 1 || !(element = (Element)node).getLocalName().equals("JGoClass")) continue;
            return new DefaultElement(element);
        }
        return null;
    }

    public DomText getNextSiblingText() {
        for (Node node = this.myNode.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 3) continue;
            return new DefaultText((Text)node);
        }
        return null;
    }
}

