/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.model.project;

import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import javax.swing.tree.TreePath;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.TimeoutExpiredException;
import org.netbeans.modules.visualweb.gravy.PageTopComponentOperator;
import org.netbeans.modules.visualweb.gravy.RaveWindowOperator;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.netbeans.modules.visualweb.gravy.designer.DesignerPaneOperator;
import org.netbeans.modules.visualweb.gravy.model.components.WebComponent;
import org.netbeans.modules.visualweb.gravy.model.navigation.LinkableSource;
import org.netbeans.modules.visualweb.gravy.model.navigation.LinkableTarget;
import org.netbeans.modules.visualweb.gravy.model.project.JSPFile;
import org.netbeans.modules.visualweb.gravy.model.project.JavaFile;
import org.netbeans.modules.visualweb.gravy.model.project.Project;
import org.netbeans.modules.visualweb.gravy.model.project.ProjectEntry;
import org.netbeans.modules.visualweb.gravy.model.project.RootEntry;
import org.netbeans.modules.visualweb.gravy.model.project.SourceFolder;
import org.netbeans.modules.visualweb.gravy.model.project.WebPageFolder;
import org.netbeans.modules.visualweb.gravy.model.project.components.Component;
import org.netbeans.modules.visualweb.gravy.model.project.components.NonVisualComponent;
import org.netbeans.modules.visualweb.gravy.model.project.components.VisualComponent;
import org.netbeans.modules.visualweb.gravy.model.project.components.VisualEventHandlingComponent;
import org.netbeans.modules.visualweb.gravy.properties.SheetTableOperator;
import org.netbeans.modules.visualweb.gravy.toolbox.PaletteContainerOperator;

public class WebPage
extends JSPFile
implements LinkableSource,
LinkableTarget {
    private static final String propID = "id";
    PageTopComponentOperator page = null;
    private JavaFile jf;
    private String sep = File.separator;

    WebPage(TreePath path, String name, ProjectEntry parent) {
        super(path, name, parent);
        SourceFolder sf = ((WebPageFolder)parent).getSourceFolder();
        JavaFile jf = sf.addJavaFile(name);
        jf.webpage = this;
        this.jf = jf;
        this.webpage = this;
    }

    public JavaFile getJavaFile() {
        return this.jf;
    }

    public Component add(WebComponent webcomponent) {
        return this.add(webcomponent, new Point(0, 0));
    }

    public Component add(WebComponent webcomponent, Point point) {
        return this.add(webcomponent, point, null);
    }

    public Component add(WebComponent webcomponent, Point point, String name) {
        Component newComponent;
        this.open();
        DesignerPaneOperator designer = this.page.getDesigner();
        TestUtils.wait(1000);
        PaletteContainerOperator palette = null;
        try {
            palette = new PaletteContainerOperator(webcomponent.getComponentSet().getID());
        }
        catch (Exception e) {
            throw new JemmyException("Palette category with name " + webcomponent.getComponentSet().getID() + " can't be found!", (Throwable)e);
        }
        TestUtils.wait(2000);
        try {
            palette.addComponent(webcomponent.getID(), designer, point);
        }
        catch (Exception e) {
            throw new JemmyException("Component " + webcomponent.getID() + " can't be added!", (Throwable)e);
        }
        TestUtils.wait(2000);
        try {
            SheetTableOperator sheet = new SheetTableOperator();
            if (name == null) {
                name = sheet.getValue(propID);
            } else {
                sheet.setTextValue(propID, name);
            }
        }
        catch (Exception e) {
            throw new JemmyException("Name for component " + webcomponent.getID() + " can't be set!", (Throwable)e);
        }
        if (webcomponent.isVisual()) {
            newComponent = webcomponent.isEventHadling() ? new VisualEventHandlingComponent(webcomponent, name) : new VisualComponent(webcomponent, name);
            ((VisualComponent)newComponent).setCoordinates(point);
        } else {
            newComponent = new NonVisualComponent(webcomponent, name);
        }
        newComponent.Page = this;
        this.childList.add(newComponent);
        return newComponent;
    }

    public Component[] getComponents() {
        return this.childList.toArray(new Component[this.childList.size()]);
    }

    public Component getComponent(int index) {
        return (Component)this.childList.get(index);
    }

    public Component getComponent(Component type, int index) {
        ArrayList tmpComponents = new ArrayList();
        for (int i = 0; i < this.childList.size(); ++i) {
            if (!((Component)this.childList.get(i)).getType().equals(type.getType())) continue;
            tmpComponents.add(this.childList.get(i));
        }
        return (Component)tmpComponents.get(index);
    }

    public Component getComponent(String ID) {
        return null;
    }

    public String getLinkableSourceName() {
        String folder_path = this.getTreePath().toString();
        if (folder_path.indexOf("|", folder_path.indexOf("|") + 1) == -1) {
            return this.getName() + ".jsp";
        }
        folder_path = folder_path.substring(folder_path.indexOf("|", folder_path.indexOf("|") + 1) + 1, folder_path.length() - 1).replace('|', '/');
        return folder_path + "/" + this.getName() + ".jsp";
    }

    public String getLinkableTargetName() {
        String folder_path = this.getTreePath().toString();
        if (folder_path.indexOf("|", folder_path.indexOf("|") + 1) == -1) {
            return this.getName() + ".jsp";
        }
        folder_path = folder_path.substring(folder_path.indexOf("|", folder_path.indexOf("|") + 1) + 1, folder_path.length() - 1).replace('|', '/');
        return folder_path + "/" + this.getName() + ".jsp";
    }

    private Project getProject() {
        ProjectEntry tmp = this;
        while (!((tmp = tmp.getParent()) instanceof RootEntry)) {
        }
        return ((RootEntry)tmp).getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        block10: {
            long tmpTimeout = 0L;
            String tmp_path = this.getTreePath().toString();
            int start_compare = tmp_path.indexOf(RootEntry.webPagesName) + RootEntry.webPagesName.length() + 1;
            String compare_tooltip = start_compare != tmp_path.length() ? (tmp_path.substring(start_compare, tmp_path.length() - 1) + "|" + this.name + ".jsp").replace('|', File.separatorChar) : this.name + ".jsp";
            String project_path = this.getProject().getLocation() + this.getProject().getName() + this.sep + "web" + this.sep;
            compare_tooltip = project_path + compare_tooltip;
            try {
                tmpTimeout = RaveWindowOperator.getDefaultRave().getTimeouts().getTimeout("ComponentOperator.WaitComponentTimeout");
                RaveWindowOperator.getDefaultRave().getTimeouts().setTimeout("ComponentOperator.WaitComponentTimeout", 5000L);
                if (this.page == null) {
                    int i = 0;
                    while (!((String)(this.page = new PageTopComponentOperator(this.getName(), i++)).getDump().get("Tooltip text")).equals(compare_tooltip)) {
                    }
                    break block10;
                }
                try {
                    this.page.makeComponentVisible();
                }
                catch (Exception e) {
                    throw new TimeoutExpiredException("");
                }
            }
            catch (TimeoutExpiredException e) {
                int i = 0;
                super.open();
                while (!((String)(this.page = new PageTopComponentOperator(this.getName(), i++)).getDump().get("Tooltip text")).equals(compare_tooltip)) {
                }
            }
            finally {
                RaveWindowOperator.getDefaultRave().getTimeouts().setTimeout("ComponentOperator.WaitComponentTimeout", tmpTimeout);
            }
        }
        this.page.getDesigner();
    }

    public void close() {
        this.open();
        TestUtils.wait(500);
        this.page.close();
    }
}

