/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.debugger;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.actions.CopyAction;
import org.netbeans.jellytools.actions.FindAction;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;

public class TermOperator
extends ComponentOperator {
    ComponentOperator[] _screen = new ComponentOperator[5];
    JComponent[] _term = new JComponent[5];
    private static final Action findNextAction = new Action(null, "Find Next");
    private static final Action selectAllAction = new Action(null, "Select All");
    private static final Action clearAction = new Action(null, "Clear Output");
    private static final Action startRedirectionAction = new Action(null, "Start Redirection of This View to File");
    private static final Action stopRedirectionAction = new Action(null, "Stop Redirection of This View to File");
    private static final CopyAction copyAction = new CopyAction();
    private static final FindAction findAction = new FindAction();

    public TermOperator(JComponent source) {
        super((Component)source);
    }

    public TermOperator(ContainerOperator contOper, String name) {
        this(contOper, name, 0);
    }

    public TermOperator(ContainerOperator contOper, int index) {
        this(contOper, null, index);
    }

    public TermOperator(ContainerOperator contOper, String name, int index) {
        super(contOper.waitSubComponent((ComponentChooser)new InnerTabSubchooser(name), index));
        this.makeComponentVisible();
        this.copyEnvironment((Operator)contOper);
    }

    public TermOperator(ContainerOperator contOper) {
        super(contOper);
    }

    public JComponent getTermSource() {
        return this.getTermSource(0);
    }

    public JComponent getTermSource(int termIndex) {
        if (termIndex >= this._term.length) {
            return (JComponent)ComponentOperator.waitComponent((Container)((Container)this.getSource()), (ComponentChooser)new TermFinder(), (int)termIndex);
        }
        if (this._term[termIndex] == null) {
            this._term[termIndex] = (JComponent)ComponentOperator.waitComponent((Container)((Container)this.getSource()), (ComponentChooser)new TermFinder(), (int)termIndex);
        }
        return this._term[termIndex];
    }

    public int findRow(String rowText) {
        return this.findRow(rowText, 0);
    }

    public int findRow(String rowText, int termIndex) {
        for (int i = 0; i < this.getLineCount(termIndex); ++i) {
            if (!this.getComparator().equals(this.getRowText(i, termIndex), rowText)) continue;
            return i;
        }
        return -1;
    }

    public String getText() {
        return this.getText(0);
    }

    public String getText(int termIndex) {
        this.flush(termIndex);
        return this.getText(0, this.getLineCount(termIndex) - 1, termIndex);
    }

    public String getText(int startRow, int endRow) {
        return this.getText(startRow, endRow);
    }

    public String getText(int startRow, int endRow, int termIndex) {
        this.flush(termIndex);
        String result = "";
        for (int i = startRow; i < endRow; ++i) {
            result = result + this.getRowText(i, termIndex) + "\n";
        }
        return result;
    }

    public void waitText(String text) {
        this.waitText(text, 0);
    }

    public void waitText(final String text, final int termIndex) {
        this.getOutput().printLine("Wait \"" + text + "\" text in component \n    : " + this.getTermSource(termIndex).toString());
        this.getOutput().printGolden("Wait \"" + text + "\" text");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return TermOperator.this.findRow(text, termIndex) > -1;
            }

            public String getDescription() {
                return "\"" + text + "\" text";
            }
        });
    }

    public int getLineCount() {
        return this.getLineCount(0);
    }

    public int getLineCount(int termIndex) {
        this.flush(termIndex);
        return this.getCursorRow(termIndex) + 1;
    }

    public ComponentOperator screen() {
        return this.screen(0);
    }

    public ComponentOperator screen(int termIndex) {
        if (termIndex >= this._screen.length || this._screen[termIndex] == null) {
            ComponentOperator sc = ComponentOperator.createOperator((Component)ComponentOperator.waitComponent((Container)this.getTermSource(termIndex), (ComponentChooser)new ScreenFinder()));
            sc.copyEnvironment((Operator)this);
            if (termIndex < this._screen.length) {
                this._screen[termIndex] = sc;
            }
            return sc;
        }
        return this._screen[termIndex];
    }

    public String getRowText(int row) {
        return this.getRowText(row, 0);
    }

    public String getRowText(int row, int termIndex) {
        return (String)this.runMapping(new Operator.MapAction("getRowText"){

            public Object map() {
                return null;
            }
        });
    }

    public String textWithin(int beginRow, int beginCol, int endRow, int endCol) {
        return this.textWithin(beginRow, beginCol, endRow, endCol, 0);
    }

    public String textWithin(int beginRow, int beginCol, int endRow, int endCol, int termIndex) {
        Object begin = null;
        Object end = null;
        return (String)this.runMapping(new Operator.MapAction("textWithin"){

            public Object map() {
                return null;
            }
        });
    }

    public int getCursorRow() {
        return this.getCursorRow(0);
    }

    public int getCursorRow(int termIndex) {
        return this.runMapping(new Operator.MapIntegerAction("getCursorRow"){

            public int map() {
                return 0;
            }
        });
    }

    public void flush() {
        this.flush(0);
    }

    public void flush(int termIndex) {
        this.runMapping(new Operator.MapVoidAction("flush"){

            public void map() {
            }
        });
    }

    public void verify() {
        this.screen();
    }

    public void copy() {
    }

    public void find() {
    }

    public void findNext() {
    }

    public void selectAll() {
    }

    public void clearOutput() {
    }

    public void startRedirection() {
    }

    public void stopRedirection() {
    }

    public void discard() {
    }

    public void discardAll() {
    }

    public void close() {
    }

    private static final class InnerTabSubchooser
    implements ComponentChooser {
        private String termName;

        public InnerTabSubchooser() {
        }

        public InnerTabSubchooser(String termName) {
            this.termName = termName;
        }

        public boolean checkComponent(Component comp) {
            if (comp.getClass().getName().endsWith("OutputTabInner")) {
                return Operator.getDefaultStringComparator().equals(comp.getName(), this.termName);
            }
            return false;
        }

        public String getDescription() {
            return "org.netbeans.core.output.OutputTabInner";
        }
    }

    static class TermFinder
    implements ComponentChooser {
        TermFinder() {
        }

        public boolean checkComponent(Component comp) {
            return false;
        }

        public String getDescription() {
            return "org.netbeans.lib.terminalemulator.Term";
        }
    }

    static class ScreenFinder
    implements ComponentChooser {
        ScreenFinder() {
        }

        public boolean checkComponent(Component comp) {
            Class<?> cls = comp.getClass();
            do {
                if (!cls.getName().equals("org.netbeans.lib.terminalemulator.Screen")) continue;
                return true;
            } while ((cls = cls.getSuperclass()) != null);
            return false;
        }

        public String getDescription() {
            return "Screen component";
        }
    }
}

