/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.debugger;

import java.awt.Component;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;
import org.netbeans.jemmy.operators.JToggleButtonOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.TopComponentOperator;
import org.netbeans.modules.visualweb.gravy.Util;

public class DebuggerWindowOperator
extends TopComponentOperator {
    ComponentOperator desktop = null;
    JTextComponentOperator query = null;
    private JToggleButtonOperator _tbSessions;
    private JToggleButtonOperator _tbThreads;
    private JToggleButtonOperator _tbCallStack;
    private JToggleButtonOperator _tbLocalVariables;
    private JToggleButtonOperator _tbAllInOne;
    private JToggleButtonOperator _tbWatches;
    private JToggleButtonOperator _tbClasses;
    private JToggleButtonOperator _tbBreakpoints;
    private JToggleButtonOperator _tbProperties;
    private JToggleButtonOperator _tbPublic;
    private JToggleButtonOperator _tbProtected;
    private JToggleButtonOperator _tbPrivate;
    private JToggleButtonOperator _tbPackagePrivate;
    private JToggleButtonOperator _tbStatic;
    private JToggleButtonOperator _tbInherited;
    private JTableOperator _tabTreeTable;
    private String[] views = new String[]{"Sessions", "Threads", "CallStack", "LocalVariables", "AllInOne", "Watches", "Classes", "Breakpoints", "Properties"};

    public DebuggerWindowOperator(ContainerOperator parent) {
        super(parent, new DebuggerWindowChooser("Debugger"));
    }

    public DebuggerWindowOperator() {
        this((ContainerOperator)Util.getMainWindow());
    }

    public DebuggerWindowOperator show() {
        this.setComparator((Operator.StringComparator)new Operator.DefaultStringComparator(false, true));
        Util.getMainTab().setSelectedIndex(Util.getMainTab().findPage("Debugger"));
        return new DebuggerWindowOperator((ContainerOperator)Util.getMainWindow());
    }

    public JToggleButtonOperator tbSessions() {
        this._tbSessions = new JToggleButtonOperator((ContainerOperator)this, "", 0);
        return this._tbSessions;
    }

    public JToggleButtonOperator tbThreads() {
        this._tbThreads = new JToggleButtonOperator((ContainerOperator)this, "", 1);
        return this._tbThreads;
    }

    public JToggleButtonOperator tbCallStack() {
        this._tbCallStack = new JToggleButtonOperator((ContainerOperator)this, "", 2);
        return this._tbCallStack;
    }

    public JToggleButtonOperator tbLocalVariables() {
        this._tbLocalVariables = new JToggleButtonOperator((ContainerOperator)this, "", 3);
        return this._tbLocalVariables;
    }

    public JToggleButtonOperator tbAllInOne() {
        this._tbAllInOne = new JToggleButtonOperator((ContainerOperator)this, "", 4);
        return this._tbAllInOne;
    }

    public JToggleButtonOperator tbWatches() {
        this._tbWatches = new JToggleButtonOperator((ContainerOperator)this, "", 5);
        return this._tbWatches;
    }

    public JToggleButtonOperator tbClasses() {
        this._tbClasses = new JToggleButtonOperator((ContainerOperator)this, "", 6);
        return this._tbClasses;
    }

    public JToggleButtonOperator tbBreakpoints() {
        this._tbBreakpoints = new JToggleButtonOperator((ContainerOperator)this, "", 7);
        return this._tbBreakpoints;
    }

    public JToggleButtonOperator tbProperties() {
        this._tbProperties = new JToggleButtonOperator((ContainerOperator)this, "", 8);
        return this._tbProperties;
    }

    public JToggleButtonOperator tbPublic() {
        this._tbPublic = new JToggleButtonOperator((ContainerOperator)this, "", 9);
        return this._tbPublic;
    }

    public JToggleButtonOperator tbProtected() {
        this._tbProtected = new JToggleButtonOperator((ContainerOperator)this, "", 10);
        return this._tbProtected;
    }

    public JToggleButtonOperator tbPrivate() {
        this._tbPrivate = new JToggleButtonOperator((ContainerOperator)this, "", 11);
        return this._tbPrivate;
    }

    public JToggleButtonOperator tbPackagePrivate() {
        this._tbPackagePrivate = new JToggleButtonOperator((ContainerOperator)this, "", 12);
        return this._tbPackagePrivate;
    }

    public JToggleButtonOperator tbStatic() {
        this._tbStatic = new JToggleButtonOperator((ContainerOperator)this, "", 13);
        return this._tbStatic;
    }

    public JToggleButtonOperator tbInherited() {
        this._tbInherited = new JToggleButtonOperator((ContainerOperator)this, "", 14);
        return this._tbInherited;
    }

    public void checkBreakpoints(boolean state) {
        if (this.tbBreakpoints().isSelected() != state) {
            this.tbBreakpoints().push();
        }
    }

    public boolean getBreakpointsState() {
        return this.tbBreakpoints().isSelected();
    }

    public void checkSessions(boolean state) {
        if (this.tbSessions().isSelected() != state) {
            this.tbSessions().push();
        }
    }

    public boolean getSessionsState() {
        return this.tbSessions().isSelected();
    }

    public void checkThreads(boolean state) {
        if (this.tbThreads().isSelected() != state) {
            this.tbThreads().push();
        }
    }

    public boolean getThreadsState() {
        return this.tbThreads().isSelected();
    }

    public void checkCallStack(boolean state) {
        if (this.tbCallStack().isSelected() != state) {
            this.tbCallStack().push();
        }
    }

    public boolean getCallStackState() {
        return this.tbCallStack().isSelected();
    }

    public void checkLocalVariables(boolean state) {
        if (this.tbLocalVariables().isSelected() != state) {
            this.tbLocalVariables().push();
        }
    }

    public boolean getLocalVariablesState() {
        return this.tbLocalVariables().isSelected();
    }

    public void checkAllInOne(boolean state) {
        if (this.tbAllInOne().isSelected() != state) {
            this.tbAllInOne().push();
        }
    }

    public boolean getAllInOneState() {
        return this.tbAllInOne().isSelected();
    }

    public void checkWatches(boolean state) {
        if (this.tbWatches().isSelected() != state) {
            this.tbWatches().push();
        }
    }

    public boolean getWatchesState() {
        return this.tbWatches().isSelected();
    }

    public void checkClasses(boolean state) {
        if (this.tbClasses().isSelected() != state) {
            this.tbClasses().push();
        }
    }

    public boolean getClassesState() {
        return this.tbClasses().isSelected();
    }

    public void checkProperties(boolean state) {
        if (this.tbProperties().isSelected() != state) {
            this.tbProperties().push();
        }
    }

    public boolean getPropertiesState() {
        return this.tbProperties().isSelected();
    }

    public JTableOperator getJTableOperator(String view) {
        int viewNumber = -1;
        int displayedViews = -1;
        do {
            switch (++viewNumber) {
                case 0: {
                    if (this.views[viewNumber].equals(view)) {
                        this.checkSessions(true);
                        ++displayedViews;
                        break;
                    }
                    if (!this.getSessionsState()) break;
                    ++displayedViews;
                    break;
                }
                case 1: {
                    if (this.views[viewNumber].equals(view)) {
                        this.checkThreads(true);
                        ++displayedViews;
                        break;
                    }
                    if (!this.getThreadsState()) break;
                    ++displayedViews;
                    break;
                }
                case 2: {
                    if (this.views[viewNumber].equals(view)) {
                        this.checkCallStack(true);
                        ++displayedViews;
                        break;
                    }
                    if (!this.getCallStackState()) break;
                    ++displayedViews;
                    break;
                }
                case 3: {
                    if (this.views[viewNumber].equals(view)) {
                        this.checkLocalVariables(true);
                        ++displayedViews;
                        break;
                    }
                    if (!this.getLocalVariablesState()) break;
                    ++displayedViews;
                    break;
                }
                case 4: {
                    if (this.views[viewNumber].equals(view)) {
                        this.checkAllInOne(true);
                        ++displayedViews;
                        break;
                    }
                    if (!this.getAllInOneState()) break;
                    ++displayedViews;
                    break;
                }
                case 5: {
                    if (this.views[viewNumber].equals(view)) {
                        this.checkWatches(true);
                        ++displayedViews;
                        break;
                    }
                    if (!this.getWatchesState()) break;
                    ++displayedViews;
                    break;
                }
                case 6: {
                    if (this.views[viewNumber].equals(view)) {
                        this.checkClasses(true);
                        ++displayedViews;
                        break;
                    }
                    if (!this.getClassesState()) break;
                    ++displayedViews;
                    break;
                }
                case 7: {
                    if (this.views[viewNumber].equals(view)) {
                        this.checkBreakpoints(true);
                        ++displayedViews;
                        break;
                    }
                    if (!this.getBreakpointsState()) break;
                    ++displayedViews;
                    break;
                }
                case 8: {
                    if (this.views[viewNumber].equals(view)) {
                        this.checkProperties(true);
                        ++displayedViews;
                        break;
                    }
                    if (!this.getPropertiesState()) break;
                    ++displayedViews;
                }
            }
        } while (!this.views[viewNumber].equals(view));
        this._tabTreeTable = new JTableOperator((ContainerOperator)this, displayedViews);
        return this._tabTreeTable;
    }

    public static class DebuggerWindowChooser
    implements ComponentChooser {
        String ID;
        private Operator.StringComparator comparator;

        public DebuggerWindowChooser(String ID) {
            this(ID, (Operator.StringComparator)new Operator.DefaultStringComparator(false, false));
        }

        public DebuggerWindowChooser(String ID, Operator.StringComparator comparator) {
            this.ID = ID;
            this.comparator = comparator;
        }

        public boolean checkComponent(Component comp) {
            if (comp != null && comp.getName() != null) {
                return comp instanceof Component && comp.getName().equals(this.ID);
            }
            return false;
        }

        public String getDescription() {
            return "A Component with \"" + this.ID + "\" ID";
        }
    }
}

