/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.dataconnectivity;

import java.awt.Point;
import java.io.File;
import javax.swing.tree.TreePath;
import junit.framework.Assert;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JCheckBoxOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTableOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.operators.WindowOperator;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.netbeans.modules.visualweb.gravy.Util;
import org.netbeans.modules.visualweb.gravy.dataconnectivity.AddDataSourceOperator;
import org.netbeans.modules.visualweb.gravy.dataconnectivity.DataSource;
import org.netbeans.modules.visualweb.gravy.dataconnectivity.EditServerTypesOperator;
import org.netbeans.modules.visualweb.gravy.dataconnectivity.ModifyDataSourceOperator;
import org.netbeans.modules.visualweb.gravy.dataconnectivity.ServerExplorerOperator;

public class ServerNavigatorOperator
extends ServerExplorerOperator {
    private static final String pointbaseName = "Bundled Database";
    private static final String[] pbParams = new String[]{"", "Bundled Database"};
    JTreeOperator tree = null;

    public ServerNavigatorOperator(ContainerOperator parent) {
        super(parent);
        this.getTree();
    }

    public ServerNavigatorOperator() {
        this((ContainerOperator)Util.getMainWindow());
    }

    public static ServerNavigatorOperator showNavigatorOperator() {
        Util.getMainMenu().pushMenuNoBlock("Window|Services");
        Util.wait(1000);
        new QueueTool().waitEmpty();
        return new ServerNavigatorOperator();
    }

    public void addTable(TreePath p_path) {
        JPopupMenuOperator popup = new JPopupMenuOperator(this.getTree().callPopupOnPath(p_path));
        popup.pushMenu(ServerNavigatorOperator.getBundleString("Add_to_Form"));
    }

    public boolean addDataSource(String p_dsname, DataSource p_ds) {
        this.pushPopup(ServerNavigatorOperator.getBundleString("Databases"), ServerNavigatorOperator.getBundleString("New connection..."));
        AddDataSourceOperator a_dlg = new AddDataSourceOperator();
        JComboBoxOperator a_cbo = a_dlg.cboServerType();
        System.out.println("DBType=" + p_ds.getDbType());
        System.out.println("DBType now=" + a_cbo.getSelectedItem());
        if (p_ds.getDbType() != null && p_ds.getDbType().length() > 0) {
            a_cbo.selectItem(p_ds.getDbType());
        }
        Util.wait(1000);
        System.out.println("DB URL=" + p_ds.getDbUrl());
        if (p_ds.getDbUrl() != null && p_ds.getDbUrl().length() > 0) {
            a_dlg.cboURL().clearText();
            a_dlg.cboURL().typeText(p_ds.getDbUrl());
        }
        Util.wait(500);
        a_dlg.txtUser().clearText();
        a_dlg.txtUser().typeText(p_ds.getUser());
        Util.wait(500);
        a_dlg.txtPassword().clearText();
        a_dlg.txtPassword().typeText(p_ds.getPassword());
        Util.wait(500);
        new JButtonOperator((ContainerOperator)a_dlg, ServerNavigatorOperator.getBundleString("OK")).push();
        Util.wait(10000);
        if (p_ds.getDbType().equalsIgnoreCase("mysql")) {
            new JButtonOperator((ContainerOperator)a_dlg, ServerNavigatorOperator.getBundleString("OK")).push();
        }
        return true;
    }

    public void connectToDataSource(String p_dsname, DataSource p_ds) {
        String[] a_ss = new String[]{ServerNavigatorOperator.getBundleString("Databases"), p_dsname};
        this.pushPopup(a_ss, ServerNavigatorOperator.getBundleString("Connect..."));
        Util.wait(1000);
        JDialogOperator a_dlg = new JDialogOperator();
        Util.wait(1000);
        JTextFieldOperator tfUser = new JTextFieldOperator((ContainerOperator)a_dlg, 0);
        tfUser.clearText();
        tfUser.typeText(p_ds.getUser());
        Util.wait(500);
        JTextFieldOperator tfPassword = new JTextFieldOperator((ContainerOperator)a_dlg, 1);
        tfPassword.clearText();
        tfPassword.typeText(p_ds.getPassword());
        Util.wait(500);
        JCheckBoxOperator chkRemember = new JCheckBoxOperator((ContainerOperator)a_dlg);
        chkRemember.setSelected(true);
        new JButtonOperator((ContainerOperator)a_dlg, ServerNavigatorOperator.getBundleString("OK")).pushNoBlock();
        Util.wait(2000);
        try {
            new TopComponentOperator("Output").close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean modifyDataSource(String p_dsname, DataSource p_ds) {
        String[] a_ss = new String[]{ServerNavigatorOperator.getBundleString("Databases"), p_dsname};
        this.pushPopup(a_ss, ServerNavigatorOperator.getBundleString("MODIFY_DATASOURCE"));
        ModifyDataSourceOperator a_dlg = new ModifyDataSourceOperator();
        JTextFieldOperator a_tfo = a_dlg.txtDSName();
        a_tfo.clearText();
        a_tfo.typeText(p_dsname);
        Util.wait(500);
        a_tfo = a_dlg.txtUser();
        a_tfo.clearText();
        a_tfo.typeText(p_ds.getUser());
        Util.wait(500);
        a_tfo = a_dlg.txtPassword();
        a_tfo.clearText();
        a_tfo.typeText(p_ds.getPassword());
        Util.wait(500);
        a_tfo = a_dlg.txtURL();
        a_tfo.clearText();
        a_tfo.typeText(p_ds.getDbUrl());
        Util.wait(2000);
        new QueueTool().waitEmpty();
        a_dlg.btTestConnection().push();
        JDialogOperator a_dlg1 = new JDialogOperator((WindowOperator)a_dlg, 0);
        boolean success = a_dlg1.getTitle().equals("Information");
        new JButtonOperator((ContainerOperator)a_dlg1, ServerNavigatorOperator.getBundleString("OK")).push();
        new JButtonOperator((ContainerOperator)a_dlg, ServerNavigatorOperator.getBundleString(success ? "MODIFY" : "CANCEL")).push();
        return success;
    }

    public boolean removeDataSource(String p_dsname) {
        String[] a_ss = new String[]{ServerNavigatorOperator.getBundleString("Databases"), p_dsname};
        this.pushPopup(a_ss, ServerNavigatorOperator.getBundleString("REMOVE_CONNECTION"));
        Util.wait(1000);
        return true;
    }

    public void addNewServerType(String p_typeName, String p_template, String p_iniDrivers) {
        this.addNewServerType(p_typeName, p_template, p_iniDrivers, "");
    }

    public void addNewServerType(String p_typeName, String p_template, String p_iniDrivers, String p_addDrivers) {
        this.pushPopup(new String[]{ServerNavigatorOperator.getBundleString("Databases"), ServerNavigatorOperator.getBundleString("Drivers")}, ServerNavigatorOperator.getBundleString("New driver..."));
        EditServerTypesOperator a_dlg = new EditServerTypesOperator();
        Util.wait(1000);
        a_dlg.btNew().pushNoBlock();
        JDialogOperator a_dlg1 = new JDialogOperator(ServerNavigatorOperator.getBundleString("Select Driver"));
        if (System.getProperty("os.name").equals("Mac OS X")) {
            String[] splittedPath = p_iniDrivers.substring(1, p_iniDrivers.length()).split(File.separator);
            TestUtils.wait(1000);
            JComboBoxOperator cbRoot = new JComboBoxOperator((ContainerOperator)a_dlg1);
            for (int i = 0; i < cbRoot.getItemCount(); ++i) {
                if (!cbRoot.getItemAt(i).toString().equals(File.separator)) continue;
                cbRoot.setSelectedIndex(i);
                break;
            }
            String toCompare = "";
            for (int i = 0; i < splittedPath.length; ++i) {
                JTableOperator jtoPath = new JTableOperator((ContainerOperator)a_dlg1);
                toCompare = toCompare + "/" + splittedPath[i];
                System.out.println("toComapre=" + toCompare);
                Point cell = jtoPath.findCell(toCompare, (Operator.StringComparator)new Operator.DefaultStringComparator(true, true), 0);
                TestUtils.wait(1000);
                jtoPath.clickOnCell((int)cell.getY(), (int)cell.getX(), 2);
                TestUtils.wait(1000);
            }
        } else {
            JTextFieldOperator a_tf1 = new JTextFieldOperator((ContainerOperator)a_dlg1);
            a_tf1.typeText(p_iniDrivers);
            Util.wait(500);
            new JButtonOperator((ContainerOperator)a_dlg1, "Open").push();
            Util.wait(1000);
        }
        Util.wait(1000);
        a_dlg.btOK().push();
    }

    public void deleteServerType(String p_typeName) {
        this.pushPopup(ServerNavigatorOperator.getBundleString("Databases"), ServerNavigatorOperator.getBundleString("CONFIGURE_JDBC_DRIVER"));
        EditServerTypesOperator a_dlg = new EditServerTypesOperator();
        Util.wait(1000);
        a_dlg.lstServerTypes().setSelectedValue((Object)p_typeName, true);
        a_dlg.btRemove().pushNoBlock();
        Util.wait(1000);
        a_dlg.closeByButton();
    }

    public void viewData(String p_path) {
        this.pushPopup(p_path, ServerNavigatorOperator.getBundleString("VIEW_DATA"));
    }

    public void viewData(String[] p_path) {
        this.pushPopup(p_path, ServerNavigatorOperator.getBundleString("VIEW_DATA"));
    }

    public void closeDataView() {
        Util.closeWindow();
    }

    public void showSchema(String p_ds, String[] p_schema) {
        this.pushPopup(ServerNavigatorOperator.getBundleString("Databases") + "/" + p_ds, ServerNavigatorOperator.getBundleString("VIEW_DATA"));
    }

    public static String getBundleString(String p_text) {
        System.out.println("Getting bundle for " + p_text);
        return p_text;
    }

    public static boolean isPBRunning() {
        boolean result = true;
        JPopupMenuOperator pointbasePopupMenu = ServerNavigatorOperator.getTreeNodePopupMenu(Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.dataconnectivity.explorer.ideDb.Bundle", (String)"Bundled_DB_ServerNav_NodeName", (Object[])pbParams));
        if (pointbasePopupMenu != null) {
            result = !TestUtils.findPopupMenuItemByLabel(pointbasePopupMenu, Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.dataconnectivity.explorer.ideDb.Bundle", (String)"Bundled_DB_Start", (Object[])pbParams)).isEnabled();
        } else {
            Assert.fail((String)"Popup menu for bundled server not found");
        }
        pointbasePopupMenu.pressKey(27);
        new QueueTool().waitEmpty();
        Util.wait(500);
        return result;
    }

    public static void stopPB() {
        JPopupMenuOperator pointbasePopupMenu = ServerNavigatorOperator.getTreeNodePopupMenu(Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.dataconnectivity.explorer.ideDb.Bundle", (String)"Bundled_DB_ServerNav_NodeName", (Object[])pbParams));
        if (pointbasePopupMenu != null) {
            pointbasePopupMenu.pushMenuNoBlock(Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.dataconnectivity.explorer.ideDb.Bundle", (String)"Bundled_DB_Stop", (Object[])pbParams));
            new QueueTool().waitEmpty();
            Util.wait(2000);
            System.out.println("Pointbase Database Server has been stopped.");
        }
        new QueueTool().waitEmpty();
        Util.wait(1000);
    }

    public static void startPB() {
        JPopupMenuOperator pointbasePopupMenu = ServerNavigatorOperator.getTreeNodePopupMenu(Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.dataconnectivity.explorer.ideDb.Bundle", (String)"Bundled_DB_ServerNav_NodeName", (Object[])pbParams));
        if (pointbasePopupMenu != null) {
            pointbasePopupMenu.pushMenuNoBlock(Bundle.getStringTrimmed((String)"org.netbeans.modules.visualweb.dataconnectivity.explorer.ideDb.Bundle", (String)"Bundled_DB_Start", (Object[])pbParams));
            new QueueTool().waitEmpty();
            Util.wait(2000);
            System.out.println("Pointbase Database Server has started.");
        }
        new QueueTool().waitEmpty();
        Util.wait(1000);
    }

    private static JTreeOperator selectTreeNode(String nodeName) {
        try {
            QueueTool queueTool = new QueueTool();
            queueTool.waitEmpty(100L);
            ServerNavigatorOperator serverExplorer = ServerNavigatorOperator.showNavigatorOperator();
            serverExplorer.makeComponentVisible();
            JTreeOperator tree = serverExplorer.getTree();
            tree.getTimeouts().setTimeout("JTreeOperator.WaitNodeExpandedTimeout", 60000L);
            tree.getTimeouts().setTimeout("JTreeOperator.WaitNextNodeTimeout", 60000L);
            tree.getTimeouts().setTimeout("JTreeOperator.WaitNodeVisibleTimeout", 60000L);
            TreePath serverNode = tree.findPath(nodeName);
            serverExplorer.getTree().selectPath(serverNode);
            queueTool.waitEmpty(100L);
            return tree;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static JPopupMenuOperator getTreeNodePopupMenu(String nodeName) {
        try {
            QueueTool queueTool = new QueueTool();
            JTreeOperator tree = ServerNavigatorOperator.selectTreeNode(nodeName);
            TreePath serverNode = tree.findPath(nodeName);
            queueTool.waitEmpty(100L);
            JPopupMenuOperator popupMenu = new JPopupMenuOperator(tree.callPopupOnPath(serverNode));
            queueTool.waitEmpty(100L);
            Util.wait(100);
            return popupMenu;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

