/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import junit.framework.Test;
import org.netbeans.junit.NbTestCase;
import org.netbeans.modules.visualweb.gravy.TestProperties;

public class HttpTestCase
extends NbTestCase
implements Test {
    private WebConversation conversation = new WebConversation();
    private WebRequest request;
    private WebResponse response;
    private long waitTime = 10000L;
    private long waitDelta = 100L;
    TestProperties props = new TestProperties();

    public HttpTestCase(String testName) {
        super(testName);
    }

    public WebConversation initConversation() {
        this.getLog().println("Creating WebConversation");
        this.conversation = new WebConversation();
        return this.conversation;
    }

    public WebConversation getConversation() {
        return this.conversation;
    }

    public WebRequest initRequest(String path) {
        this.getLog().println("Creating request for \"" + path + "\"");
        this.request = new GetMethodWebRequest(path);
        return this.request;
    }

    public WebRequest getRequest() {
        return this.request;
    }

    public WebResponse getResponse() throws Exception {
        this.getLog().println("Getting response for " + this.request);
        Exception exc = null;
        long startTime = System.currentTimeMillis();
        do {
            try {
                this.response = this.conversation.getResponse(this.request);
            }
            catch (Exception e) {
                exc = e;
                Thread.sleep(this.waitDelta);
            }
        } while (exc != null && System.currentTimeMillis() - startTime < this.waitTime);
        if (exc != null) {
            System.out.println("WebRequest.getResponse() did not succed in 1 minute");
            System.out.println("Ended up with exception:");
            exc.printStackTrace();
            throw exc;
        }
        return this.response;
    }

    public WebResponse lastResponse() throws Exception {
        if (this.response == null) {
            return this.getResponse();
        }
        return this.response;
    }

    protected TestProperties getTestProperties() {
        return this.props;
    }
}

