/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.typemapping.cobol;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.exception.FormatException;
import it.imolinfo.jbi4cics.jbi.Messages;
import java.io.UnsupportedEncodingException;

public class StringMarshaller {
    private static final Logger LOG = LoggerFactory.getLogger(StringMarshaller.class);
    private static final Messages MESSAGES = Messages.getMessages(StringMarshaller.class);

    public static void marshallStringIntoBuffer(String value, byte[] buffer, int startingOffset, String codePage, int size, int justification, String padCharStr) throws FormatException {
        byte[] valueArray = null;
        try {
            valueArray = value.getBytes(codePage);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("CIC002116_Code_page_not_supported", codePage);
            throw new FormatException(MESSAGES.getString("CIC002116_Code_page_not_supported", codePage));
        }
        if (valueArray.length > size) {
            LOG.error("CIC002117_Size_error", value, size);
            throw new FormatException(MESSAGES.getString("CIC002117_Size_error", value, size));
        }
        if (valueArray.length < size && padCharStr != null) {
            byte[] padChar;
            try {
                padChar = padCharStr.getBytes(codePage);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("CIC002116_Code_page_not_supported", codePage);
                throw new FormatException(MESSAGES.getString("CIC002116_Code_page_not_supported", codePage));
            }
            switch (justification) {
                case 0: {
                    int padlength = size - valueArray.length;
                    byte[] padArray = new byte[padlength];
                    StringMarshaller.fillArray(padArray, padChar);
                    System.arraycopy(valueArray, 0, buffer, startingOffset, valueArray.length);
                    System.arraycopy(padArray, 0, buffer, startingOffset + valueArray.length, padArray.length);
                    break;
                }
                case 2: {
                    int padlengthl = (size - valueArray.length) / 2;
                    int padlengthr = (size - valueArray.length) / 2 + (size - valueArray.length) % 2;
                    byte[] padArrayl = new byte[padlengthl];
                    StringMarshaller.fillArray(padArrayl, padChar);
                    byte[] padArrayr = new byte[padlengthr];
                    StringMarshaller.fillArray(padArrayr, padChar);
                    System.arraycopy(padArrayl, 0, buffer, startingOffset, padArrayl.length);
                    System.arraycopy(valueArray, 0, buffer, startingOffset + padArrayl.length, valueArray.length);
                    System.arraycopy(padArrayr, 0, buffer, startingOffset + padArrayl.length + valueArray.length, padArrayr.length);
                    break;
                }
                case 1: {
                    int padlength = size - valueArray.length;
                    byte[] padArray = new byte[padlength];
                    StringMarshaller.fillArray(padArray, padChar);
                    System.arraycopy(padArray, 0, buffer, startingOffset, padArray.length);
                    System.arraycopy(valueArray, 0, buffer, startingOffset + padArray.length, valueArray.length);
                    break;
                }
                default: {
                    LOG.error("CIC002118_Error_code");
                    throw new FormatException(MESSAGES.getString("CIC002118_Error_code", new Object[0]));
                }
            }
        } else {
            System.arraycopy(valueArray, 0, buffer, startingOffset, valueArray.length);
        }
    }

    public static String unmarshallString(byte[] buffer, int startingOffset, String codePage, int size) throws FormatException {
        String result = null;
        try {
            result = new String(buffer, startingOffset, size, codePage);
        }
        catch (UnsupportedEncodingException exc) {
            LOG.error("CIC002116_Code_page_not_supported", codePage);
            throw new FormatException(MESSAGES.getString("CIC002116_Code_page_not_supported", codePage));
        }
        return result;
    }

    private static void fillArray(byte[] toBeFilled, byte[] filler) {
        for (int i = 0; i < toBeFilled.length; i += filler.length) {
            System.arraycopy(filler, 0, toBeFilled, i * filler.length, filler.length);
        }
    }
}

