/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.typemapping.cobol;

import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.exception.FormatException;
import it.imolinfo.jbi4cics.messageformat.commarea.CommareaBeanMappingDescriptor;
import it.imolinfo.jbi4cics.messageformat.commarea.CommareaFormatter;
import it.imolinfo.jbi4cics.service.ServiceContext;
import it.imolinfo.jbi4cics.typemapping.cobol.CobolType;
import it.imolinfo.jbi4cics.typemapping.cobol.CobolTypeDescriptor;
import it.imolinfo.jbi4cics.typemapping.cobol.IntegerMarshaller;
import it.imolinfo.jbi4cics.typemapping.cobol.PackedDecimalMarshaller;
import it.imolinfo.jbi4cics.typemapping.cobol.ZonedMarshaller;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class CobolFieldFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(CobolFieldFormatter.class);

    private CobolFieldFormatter() {
    }

    public static void format(Object value, byte[] buffer, CobolTypeDescriptor desc, int offset) throws FormatException {
        CobolType ct = desc.getType();
        if (ct == null) {
            LOG.error("CIC002102_Unrecognized_cobol_type", (Object)ct);
            throw new FormatException("CIC002102_Unrecognized_cobol_type", new Object[]{ct});
        }
        if (buffer.length - offset < desc.getBufferedLength()) {
            Object[] args = new Object[]{buffer.length, offset, desc.getBufferedLength()};
            LOG.error("CIC002103_Not_enough_space_writing_cobol_type", args);
            throw new FormatException("CIC002103_Not_enough_space", args);
        }
        ct.format(value, buffer, desc, offset);
    }

    static void formatOccurs(Object value, byte[] buffer, CobolTypeDescriptor desc, int offset) throws FormatException {
        boolean debug = LOG.isDebugEnabled();
        if (!(value instanceof Object[])) {
            Object[] args = new Object[]{value.getClass()};
            LOG.error("CIC002105_Array_not_found", args);
            throw new FormatException("CIC002105_Array_not_found", args);
        }
        Object[] valueArray = (Object[])value;
        if (valueArray.length > desc.getOccursSize()) {
            Object[] args = new Object[]{valueArray.length, desc.getOccursSize()};
            LOG.error("CIC002106_Array_size_not_allowed", args);
            throw new FormatException("CIC002106_Array_size_not_allowed", args);
        }
        for (int i = 0; i < valueArray.length; ++i) {
            CobolTypeDescriptor nestedDesc = new CobolTypeDescriptor();
            CommareaBeanMappingDescriptor nested = desc.getNestedCommarea();
            if (debug) {
                LOG.debug("buffer.length: " + buffer.length + " index i: " + i + " startingOffset: " + offset);
            }
            nestedDesc.setType(CobolType.NESTED_COMMAREA);
            nestedDesc.setNestedCommarea(nested);
            CobolFieldFormatter.formatNestedCommarea(valueArray[i], buffer, nestedDesc, offset);
            offset += nested.getBufferedLength();
        }
    }

    static void formatNestedCommarea(Object value, byte[] buffer, CobolTypeDescriptor desc, int offset) throws FormatException {
        ServiceContext ctx = new ServiceContext();
        ctx.setInputBean(value);
        ctx.setInputMappingDescriptor(desc.getNestedCommarea());
        new CommareaFormatter().mapInputBeanToInputMessage(ctx);
        System.arraycopy(ctx.getInputMessage(), 0, buffer, offset, desc.getBufferedLength());
    }

    static void formatInteger(Object value, byte[] buffer, CobolTypeDescriptor desc, int offset) throws FormatException {
        String valueToString;
        if (value instanceof Number) {
            valueToString = value.toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("numberValue.toString(): " + valueToString);
            }
        } else {
            Object[] args = new Object[]{value.getClass()};
            LOG.error("CIC002107_Number_not_found", args);
            throw new FormatException("CIC002107_Number_not_found", args);
        }
        BigInteger bigIntegerValue = new BigDecimal(valueToString).toBigIntegerExact();
        IntegerMarshaller.marshallInteger(bigIntegerValue, buffer, offset, desc.getBufferedLength(), desc.isBigEndian());
    }

    static void formatPackedDecimal(Object value, byte[] buffer, CobolTypeDescriptor desc, int offset) throws FormatException {
        String valueToString;
        if (value instanceof Number) {
            valueToString = value.toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("numberValue.toString(): " + valueToString);
            }
        } else {
            Object[] args = new Object[]{value.getClass()};
            LOG.error("CIC002107_Number_not_found", args);
            throw new FormatException("CIC002107_Number_not_found", args);
        }
        BigDecimal bigDecimalValue = new BigDecimal(valueToString);
        PackedDecimalMarshaller.marshallBigDecimal(bigDecimalValue, buffer, desc, offset);
    }

    static void formatZoned(Object value, byte[] buffer, CobolTypeDescriptor desc, int offset) throws FormatException {
        String valueToString;
        if (value instanceof Number) {
            valueToString = value.toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("numberValue.toString(): " + valueToString);
            }
        } else {
            Object[] args = new Object[]{value.getClass()};
            LOG.error("CIC002107_Number_not_found", args);
            throw new FormatException("CIC002107_Number_not_found", args);
        }
        BigDecimal bigDecimalValue = new BigDecimal(valueToString);
        ZonedMarshaller.marshallZoned(bigDecimalValue, buffer, offset, desc.getBufferedLength(), desc.isSigned(), desc.getVirtualDecimalPoint(), desc.getZonedSignFormat(), desc.getCodePage());
    }

    public static Object unformat(byte[] buffer, CobolTypeDescriptor desc, int offset) throws FormatException {
        CobolType cobolType = desc.getType();
        if (buffer.length - offset < desc.getBufferedLength()) {
            Object[] args = new Object[]{buffer.length, offset, desc.getBufferedLength()};
            LOG.error("CIC002108_Not_enough_space_reading_cobol_type", args);
            throw new FormatException("CIC002108_Not_enough_space_reading_cobol_type", args);
        }
        if (cobolType == null) {
            LOG.error("CIC002102_Unrecognized_cobol_type", (Object)cobolType);
            throw new FormatException("CIC002102_Unrecognized_cobol_type", new Object[]{cobolType});
        }
        return cobolType.unformat(buffer, desc, offset);
    }

    static Object unformatOccurs(byte[] buffer, CobolTypeDescriptor desc, int offset) throws FormatException {
        CommareaBeanMappingDescriptor nested = desc.getNestedCommarea();
        Object[] value = (Object[])Array.newInstance(nested.getBeanClass(), desc.getOccursSize());
        for (int i = 0; i < value.length; ++i) {
            CobolTypeDescriptor nestedDesc = new CobolTypeDescriptor();
            nestedDesc.setType(CobolType.NESTED_COMMAREA);
            nestedDesc.setNestedCommarea(nested);
            value[i] = CobolFieldFormatter.unformatNestedCommarea(buffer, nestedDesc, offset);
            offset += nested.getBufferedLength();
        }
        return value;
    }

    static Object unformatNestedCommarea(byte[] buffer, CobolTypeDescriptor desc, int offset) throws FormatException {
        ServiceContext ctx = new ServiceContext();
        byte[] outputMessage = new byte[desc.getBufferedLength()];
        System.arraycopy(buffer, offset, outputMessage, 0, outputMessage.length);
        ctx.setOutputMessage(outputMessage);
        ctx.setOutputMappingDescriptor(desc.getNestedCommarea());
        new CommareaFormatter().mapOutputMessageToOutputBean(ctx);
        return ctx.getOutputBean();
    }
}

