/*
 * Decompiled with CFR 0.152.
 */
package it.imolinfo.jbi4cics.jbi;

import antlr.ANTLRException;
import it.imolinfo.jbi4cics.Logger;
import it.imolinfo.jbi4cics.LoggerFactory;
import it.imolinfo.jbi4cics.commareaparser.CommareaLexer;
import it.imolinfo.jbi4cics.commareaparser.CommareaParser;
import it.imolinfo.jbi4cics.exception.FormatException;
import it.imolinfo.jbi4cics.exception.Jbi4cicsException;
import it.imolinfo.jbi4cics.exception.ParseException;
import it.imolinfo.jbi4cics.jbi.BCELClassLoader;
import it.imolinfo.jbi4cics.jbi.Jbi4cicsExchangeProcessor;
import it.imolinfo.jbi4cics.jbi.Jbi4cicsLifeCycle;
import it.imolinfo.jbi4cics.jbi.Messages;
import it.imolinfo.jbi4cics.messageformat.commarea.CommareaBeanMappingDescriptor;
import it.imolinfo.jbi4cics.webservices.descriptor.ServiceDescriptor;
import it.imolinfo.jbi4cics.webservices.runtime.ServiceCreator;
import it.imolinfo.jbi4cics.webservices.utils.generators.ServiceBeanGenerator;
import it.imolinfo.jbi4cics.webservices.utils.generators.ServiceInterfaceGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Collection;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.servicemix.common.ExchangeProcessor;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.service.Service;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class Jbi4cicsEndpoint
extends ProviderEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(Jbi4cicsEndpoint.class);
    private static final Messages MESSAGES = Messages.getMessages(Jbi4cicsEndpoint.class);
    private String codePage;
    private String copyCobolFileName;
    private String outputCopyCobolFileName;
    private String copyCobol;
    private String outputCopyCobol;
    private ServiceDescriptor serviceDescriptor;
    private Service xfireService;
    private ExchangeProcessor processor = new Jbi4cicsExchangeProcessor(this);

    public Service getXFireService() {
        return this.xfireService;
    }

    public void start() throws Exception {
        super.start();
        this.processor.start();
    }

    public void stop() throws Exception {
        super.stop();
        this.processor.stop();
    }

    void registerService() throws Jbi4cicsException, IOException, ANTLRException, SAXException, ParserConfigurationException, WSDLException, TransformerException {
        XFire xfire = this.getXFire();
        this.createServiceBeansAndInterface();
        if (this.definition != null) {
            LOG.debug("Using WSDL definition to load endpoint data");
            this.service = new QName(this.serviceDescriptor.getServiceNameSpace(), this.serviceDescriptor.getServiceName());
            Port port = this.initEndpointIfIsNull(this.definition.getService(this.service));
            this.checkEndpointIsNotNull();
            this.interfaceName = port.getBinding().getPortType().getQName();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loaded endpoint data, service: " + this.service + ", endpoint: " + this.endpoint + ", interface:" + this.interfaceName);
            }
        }
        this.xfireService = new ServiceCreator().createJbiService(this.serviceDescriptor, xfire, this.interfaceName);
        xfire.getServiceRegistry().register(this.xfireService);
        if (this.definition == null) {
            this.description = this.generateWsdl();
            QName serviceQName = this.xfireService.getName();
            QName interfaceQName = this.xfireService.getServiceInfo().getPortType();
            if (this.service == null) {
                this.service = serviceQName;
            } else if (!this.service.equals(serviceQName)) {
                LOG.warn("CIC001018_Service_name_not_matched", serviceQName, this.service);
            }
            if (this.interfaceName == null) {
                this.interfaceName = interfaceQName;
            } else if (!this.interfaceName.equals(interfaceQName)) {
                LOG.warn("CIC001019_Interface_name_not_matched", interfaceQName, this.interfaceName);
            }
            Definition def = WSDLFactory.newInstance().newWSDLReader().readWSDL(null, this.description);
            javax.wsdl.Service wsdlService = def.getService(serviceQName);
            if (wsdlService != null) {
                this.initEndpointIfIsNull(wsdlService);
            }
            this.checkEndpointIsNotNull();
        }
        this.writeWsdlToFile();
    }

    private void createServiceBeansAndInterface() throws Jbi4cicsException, ANTLRException {
        BCELClassLoader classLoader = ((Jbi4cicsLifeCycle)this.serviceUnit.getComponent().getLifeCycle()).getBCELClassLoader();
        if (this.serviceDescriptor.getServiceName() == null) {
            throw new Jbi4cicsException("CIC001013_Service_name_not_initialized");
        }
        this.serviceDescriptor.setDefaultValuesIfNecessary();
        CommareaBeanMappingDescriptor descriptor = this.parseCommarea(this.copyCobol);
        this.serviceDescriptor.setInputMappingDescriptor(descriptor);
        if (this.outputCopyCobol != null && this.outputCopyCobol.length() > 0 && !this.outputCopyCobol.equals(this.copyCobol)) {
            descriptor = this.parseCommarea(this.outputCopyCobol);
        }
        this.serviceDescriptor.setOutputMappingDescriptor(descriptor);
        ServiceBeanGenerator beanGenerator = new ServiceBeanGenerator(this.serviceDescriptor, true);
        beanGenerator.generateBeanClass(classLoader);
        beanGenerator = new ServiceBeanGenerator(this.serviceDescriptor, false);
        beanGenerator.generateBeanClass(classLoader);
        ServiceInterfaceGenerator interfGenerator = new ServiceInterfaceGenerator(this.serviceDescriptor);
        interfGenerator.generateServiceInterface(classLoader);
        this.serviceDescriptor.setCodePage(this.codePage);
    }

    CommareaBeanMappingDescriptor parseCommarea(String cpyCobol) throws ANTLRException, FormatException, ParseException {
        CommareaLexer lexer = new CommareaLexer(new StringReader(this.copyCobol));
        CommareaParser parser = new CommareaParser(lexer);
        CommareaBeanMappingDescriptor desc = parser.commarea_definition();
        LOG.info("CIC001014_Commarea_parsed", this.getEndpoint(), desc);
        return desc;
    }

    private Port initEndpointIfIsNull(javax.wsdl.Service wsdlService) {
        Collection ports = wsdlService.getPorts().values();
        Port port = null;
        if (ports.size() == 1) {
            port = (Port)ports.iterator().next();
            if (this.endpoint == null) {
                this.endpoint = port.getName();
            } else if (!this.endpoint.equals(port.getName())) {
                LOG.warn("CIC001016_Endpoint_name_not_matched", port.getName(), this.endpoint);
            }
        }
        return port;
    }

    private void checkEndpointIsNotNull() {
        if (this.endpoint == null) {
            throw new IllegalArgumentException(MESSAGES.getString("CIC001017_Endpoint_name_not_provided", new Object[0]));
        }
    }

    private Document generateWsdl() throws SAXException, IOException, ParserConfigurationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.getXFire().generateWSDL(this.xfireService.getSimpleName(), (OutputStream)baos);
        if (LOG.isDebugEnabled()) {
            LOG.debug(baos.toString());
        }
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder().parse(new ByteArrayInputStream(baos.toByteArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeWsdlToFile() throws IOException, TransformerException, SAXException, ParserConfigurationException {
        String wsdlFileName = this.getServiceUnit().getRootPath() + "/" + this.xfireService.getSimpleName() + ".wsdl";
        LOG.info("CIC001020_Producing_wsdl", wsdlFileName);
        FileWriter file = new FileWriter(wsdlFileName);
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transormer = factory.newTransformer();
            transormer.transform(new DOMSource(this.generateWsdl()), new StreamResult(file));
        }
        finally {
            file.close();
        }
    }

    XFire getXFire() {
        Jbi4cicsLifeCycle lifeCycle = (Jbi4cicsLifeCycle)this.serviceUnit.getComponent().getLifeCycle();
        return lifeCycle.getXFire();
    }

    public ExchangeProcessor getProcessor() {
        return this.processor;
    }

    public String getCopyCobol() {
        return this.copyCobol;
    }

    public void setCopyCobol(String copyCobol) {
        this.copyCobol = copyCobol;
    }

    public String getOutputCopyCobol() {
        return this.outputCopyCobol;
    }

    public void setOutputCopyCobol(String outputCopyCobol) {
        this.outputCopyCobol = outputCopyCobol;
    }

    public ServiceDescriptor getServiceDescriptor() {
        return this.serviceDescriptor;
    }

    public void setServiceDescriptor(ServiceDescriptor serviceDescriptor) {
        this.serviceDescriptor = serviceDescriptor;
    }

    public String getCopyCobolFileName() {
        return this.copyCobolFileName;
    }

    public void setCopyCobolFileName(String copyCobolFileName) {
        this.copyCobolFileName = copyCobolFileName;
    }

    public String getOutputCopyCobolFileName() {
        return this.outputCopyCobolFileName;
    }

    public void setOutputCopyCobolFileName(String outputCopyCobolFileName) {
        this.outputCopyCobolFileName = outputCopyCobolFileName;
    }

    public String getCodePage() {
        return this.codePage;
    }

    public void setCodePage(String codePage) {
        this.codePage = codePage;
    }
}

