/*
 * Decompiled with CFR 0.152.
 */
package prefuse.visual.tuple;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import prefuse.Visualization;
import prefuse.data.Graph;
import prefuse.data.Table;
import prefuse.data.Tuple;
import prefuse.data.tuple.TableTuple;
import prefuse.data.tuple.TupleSet;
import prefuse.render.Renderer;
import prefuse.visual.VisualItem;
import prefuse.visual.VisualTable;

public class TableVisualItem
extends TableTuple
implements VisualItem {
    protected void init(Table table, Graph graph, int row) {
        this.m_table = table;
        this.m_row = this.m_table.isValidRow(row) ? row : -1;
    }

    public Visualization getVisualization() {
        return ((VisualTable)this.m_table).getVisualization();
    }

    public String getGroup() {
        return ((VisualTable)this.m_table).getGroup();
    }

    public boolean isInGroup(String group) {
        return this.getVisualization().isInGroup(this, group);
    }

    public TupleSet getSourceData() {
        VisualTable vt = (VisualTable)this.m_table;
        return vt.getVisualization().getSourceData(vt.getGroup());
    }

    public Tuple getSourceTuple() {
        VisualTable vt = (VisualTable)this.m_table;
        return vt.getVisualization().getSourceTuple(this);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("VisualItem[").append(this.getGroup());
        sbuf.append(",").append(this.m_row).append(',');
        VisualTable vt = (VisualTable)this.m_table;
        int local = vt.getLocalColumnCount();
        int inherited = vt.getColumnCount() - local;
        for (int i = 0; i < inherited; ++i) {
            if (i > 0) {
                sbuf.append(',');
            }
            String name = vt.getColumnName(local + i);
            sbuf.append(name);
            sbuf.append('=');
            if (vt.canGetString(name)) {
                sbuf.append(vt.getString(this.m_row, name));
                continue;
            }
            sbuf.append(vt.get(this.m_row, name).toString());
        }
        sbuf.append(']');
        return sbuf.toString();
    }

    public void render(Graphics2D g) {
        this.getRenderer().render(g, this);
    }

    public Renderer getRenderer() {
        return this.getVisualization().getRenderer(this);
    }

    public Rectangle2D validateBounds() {
        if (this.isValidated()) {
            return this.getBounds();
        }
        Visualization v = this.getVisualization();
        this.getRenderer().setBounds(this);
        this.setValidated(true);
        Rectangle2D bounds = this.getBounds();
        v.damageReport(this, bounds);
        return bounds;
    }

    public boolean isValidated() {
        return ((VisualTable)this.m_table).isValidated(this.m_row);
    }

    public void setValidated(boolean value) {
        ((VisualTable)this.m_table).setValidated(this.m_row, value);
    }

    public boolean isVisible() {
        return ((VisualTable)this.m_table).isVisible(this.m_row);
    }

    public void setVisible(boolean value) {
        ((VisualTable)this.m_table).setVisible(this.m_row, value);
    }

    public boolean isStartVisible() {
        return ((VisualTable)this.m_table).isStartVisible(this.m_row);
    }

    public void setStartVisible(boolean value) {
        ((VisualTable)this.m_table).setStartVisible(this.m_row, value);
    }

    public boolean isEndVisible() {
        return ((VisualTable)this.m_table).isEndVisible(this.m_row);
    }

    public void setEndVisible(boolean value) {
        ((VisualTable)this.m_table).setEndVisible(this.m_row, value);
    }

    public boolean isInteractive() {
        return ((VisualTable)this.m_table).isInteractive(this.m_row);
    }

    public void setInteractive(boolean value) {
        ((VisualTable)this.m_table).setInteractive(this.m_row, value);
    }

    public boolean isExpanded() {
        return ((VisualTable)this.m_table).isExpanded(this.m_row);
    }

    public void setExpanded(boolean value) {
        ((VisualTable)this.m_table).setExpanded(this.m_row, value);
    }

    public boolean isFixed() {
        return ((VisualTable)this.m_table).isFixed(this.m_row);
    }

    public void setFixed(boolean value) {
        ((VisualTable)this.m_table).setFixed(this.m_row, value);
    }

    public boolean isHighlighted() {
        return ((VisualTable)this.m_table).isHighlighted(this.m_row);
    }

    public void setHighlighted(boolean value) {
        ((VisualTable)this.m_table).setHighlighted(this.m_row, value);
    }

    public boolean isHover() {
        return ((VisualTable)this.m_table).isHover(this.m_row);
    }

    public void setHover(boolean value) {
        ((VisualTable)this.m_table).setHover(this.m_row, value);
    }

    public double getX() {
        return ((VisualTable)this.m_table).getX(this.m_row);
    }

    public void setX(double x) {
        ((VisualTable)this.m_table).setX(this.m_row, x);
    }

    public double getY() {
        return ((VisualTable)this.m_table).getY(this.m_row);
    }

    public void setY(double y) {
        ((VisualTable)this.m_table).setY(this.m_row, y);
    }

    public double getStartX() {
        return ((VisualTable)this.m_table).getStartX(this.m_row);
    }

    public void setStartX(double x) {
        ((VisualTable)this.m_table).setStartX(this.m_row, x);
    }

    public double getStartY() {
        return ((VisualTable)this.m_table).getStartY(this.m_row);
    }

    public void setStartY(double y) {
        ((VisualTable)this.m_table).setStartY(this.m_row, y);
    }

    public double getEndX() {
        return ((VisualTable)this.m_table).getEndX(this.m_row);
    }

    public void setEndX(double x) {
        ((VisualTable)this.m_table).setEndX(this.m_row, x);
    }

    public double getEndY() {
        return ((VisualTable)this.m_table).getEndY(this.m_row);
    }

    public void setEndY(double y) {
        ((VisualTable)this.m_table).setEndY(this.m_row, y);
    }

    public Rectangle2D getBounds() {
        if (!this.isValidated()) {
            return this.validateBounds();
        }
        return ((VisualTable)this.m_table).getBounds(this.m_row);
    }

    public void setBounds(double x, double y, double w, double h) {
        ((VisualTable)this.m_table).setBounds(this.m_row, x, y, w, h);
    }

    public int getStrokeColor() {
        return ((VisualTable)this.m_table).getStrokeColor(this.m_row);
    }

    public void setStrokeColor(int color) {
        ((VisualTable)this.m_table).setStrokeColor(this.m_row, color);
    }

    public int getStartStrokeColor() {
        return ((VisualTable)this.m_table).getStartStrokeColor(this.m_row);
    }

    public void setStartStrokeColor(int color) {
        ((VisualTable)this.m_table).setStartStrokeColor(this.m_row, color);
    }

    public int getEndStrokeColor() {
        return ((VisualTable)this.m_table).getEndStrokeColor(this.m_row);
    }

    public void setEndStrokeColor(int color) {
        ((VisualTable)this.m_table).setEndStrokeColor(this.m_row, color);
    }

    public int getFillColor() {
        return ((VisualTable)this.m_table).getFillColor(this.m_row);
    }

    public void setFillColor(int color) {
        ((VisualTable)this.m_table).setFillColor(this.m_row, color);
    }

    public int getStartFillColor() {
        return ((VisualTable)this.m_table).getStartFillColor(this.m_row);
    }

    public void setStartFillColor(int color) {
        ((VisualTable)this.m_table).setStartFillColor(this.m_row, color);
    }

    public int getEndFillColor() {
        return ((VisualTable)this.m_table).getEndFillColor(this.m_row);
    }

    public void setEndFillColor(int color) {
        ((VisualTable)this.m_table).setEndFillColor(this.m_row, color);
    }

    public int getTextColor() {
        return ((VisualTable)this.m_table).getTextColor(this.m_row);
    }

    public void setTextColor(int color) {
        ((VisualTable)this.m_table).setTextColor(this.m_row, color);
    }

    public int getStartTextColor() {
        return ((VisualTable)this.m_table).getStartTextColor(this.m_row);
    }

    public void setStartTextColor(int color) {
        ((VisualTable)this.m_table).setStartTextColor(this.m_row, color);
    }

    public int getEndTextColor() {
        return ((VisualTable)this.m_table).getEndTextColor(this.m_row);
    }

    public void setEndTextColor(int color) {
        ((VisualTable)this.m_table).setEndTextColor(this.m_row, color);
    }

    public double getSize() {
        return ((VisualTable)this.m_table).getSize(this.m_row);
    }

    public void setSize(double size) {
        ((VisualTable)this.m_table).setSize(this.m_row, size);
    }

    public double getStartSize() {
        return ((VisualTable)this.m_table).getStartSize(this.m_row);
    }

    public void setStartSize(double size) {
        ((VisualTable)this.m_table).setStartSize(this.m_row, size);
    }

    public double getEndSize() {
        return ((VisualTable)this.m_table).getEndSize(this.m_row);
    }

    public void setEndSize(double size) {
        ((VisualTable)this.m_table).setEndSize(this.m_row, size);
    }

    public int getShape() {
        return ((VisualTable)this.m_table).getShape(this.m_row);
    }

    public void setShape(int shape) {
        ((VisualTable)this.m_table).setShape(this.m_row, shape);
    }

    public BasicStroke getStroke() {
        return ((VisualTable)this.m_table).getStroke(this.m_row);
    }

    public void setStroke(BasicStroke stroke) {
        ((VisualTable)this.m_table).setStroke(this.m_row, stroke);
    }

    public Font getFont() {
        return ((VisualTable)this.m_table).getFont(this.m_row);
    }

    public void setFont(Font font) {
        ((VisualTable)this.m_table).setFont(this.m_row, font);
    }

    public Font getStartFont() {
        return ((VisualTable)this.m_table).getStartFont(this.m_row);
    }

    public void setStartFont(Font font) {
        ((VisualTable)this.m_table).setStartFont(this.m_row, font);
    }

    public Font getEndFont() {
        return ((VisualTable)this.m_table).getEndFont(this.m_row);
    }

    public void setEndFont(Font font) {
        ((VisualTable)this.m_table).setEndFont(this.m_row, font);
    }

    public double getDOI() {
        return ((VisualTable)this.m_table).getDOI(this.m_row);
    }

    public void setDOI(double doi) {
        ((VisualTable)this.m_table).setDOI(this.m_row, doi);
    }
}

