/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import prefuse.util.ArrayLib;
import prefuse.util.ColorLib;
import prefuse.visual.VisualItem;

public class GraphicsLib {
    public static final int NO_INTERSECTION = 0;
    public static final int COINCIDENT = -1;
    public static final int PARALLEL = -2;

    public static int intersectLineLine(Line2D a, Line2D b, Point2D intersect) {
        double a1x = a.getX1();
        double a1y = a.getY1();
        double a2x = a.getX2();
        double a2y = a.getY2();
        double b1x = b.getX1();
        double b1y = b.getY1();
        double b2x = b.getX2();
        double b2y = b.getY2();
        return GraphicsLib.intersectLineLine(a1x, a1y, a2x, a2y, b1x, b1y, b2x, b2y, intersect);
    }

    public static int intersectLineLine(double a1x, double a1y, double a2x, double a2y, double b1x, double b1y, double b2x, double b2y, Point2D intersect) {
        double ua_t = (b2x - b1x) * (a1y - b1y) - (b2y - b1y) * (a1x - b1x);
        double ub_t = (a2x - a1x) * (a1y - b1y) - (a2y - a1y) * (a1x - b1x);
        double u_b = (b2y - b1y) * (a2x - a1x) - (b2x - b1x) * (a2y - a1y);
        if (u_b != 0.0) {
            double ua = ua_t / u_b;
            double ub = ub_t / u_b;
            if (0.0 <= ua && ua <= 1.0 && 0.0 <= ub && ub <= 1.0) {
                intersect.setLocation(a1x + ua * (a2x - a1x), a1y + ua * (a2y - a1y));
                return 1;
            }
            return 0;
        }
        return ua_t == 0.0 || ub_t == 0.0 ? -1 : -2;
    }

    public static int intersectLineRectangle(Point2D a1, Point2D a2, Rectangle2D r, Point2D[] pts) {
        int i;
        double a1x = a1.getX();
        double a1y = a1.getY();
        double a2x = a2.getX();
        double a2y = a2.getY();
        double mxx = r.getMaxX();
        double mxy = r.getMaxY();
        double mnx = r.getMinX();
        double mny = r.getMinY();
        if (pts[0] == null) {
            pts[0] = new Point2D.Double();
        }
        if (pts[1] == null) {
            pts[1] = new Point2D.Double();
        }
        if (GraphicsLib.intersectLineLine(mnx, mny, mxx, mny, a1x, a1y, a2x, a2y, pts[i = 0]) > 0) {
            ++i;
        }
        if (GraphicsLib.intersectLineLine(mxx, mny, mxx, mxy, a1x, a1y, a2x, a2y, pts[i]) > 0) {
            ++i;
        }
        if (i == 2) {
            return i;
        }
        if (GraphicsLib.intersectLineLine(mxx, mxy, mnx, mxy, a1x, a1y, a2x, a2y, pts[i]) > 0) {
            ++i;
        }
        if (i == 2) {
            return i;
        }
        if (GraphicsLib.intersectLineLine(mnx, mxy, mnx, mny, a1x, a1y, a2x, a2y, pts[i]) > 0) {
            ++i;
        }
        return i;
    }

    public static int intersectLineRectangle(Line2D l, Rectangle2D r, Point2D[] pts) {
        int i;
        double a1x = l.getX1();
        double a1y = l.getY1();
        double a2x = l.getX2();
        double a2y = l.getY2();
        double mxx = r.getMaxX();
        double mxy = r.getMaxY();
        double mnx = r.getMinX();
        double mny = r.getMinY();
        if (pts[0] == null) {
            pts[0] = new Point2D.Double();
        }
        if (pts[1] == null) {
            pts[1] = new Point2D.Double();
        }
        if (GraphicsLib.intersectLineLine(mnx, mny, mxx, mny, a1x, a1y, a2x, a2y, pts[i = 0]) > 0) {
            ++i;
        }
        if (GraphicsLib.intersectLineLine(mxx, mny, mxx, mxy, a1x, a1y, a2x, a2y, pts[i]) > 0) {
            ++i;
        }
        if (i == 2) {
            return i;
        }
        if (GraphicsLib.intersectLineLine(mxx, mxy, mnx, mxy, a1x, a1y, a2x, a2y, pts[i]) > 0) {
            ++i;
        }
        if (i == 2) {
            return i;
        }
        if (GraphicsLib.intersectLineLine(mnx, mxy, mnx, mny, a1x, a1y, a2x, a2y, pts[i]) > 0) {
            ++i;
        }
        return i;
    }

    public static double[] convexHull(double[] pts, int len) {
        if (len < 6) {
            throw new IllegalArgumentException("Input must have at least 3 points");
        }
        int plen = len / 2 - 1;
        float[] angles = new float[plen];
        int[] idx = new int[plen];
        int[] stack = new int[len / 2];
        return GraphicsLib.convexHull(pts, len, angles, idx, stack);
    }

    public static double[] convexHull(double[] pts, int len, float[] angles, int[] idx, int[] stack) {
        int j;
        int i;
        int plen = len / 2 - 1;
        if (len < 6) {
            throw new IllegalArgumentException("Input must have at least 3 points");
        }
        if (angles.length < plen || idx.length < plen || stack.length < len / 2) {
            throw new IllegalArgumentException("Pre-allocated data structure too small");
        }
        int i0 = 0;
        for (i = 2; i < len; i += 2) {
            if (pts[i + 1] < pts[i0 + 1]) {
                i0 = i;
                continue;
            }
            if (pts[i + 1] != pts[i0 + 1]) continue;
            i0 = pts[i] < pts[i0] ? i : i0;
        }
        int j2 = 0;
        for (i = 0; i < len; i += 2) {
            if (i == i0) continue;
            angles[j2] = (float)Math.atan2(pts[i + 1] - pts[i0 + 1], pts[i] - pts[i0]);
            idx[j2++] = i;
        }
        ArrayLib.sort(angles, idx, plen);
        float angle = angles[0];
        int ti = 0;
        int tj = idx[0];
        for (int i2 = 1; i2 < plen; ++i2) {
            j = idx[i2];
            if (angle == angles[i2]) {
                double x1 = pts[tj] - pts[i0];
                double y1 = pts[tj + 1] - pts[i0 + 1];
                double d1 = x1 * x1 + y1 * y1;
                double x2 = pts[j] - pts[i0];
                double y2 = pts[j + 1] - pts[i0 + 1];
                double d2 = x2 * x2 + y2 * y2;
                if (d1 >= d2) {
                    idx[i2] = -1;
                    continue;
                }
                idx[ti] = -1;
                angle = angles[i2];
                ti = i2;
                tj = j;
                continue;
            }
            angle = angles[i2];
            ti = i2;
            tj = j;
        }
        int sp = 0;
        stack[sp++] = i0;
        j = 0;
        int k = 0;
        while (k < 2) {
            if (idx[j] != -1) {
                stack[sp++] = idx[j];
                ++k;
            }
            ++j;
        }
        while (j < plen) {
            if (idx[j] != -1) {
                while (GraphicsLib.isNonLeft(i0, stack[sp - 2], stack[sp - 1], idx[j], pts)) {
                    --sp;
                }
                stack[sp++] = idx[j];
            }
            ++j;
        }
        double[] hull = new double[2 * sp];
        for (int i3 = 0; i3 < sp; ++i3) {
            hull[2 * i3] = pts[stack[i3]];
            hull[2 * i3 + 1] = pts[stack[i3] + 1];
        }
        return hull;
    }

    private static boolean isNonLeft(int i0, int i1, int i2, int i3, double[] pts) {
        double angle2;
        double l1 = Math.sqrt(Math.pow(pts[i2 + 1] - pts[i1 + 1], 2.0) + Math.pow(pts[i2] - pts[i1], 2.0));
        double l2 = Math.sqrt(Math.pow(pts[i3 + 1] - pts[i2 + 1], 2.0) + Math.pow(pts[i3] - pts[i2], 2.0));
        double l4 = Math.sqrt(Math.pow(pts[i3 + 1] - pts[i0 + 1], 2.0) + Math.pow(pts[i3] - pts[i0], 2.0));
        double l5 = Math.sqrt(Math.pow(pts[i1 + 1] - pts[i0 + 1], 2.0) + Math.pow(pts[i1] - pts[i0], 2.0));
        double l6 = Math.sqrt(Math.pow(pts[i2 + 1] - pts[i0 + 1], 2.0) + Math.pow(pts[i2] - pts[i0], 2.0));
        double angle1 = Math.acos((l2 * l2 + l6 * l6 - l4 * l4) / (2.0 * l2 * l6));
        double angle = Math.PI - angle1 - (angle2 = Math.acos((l6 * l6 + l1 * l1 - l5 * l5) / (2.0 * l6 * l1)));
        return angle <= 0.0;
    }

    public static float[] centroid(float[] pts, int len) {
        float[] c = new float[]{0.0f, 0.0f};
        for (int i = 0; i < len; i += 2) {
            c[0] = c[0] + pts[i];
            c[1] = c[1] + pts[i + 1];
        }
        c[0] = c[0] / (float)(len / 2);
        c[1] = c[1] / (float)(len / 2);
        return c;
    }

    public static void growPolygon(float[] pts, int len, float amt) {
        float[] c = GraphicsLib.centroid(pts, len);
        for (int i = 0; i < len; i += 2) {
            float vx = pts[i] - c[0];
            float vy = pts[i + 1] - c[1];
            float norm = (float)Math.sqrt(vx * vx + vy * vy);
            int n = i;
            pts[n] = pts[n] + amt * vx / norm;
            int n2 = i + 1;
            pts[n2] = pts[n2] + amt * vy / norm;
        }
    }

    public static GeneralPath cardinalSpline(float[] pts, float slack, boolean closed) {
        GeneralPath path = new GeneralPath();
        path.moveTo(pts[0], pts[1]);
        return GraphicsLib.cardinalSpline(path, pts, slack, closed, 0.0f, 0.0f);
    }

    public static GeneralPath cardinalSpline(float[] pts, int start, int npoints, float slack, boolean closed) {
        GeneralPath path = new GeneralPath();
        path.moveTo(pts[start], pts[start + 1]);
        return GraphicsLib.cardinalSpline(path, pts, start, npoints, slack, closed, 0.0f, 0.0f);
    }

    public static GeneralPath cardinalSpline(GeneralPath p, float[] pts, float slack, boolean closed, float tx, float ty) {
        int npoints;
        for (npoints = 0; npoints < pts.length && !Float.isNaN(pts[npoints]); ++npoints) {
        }
        return GraphicsLib.cardinalSpline(p, pts, 0, npoints / 2, slack, closed, tx, ty);
    }

    public static GeneralPath cardinalSpline(GeneralPath p, float[] pts, int start, int npoints, float slack, boolean closed, float tx, float ty) {
        float dy1;
        float dx1;
        int i;
        float dy2;
        float dx2;
        int len = 2 * npoints;
        int end = start + len;
        if (len < 6) {
            throw new IllegalArgumentException("To create spline requires at least 3 points");
        }
        if (closed) {
            dx2 = pts[start + 2] - pts[end - 2];
            dy2 = pts[start + 3] - pts[end - 1];
        } else {
            dx2 = pts[start + 4] - pts[start];
            dy2 = pts[start + 5] - pts[start + 1];
        }
        for (i = start + 2; i < end - 2; i += 2) {
            dx1 = dx2;
            dy1 = dy2;
            dx2 = pts[i + 2] - pts[i - 2];
            dy2 = pts[i + 3] - pts[i - 1];
            p.curveTo(tx + pts[i - 2] + slack * dx1, ty + pts[i - 1] + slack * dy1, tx + pts[i] - slack * dx2, ty + pts[i + 1] - slack * dy2, tx + pts[i], ty + pts[i + 1]);
        }
        if (closed) {
            dx1 = dx2;
            dy1 = dy2;
            dx2 = pts[start] - pts[i - 2];
            dy2 = pts[start + 1] - pts[i - 1];
            p.curveTo(tx + pts[i - 2] + slack * dx1, ty + pts[i - 1] + slack * dy1, tx + pts[i] - slack * dx2, ty + pts[i + 1] - slack * dy2, tx + pts[i], ty + pts[i + 1]);
            dx1 = dx2;
            dy1 = dy2;
            dx2 = pts[start + 2] - pts[end - 2];
            dy2 = pts[start + 3] - pts[end - 1];
            p.curveTo(tx + pts[end - 2] + slack * dx1, ty + pts[end - 1] + slack * dy1, tx + pts[0] - slack * dx2, ty + pts[1] - slack * dy2, tx + pts[0], ty + pts[1]);
            p.closePath();
        } else {
            p.curveTo(tx + pts[i - 2] + slack * dx2, ty + pts[i - 1] + slack * dy2, tx + pts[i] - slack * dx2, ty + pts[i + 1] - slack * dy2, tx + pts[i], ty + pts[i + 1]);
        }
        return p;
    }

    public static GeneralPath stackSpline(GeneralPath p, float[] pts, float epsilon, float slack, boolean closed, float tx, float ty) {
        int npoints;
        for (npoints = 0; npoints < pts.length && !Float.isNaN(pts[npoints]); ++npoints) {
        }
        return GraphicsLib.stackSpline(p, pts, 0, npoints / 2, epsilon, slack, closed, tx, ty);
    }

    public static GeneralPath stackSpline(GeneralPath p, float[] pts, int start, int npoints, float epsilon, float slack, boolean closed, float tx, float ty) {
        float dy1;
        float dx1;
        int i;
        float dy2;
        float dx2;
        int len = 2 * npoints;
        int end = start + len;
        if (len < 6) {
            throw new IllegalArgumentException("To create spline requires at least 3 points");
        }
        if (closed) {
            dx2 = pts[start + 2] - pts[end - 2];
            dy2 = pts[start + 3] - pts[end - 1];
        } else {
            dx2 = pts[start + 4] - pts[start];
            dy2 = pts[start + 5] - pts[start + 1];
        }
        for (i = start + 2; i < end - 2; i += 2) {
            dx1 = dx2;
            dy1 = dy2;
            dx2 = pts[i + 2] - pts[i - 2];
            dy2 = pts[i + 3] - pts[i - 1];
            if (Math.abs(pts[i] - pts[i - 2]) < epsilon || Math.abs(pts[i + 1] - pts[i - 1]) < epsilon) {
                p.lineTo(tx + pts[i], ty + pts[i + 1]);
                continue;
            }
            p.curveTo(tx + pts[i - 2] + slack * dx1, ty + pts[i - 1] + slack * dy1, tx + pts[i] - slack * dx2, ty + pts[i + 1] - slack * dy2, tx + pts[i], ty + pts[i + 1]);
        }
        dx1 = dx2;
        dy1 = dy2;
        dx2 = pts[start] - pts[i - 2];
        dy2 = pts[start + 1] - pts[i - 1];
        if (Math.abs(pts[i] - pts[i - 2]) < epsilon || Math.abs(pts[i + 1] - pts[i - 1]) < epsilon) {
            p.lineTo(tx + pts[i], ty + pts[i + 1]);
        } else {
            p.curveTo(tx + pts[i - 2] + slack * dx1, ty + pts[i - 1] + slack * dy1, tx + pts[i] - slack * dx2, ty + pts[i + 1] - slack * dy2, tx + pts[i], ty + pts[i + 1]);
        }
        if (closed) {
            if (Math.abs(pts[end - 2] - pts[0]) < epsilon || Math.abs(pts[end - 1] - pts[1]) < epsilon) {
                p.lineTo(tx + pts[0], ty + pts[1]);
            } else {
                dx1 = dx2;
                dy1 = dy2;
                dx2 = pts[start + 2] - pts[end - 2];
                dy2 = pts[start + 3] - pts[end - 1];
                p.curveTo(tx + pts[end - 2] + slack * dx1, ty + pts[end - 1] + slack * dy1, tx + pts[0] - slack * dx2, ty + pts[1] - slack * dy2, tx + pts[0], ty + pts[1]);
            }
            p.closePath();
        }
        return p;
    }

    public static void expand(Rectangle2D r, double amount) {
        r.setRect(r.getX() - amount, r.getY() - amount, r.getWidth() + 2.0 * amount, r.getHeight() + 2.0 * amount);
    }

    public static void setBounds(VisualItem item, Shape shape, BasicStroke stroke) {
        double lw;
        double h;
        double w;
        double y;
        double x;
        if (shape instanceof RectangularShape) {
            RectangularShape r = (RectangularShape)shape;
            x = r.getX();
            y = r.getY();
            w = r.getWidth();
            h = r.getHeight();
        } else if (shape instanceof Line2D) {
            Line2D l = (Line2D)shape;
            x = l.getX1();
            y = l.getY1();
            w = l.getX2();
            h = l.getY2();
            if (w < x) {
                lw = x;
                x = w;
                w = lw - x;
            } else {
                w -= x;
            }
            if (h < y) {
                lw = y;
                y = h;
                h = lw - y;
            } else {
                h -= y;
            }
        } else {
            Rectangle2D r = shape.getBounds2D();
            x = r.getX();
            y = r.getY();
            w = r.getWidth();
            h = r.getHeight();
        }
        if (stroke != null) {
            double d;
            lw = stroke.getLineWidth();
            if (d > 1.0) {
                double lw2 = lw / 2.0;
                x -= lw2;
                y -= lw2;
                w += lw;
                h += lw;
            }
        }
        item.setBounds(x, y, w, h);
    }

    public static void paint(Graphics2D g, VisualItem item, Shape shape, BasicStroke stroke, int type) {
        AffineTransform at;
        double scale;
        boolean fdraw;
        if (type == 0) {
            return;
        }
        Color strokeColor = ColorLib.getColor(item.getStrokeColor());
        Color fillColor = ColorLib.getColor(item.getFillColor());
        boolean sdraw = (type == 1 || type == 3) && strokeColor.getAlpha() != 0;
        boolean bl = fdraw = (type == 2 || type == 3) && fillColor.getAlpha() != 0;
        if (!sdraw && !fdraw) {
            return;
        }
        Stroke origStroke = null;
        if (sdraw) {
            origStroke = g.getStroke();
            g.setStroke(stroke);
        }
        if ((scale = Math.max((at = g.getTransform()).getScaleX(), at.getScaleY())) > 1.5) {
            if (fdraw) {
                g.setPaint(fillColor);
                g.fill(shape);
            }
            if (sdraw) {
                g.setPaint(strokeColor);
                g.draw(shape);
            }
        } else if (shape instanceof RectangularShape) {
            RectangularShape r = (RectangularShape)shape;
            double xx = r.getX();
            double ww = r.getWidth();
            double yy = r.getY();
            double hh = r.getHeight();
            int x = (int)xx;
            int y = (int)yy;
            int w = (int)(ww + xx - (double)x);
            int h = (int)(hh + yy - (double)y);
            if (shape instanceof Rectangle2D) {
                if (fdraw) {
                    g.setPaint(fillColor);
                    g.fillRect(x, y, w, h);
                }
                if (sdraw) {
                    g.setPaint(strokeColor);
                    g.drawRect(x, y, w, h);
                }
            } else if (shape instanceof RoundRectangle2D) {
                RoundRectangle2D rr = (RoundRectangle2D)shape;
                int aw = (int)rr.getArcWidth();
                int ah = (int)rr.getArcHeight();
                if (fdraw) {
                    g.setPaint(fillColor);
                    g.fillRoundRect(x, y, w, h, aw, ah);
                }
                if (sdraw) {
                    g.setPaint(strokeColor);
                    g.drawRoundRect(x, y, w, h, aw, ah);
                }
            } else if (shape instanceof Ellipse2D) {
                if (fdraw) {
                    g.setPaint(fillColor);
                    g.fillOval(x, y, w, h);
                }
                if (sdraw) {
                    g.setPaint(strokeColor);
                    g.drawOval(x, y, w, h);
                }
            } else {
                if (fdraw) {
                    g.setPaint(fillColor);
                    g.fill(shape);
                }
                if (sdraw) {
                    g.setPaint(strokeColor);
                    g.draw(shape);
                }
            }
        } else if (shape instanceof Line2D) {
            if (sdraw) {
                Line2D l = (Line2D)shape;
                int x = (int)(l.getX1() + 0.5);
                int y = (int)(l.getY1() + 0.5);
                int w = (int)(l.getX2() + 0.5);
                int h = (int)(l.getY2() + 0.5);
                g.setPaint(strokeColor);
                g.drawLine(x, y, w, h);
            }
        } else {
            if (fdraw) {
                g.setPaint(fillColor);
                g.fill(shape);
            }
            if (sdraw) {
                g.setPaint(strokeColor);
                g.draw(shape);
            }
        }
        if (sdraw) {
            g.setStroke(origStroke);
        }
    }
}

